///////////////////////////////////////////////////////////////////////////////
// This file is part of LanguageManager.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
// LanguageManager is one of modules for SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public Licence along
// with this program.
// If not, see <http://www.microsoft.com/opensource/licences.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: LmgrProp.cs, LmgrProp.Designer.cs
// Author: bis5
// module: LanguageManager
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Bis5Products.SharpWebBrowser {
    public partial class LmgrProp : UserControl, ISWBPropertySheet {
        public LmgrProp() {
            InitializeComponent();
        }
        public LmgrProp(ConfigurationManager cm, LanguageManager lm)
            : this() {
            cmgr = cm;
            lmgr = lm;
            Load();
        }

        private LanguageManager lmgr;
        private ConfigurationManager cmgr;

        public new void Load() {
            this.comboBox1.Items.Clear();

            this.groupBox1.Text = lmgr.Get("LanguageManager_Prop_groupBox1");

            string[] list = lmgr.GetConfFiles();

            for (int i = 0; i < list.Length; i++) {
                string name = list[i];
                name.Replace(".config", "");
                name = System.Text.RegularExpressions.Regex.Match(name, "[^\\\\]+.config$").Value;
                name = name.Replace(".config", "");
                this.comboBox1.Items.Add(name);
            }

            string lang = cmgr.GetStr("Language");
            foreach (var item in this.comboBox1.Items) {
                if (System.Text.RegularExpressions.Regex.IsMatch(item.ToString(), "^" + lang + "$")) {
                    this.comboBox1.SelectedItem = item;
                    break;
                }
            }

        }

        public void Commit() {
            string oldlang = cmgr.GetStr("Language");
            cmgr.Set("Language", this.comboBox1.SelectedItem.ToString());
            if (!lmgr.ChangeLang()) {
                //何らかの原因で言語を変更できなかったとき、元の設定に戻す
                cmgr.Set("Language", oldlang);
                lmgr.Load();
            }
        }

        public string GetPropertySheetName() {
            return lmgr.Get("LanguageManagerProp");
        }

    }
}