%define current_kernel %(uname -r)

%global debug_package %{nil}
%global firmware_release 2

%global _firmwarepath   /usr/lib/firmware
%define _binaries_in_noarch_packages_terminate_build 0

Name:           mssl1680-firmware-jumper-ezpad6pro
Version:        1.0.git20201209.e247c34
Release:        %{firmware_release}%{?dist}
Summary:	Firmware images for the Silead touchscreen controllers in Jumper EZpad 6 pro
License:        Proprietary
Group:          Hardware/Other
URL:            https://github.com/onitake/gsl-firmware
BuildArch:      noarch
Source:         gsl-firmware-%{version}.tar.xz
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
This is a screentouch firmware for Jumper EZpad 6 pro.

Gsl-firmware repository contains firmware images for the Silead touchscreen controllers in various tablet (and other) devices.

There is also a number of conversion tools here that help with extraction and preparation of firmware images.

The firmware files were extracted from Android and Windows device drivers, as published by device manufacturers. They are intended for people who prefer to replace the shipped operating system with a generic Linux distribution such as Debian or Ubuntu.

The files may be covered by proprietary licenses or copyright. Please consult the manufacturer's website or device documentation for more information.

In contrast, everything in the tools directory is published under the GNU General Public license v2, as laid out in tools/LICENSE.

%prep
%setup -n gsl-firmware-%{version}

%build

%install
mkdir -p %{buildroot}%{_firmwarepath}/silead
cp -r firmware/linux/silead/gsl3692-jumper-ezpad-6-pro-b.fw %{buildroot}%{_firmwarepath}/silead/mssl1680.fw

%post
%postun

%files
%defattr(-,root,root)
%doc firmware/jumper/Ezpad_6_pro_b/README.md
%dir %{_firmwarepath}
%{_firmwarepath}/*

%changelog
* Thu Jan 14 2021 Fuhito Suguri <bitwalk@users.sourceforge.net> - 1.0.git20201209.e247c34-2
- correct firmware license to 'Proprietary'.
- change firmwre from gsl3692-jumper-ezpad-6-pro.fw to gsl3692-jumper-ezpad-6-pro-b.fw.

* Sat Jan 09 2021 Fuhito Suguri <bitwalk@users.sourceforge.net> - 1.0.git20201209.e247c34-1
- initial version from upstream
