/**
 * SuperC System que process
 *
 *
 */

.incdir "./include/"
.include "spc.inc"
.include "var.inc"

.section "__que__" free
;--------------------------------------------------
; QueProc - SYSTEM QUE PROCESS
;   Level       : 0 (Clock Level)
;   Input       : none
;   Output      : none
;   Description : キュー制御プログラム
;                 タイマ待ちの間に先行してできる
;                 処理の制御を行う
;--------------------------------------------------
.define queTmp $00

QueProc:
	mov   x,dpQueTail                        ; キュー末尾
	cmp   x,dpQueHead                        ; キュー先頭と比較
	bne   _QueExec                           ; キューが空なら
	ret                                      ;  -->何もしない
_QueExec:
	setp                                     ; dp = $0100～$01ff
	mov   a,(x)+                             ; キュー読み出し(Function, Input1)
	push  a                                  ; 一時退避
	mov   a,x
	and   a,#QUEMASK                         ; キュー読み出し先をひとつ進める
	mov   x,a                                ; Xに戻す
	mov   a,(x)+                             ; キュー読み出し(Input2)
	mov   y,a                                ; Yに保存
	mov   a,x
	mov   a,#QUEMASK                         ; キュー読み出し先をひとつ進める
	clrp                                     ; dp = $0000～$00ff
	mov   dpQueTail,a                        ; キュー末尾を移動してキューデータを１つ減らしました
	pop   a                                  ; 退避データ復旧(Function, Input1)
	mov   queTmp,a                           ; 計算用に一時退避
	and   a,#$f0                             ; Function MASK
	lsr   a
	lsr   a
	lsr   a                                  ; Function をテーブルジャンプ用に調整
	mov   x,a                                ; X=テーブルインデックス
	mov   a,queTmp                           ; データ復帰
	and   a,#$0f                             ; TrackNo を取り出す
	jmp   [!_jmpTable+x]                     ; 各処理へ分岐させる

;--------------------------------------------------
; << コマンドジャンプ時の入力データ >>
; Ａレジスタ -- Input1(TrkNo.等に使用)
; Ｙレジスタ -- Input2(処理用データ等)
;--------------------------------------------------
_jmpTable:
	.dw   NULL   ; QF=0  : 
	.dw   NULL   ; QF=1  : 
	.dw   NULL   ; QF=2  : 
	.dw   NULL   ; QF=3  : 
	.dw   NULL   ; QF=4  : 
	.dw   NULL   ; QF=5  : 
	.dw   NULL   ; QF=6  : 
	.dw   NULL   ; QF=7  : 
	.dw   NULL   ; QF=8  : 
	.dw   NULL   ; QF=9  : 
	.dw   NULL   ; QF=10 : 
	.dw   NULL   ; QF=11 : 
	.dw   NULL   ; QF=12 : 
	.dw   NULL   ; QF=13 : 
	.dw   NULL   ; QF=14 : 
	.dw   NULL   ; QF=15 : 

;--------------------------------------------------
; QueDelete - SYSTEM QUE PROCESS
;   Level       : 0 (Clock Level)
;   Input       : none
;   Output      : none
;   Description : キュー制御プログラム
;                 キューに残っているデータを全て
;                 片付けて、キューを空にする
;--------------------------------------------------
_QueExecLoop:
	call  _QueExec                           ; キューが空になるまでコールされる
QueDelete:
	mov   x,dpQueTail                        ; キュー末尾
	cmp   x,dpQueHead                        ; キュー先頭と比較
	bne   _QueExecLoop                       ; キューに処理が残ってる場合はキュー処理ループ
	ret                                      ; 消化完了
.ends

