/*
 * $Id: Pointer.h,v 1.4 2007-08-18 08:52:18 maya Exp $
 */

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef _YCL_POINTER_H_
#define _YCL_POINTER_H_

#include <YCL/Array.h>

namespace yebisuya {
    
// |C^bv邽߂̃NXB
template<class TYPE, class REFCTRL = Object >
class Pointer {
private:
    // i[|C^
    TYPE* value;
protected:
    // |C^u
    void set(TYPE* ptr) {
	value = (TYPE*) REFCTRL::set(value, ptr);
    }
public:
    // ftHgRXgN^
    Pointer():value(NULL) {
    }
    // ltRXgN^
    Pointer(TYPE* ptr):value(NULL) {
	set(ptr);
    }
    // Rs[RXgN^
    Pointer(const Pointer& ptr):value(NULL) {
	set(ptr.value);
    }
    // fXgN^
    ~Pointer() {
	set(NULL);
    }
    // Zq
    Pointer& operator=(TYPE* ptr) {
	set(ptr);
	return *this;
    }
    // Rs[Zq
    Pointer& operator=(const Pointer& ptr) {
	set(ptr.value);
	return *this;
    }
    // ԐډZq
    TYPE& operator*()const {
	return *value;
    }
    // oIZq
    TYPE* operator->()const {
	return value;
    }
    // LXgZq
    operator TYPE*()const {
	return value;
    }
};
    
// PointerArray<TYPE>^ւ̓ꉻ
// zvfZq[]񋟂
template<class TYPE>
class PointerArray : public Pointer< Array<TYPE> > {
public:
    // ftHgRXgN^
    PointerArray() {
    }
    // ltRXgN^
    PointerArray(Array<TYPE>* ptr):Pointer< Array<TYPE> >(ptr) {
    }
    // Rs[RXgN^
    PointerArray(const PointerArray& ptr):Pointer< Array<TYPE> >(ptr) {
    }
    // Zq
    PointerArray& operator=(Array<TYPE>* ptr) {
	set(ptr);
	return *this;
    }
    // zvfZq
    TYPE& operator[](int index) {
	Array<TYPE>* ptr = *this;
	return (**this)[index];
    }
    TYPE operator[](int index)const {
	Array<TYPE>* ptr = *this;
	return (**this)[index];
    }
};
    
}

#endif//_YCL_POINTER_H_
