/*
	OSEK/VDX Version. 2.2.3 

	Copyright (C) 2012
	  by Kohei Matsumoto <kouhei_3hips@hotmail.com>
*/

#ifndef __OSEK_H__
#define __OSEK_H__

/* ---- types ---- */
typedef char			B;
typedef short			H;
typedef int				W;

typedef unsigned char	UB;
typedef unsigned short	UH;
typedef unsigned int	UW;

/* 12.2.2 Legitimacy of calls */
#define LvNULL				((UH) 0x0000U)
#define LvTask				((UH) 0x0001U)
#define LvISR1				((UH) 0x0002U)
#define LvISR2				((UH) 0x0004U)
#define LvErrHook			((UH) 0x0008U)
#define LvPreTaskHook		((UH) 0x0010U)
#define LvPostTaskHook		((UH) 0x0020U)
#define LvStartupHook		((UH) 0x0040U)
#define LvShutdownHook		((UH) 0x0080U)
#define LvAlarmCallback		((UH) 0x0100U)

extern UH runlevel;

#define IsLv(lv) (((lv) == runlevel) ? TRUE : FALSE)

/* ---- 13.1 Common data types ---- */
typedef enum {
	E_OK			= 0,
	E_OS_ACCESS		= 1,
	E_OS_CALLEVEL	= 2,
	E_OS_ID			= 3,
	E_OS_LIMIT		= 4,
	E_OS_NOFUNC		= 5,
	E_OS_RESOURCE	= 6,
	E_OS_STATE		= 7,
	E_OS_VALUE		= 8
} StatusType;


/* ---- 13.2 Task management ---- */
/* 13.2.1 Data types */
typedef UB				TaskType;
typedef TaskType*		TaskRefType;
typedef UB				TaskStateType;
typedef TaskStateType*	TaskStateRefType;
typedef UB				Priority;

#define TASKID_NULL		((TaskType) ~0x00U)

/* 13.2.2 Constructional elements */
#define DeclareTask(TaskIdentifier)	\
	extern const TaskType TaskIdentifier

/* 13.2.3 System services */
extern StatusType ActiveTask(TaskType);
extern StatusType TerminateTask(void);
extern StatusType ChainTask(TaskType TaskID);
extern StatusType Schedule(void);
extern StatusType GetTaskID(TaskRefType TaskID);
extern StatusType GetTaskState(TaskType TaskID,
							   TaskStateRefType State);

/* 13.2.4 Constands */
#define RUNNING			((TaskStateType) 0x01)
#define WAITING			((TaskStateType) 0x02)
#define READY			((TaskStateType) 0x03)
#define SUSPEND			((TaskStateType) 0x04)
#define INVALID_TASK	((TaskStateType) ~0x00U)

/* 13.2.5 Naming convention */
#define TASK(TaskName)	void _##TaskName(void)


/* ---- 13.3 Interrupt handling ---- */
/* 13.3.1 Data types*/
/* No special data types are defined */

/* 13.3.2 System services */
extern void EnableAllInterrupts(void);
extern void DisableAllInterrupts(void);
extern void ResumeAllInterrupts(void);
extern void SuspendAllInterrupts(void);
extern void ResumeOSInterrupts(void);
extern void SuspendOSInterrupts(void);

/* 13.3.3 Naming convention */
#define ISR(FuncName)	void _##IsrName(void)


/* ---- 13.4 Resource management ---- */
/* 13.4.1 Data types */
typedef UB	ResourceType;
#define DeclareResource(ResourceIdentifier)	\
	extern const ResourceType ResourceIdentifier.

/* 13.4.3 System services */
extern StatusType GetResource(ResourceType ResID);
extern StatusType ReleaseResource(ResourceType ResID);

/* 13.4.4 Constants */
#define RES_SCHEDULER	((ResourceType) 1);


/* ---- 13.5 Event control ---- */
/* 13.5.1 Data types */
typedef UB				EventMaskType;
typedef EventMaskType*	EventMaskRefType;

/* 13.5.2 Constructional elements */
#define DeclareEvent(EventIdentifier) \
	extern const EventMaskType EventIdentifier;

/* 13.5.3 System services */
extern StatusType SetEvent(TaskType TaskID,
						   EventMaskType Mask);
extern StatusType ClearEvent(EventMaskType Mask);
extern StatusType GetEvent(TaskType TaskID,
						   EventMaskRefType Event);
extern StatusType WaitEvent(EventMaskType Mask);


/* ---- 13.6 Alarms ---- */
/* 13.6.1 Data types */
typedef UB				TickType;
typedef TickType*		TickRefType;
typedef struct {
	UB	maxallowedvalue;
	UB	ticksperbase;
	UB	mincycle;
}						AlarmBaseType; 
typedef AlarmBaseType*	AlarmBaseRefType;
typedef UB				AlarmType;

/* 13.6.2 Constructional elements */
#define DeclareAlarm(AlarmIdentifier) \
	extern const AlarmIdentifier;

/* 13.6.3 System services */
extern StatusType GetAlarmBase(AlarmType AlarmID,
							   AlarmBaseRefType info);
extern StatusType GetAlarm(AlarmType AlarmID,
						   TickRefType Tick);
extern StatusType SetRelAlarm(AlarmType AlarmID,
							  TickType increment,
							  TickType cycle);
extern StatusType SetAbsAlarm(AlarmType AlarmID,
							  TickType start,
							  TickType cycle);
extern StatusType CancelAlarm(AlarmType AlarmID);

/* Constans */
#define OSMAXALLOWEDVALUE_x	(0)
#define OSTICKSPERBASE_x	(0)
#define OSMINCYCLE_x		(0)
#define OSTICKSPERBASE		(0)
#define OSMINCYCLE			(0)
#define OSTICKDURATION		(0)

/* 13.6.5 Naming convention */
#define ALARMCALLBACK(ALARMCallBackName) \
	static void _##ALARMCallBackName(void)


/* ---- Operating system execution control -- */
/* 13.7.1 Data types */
typedef UB	AppModeType;

/* 13.7.2 System services */
extern AppModeType GetActiveApplicationMode(void);
extern void StartOS(AppModeType Mode);
extern void ShutdownOS(StatusType Error);

/* 13.7.3 Constants */
#define OSDEFAULTAPPMODE ((AppModeType) 0)


/* ---- 13.8 Hook routine ---- */
/* 13.8.1 Data Types */
typedef UB	OSServiceIdType;

/* 13.8.2 System services */
extern void ErrorHook(StatusType Error);
extern void PreTaskHook(void);
extern void PostTaskHook(void);
extern void StartupHook(void);
extern void ShutdownHook(StatusType Error);

/* 13.8.3 Constants */
#define OSServiceID_ActiveTask		((OSServiceIdType) 0)
#define OSServiceID_TerminateTask	((OSServiceIdType) 1)
#define OSServiceID_ChainTask		((OSServiceIdType) 2)
#define OSServiceID_Schedule		((OSServiceIdType) 3)
#define OSServiceID_GetTaskID		((OSServiceIdType) 4)
#define OSServiceID_GetTaskState	((OSServiceIdType) 5)
#define OSServiceID_EnableAllInterrupts \
									((OSServiceIdType) 6)
#define OSServiceID_DisableAllInterrupts \
									((OSServiceIdType) 7)
#define OSServiceID_ResumeAllInterrupts \
									((OSServiceIdType) 8)
#define OSServiceID_SuspendAllInterrupts \
									((OSServiceIdType) 9)
#define OSServiceID_ResumeOSInterrupts \
									((OSServiceIdType) 10)
#define OSServiceID_SuspendOSInterrupts \
									((OSServiceIdType) 11)
#define OSServiceID_GetResource		((OSServiceIdType) 12)
#define OSServiceID_ReleaseResource	((OSServiceIdType) 13)
#define OSServiceID_SetEvent		((OSServiceIdType) 14)
#define OSServiceID_ClearEvent		((OSServiceIdType) 15)
#define OSServiceID_GetEvent		((OSServiceIdType) 16)
#define OSServiceID_WaitEvent		((OSServiceIdType) 17)
#define OSServiceID_GetAlarmBase	((OSServiceIdType) 18)
#define OSServiceID_GetAlarm		((OSServiceIdType) 19)
#define OSServiceID_SetRelAlarm		((OSServiceIdType) 20)
#define OSServiceID_SetAbsAlarm		((OSServiceIdType) 21)
#define OSServiceID_CancelAlarm		((OSServiceIdType) 22)
#define OSServiceID_GetActiveApplicationMode \
									((OSServiceIdType) 23)
#define OSServiceID_StartOS			((OSServiceIdType) 24)
#define OSServiceID_ShutdownOS		((OSServiceIdType) 25)
#define OSServiceID_ErrorHook		((OSServiceIdType) 26)
#define OSServiceID_PreTaskHook		((OSServiceIdType) 27)
#define OSServiceID_PostTaskHook	((OSServiceIdType) 28)
#define OSServiceID_StartupHook		((OSServiceIdType) 29)
#define OSServiceID_ShutdownHook	((OSServiceIdType) 30)

/* 13.8.4 Macros */
extern OSServiceIdType	ErrorHook_Id;

#define OSErrorGetServiceId()		(ErrorHook_Id)

typedef UB BOOL;
#define NULL	((void*) 0)
#define TRUE	((UB) 0x01U)
#define FALSE	((UB) 0x00U)

#define lock()		do { ; } while(0);
#define unlock()	do { ; } while(0); 

typedef struct {
	TaskType	id;
} TCB;

typedef struct t_queue {
	struct t_queue * next;
} QUEUE;

#endif /* __OSEK_H__ */

