#include "task.h"

TaskType      runtask;
TaskStateType tstate[NUM_TASK];
Priority      tpri[NUM_TASK];
TaskType      tque[NUM_PRIORITY][NUM_TASK];
UB            tque_num[NUM_PRIORITY];
UH            tact[NUM_TASK];
CONTEXT       tcontext[NUM_TASK];

static
TaskType pop_ready(Priority pri)
{
	int i;
	TaskType TaskID;

	if ( tque_num[pri] == 0 ) {
		return TASKID_NULL;
	}

	TaskID = tque[pri][0];

	for ( i = 0; i < tque_num[pri]; i++ )
	{
		if ( i == (NUM_TASK-1)) {
			tque[pri][i] = TASKID_NULL;
		}
		else {
			tque[pri][i] = tque[pri][i + 1];
		}
	}

	tque_num[pri]--;

	return TaskID;
}

static
void push_ready(Priority pri, TaskType TaskID)
{
	int i;

	i = tque_num[pri];
	tque[pri][i] = TaskID;
	tque_num[pri]++;
}

void init(void)
{
}

BOOL activate(TaskType TaskID)
{
	if ( tstate[TaskID] == SUSPEND ) {
		tstate[TaskID] = READY;
		return TRUE;
	}

	return FALSE;
}

BOOL terminate(TaskType TaskID)
{
	if ( tstate[TaskID] == RUNNING ) {
		tstate[TaskID] = SUSPEND;
		return TRUE;
	}

	return FALSE;
}

BOOL start(TaskType TaskID)
{
	if (tstate[TaskID] == READY) {
		tstate[TaskID] = RUNNING;
		switch_to(&tcontext[runtask], &tcontext[TaskID]);
		runtask = TaskID;
		return TRUE;
	}

	return FALSE;
}

BOOL preempt(TaskType TaskID)
{
	if ( tstate[TaskID] == RUNNING ) {
		tstate[TaskID] = READY;
		push_ready(tpri[TaskID], TaskID);
		return TRUE;
	}

	return FALSE;
}

BOOL wait(TaskType TaskID)
{
	if ( tstate[TaskID] == RUNNING ) {
		tstate[TaskID] = WAITING;
		return TRUE;
	}

	return FALSE;
}

void dispatch(void)
{
	Priority pri;
	TaskType readytask;

	lock();

	for (pri = 0;
		 pri < NUM_PRIORITY;
		 pri++)
	{
		while(tque_num[pri]) {
			readytask = pop_ready(pri);
			preempt(runtask);
			start(readytask);
			goto exit;
		}
	}

exit:
	unlock();
}

