/*
	13.2 Task management (OSEK/VDX Version. 2.2.3)

	Copyright (C) 2012
	  by Kohei Matsumoto <kouhei_3hips@hotmail.com>
*/
#include <kernel.h>
#include "task.h"

UH			runlevel;

#define ERRCHK_TaskID(TaskID) \
	if ((TaskID) >= NUM_TASK) { \
		ret = E_OS_ID; \
		goto error0; \
	}

StatusType
ActivateTask(TaskType TaskID)
{
	StatusType ret = E_OK;

	ERRCHK_TaskID(TaskID);

	lock();

	if ( IsLv(LvTask) && activate(TaskID) ) {
		dispatch();
	}
	else if (tact[TaskID] < 256) {
		tact[TaskID]++;
	}
#ifdef EXTENDED
	else {
		ret = E_OS_LIMIT;
		goto error;
	}
#endif

exit:
	unlock();
	return ret;
error0:
	lock();
error:
	goto exit;
}

StatusType
TerminateTask(void)
{
	StatusType ret = E_OK;

	lock();
	terminate(runtask);
	dispatch();
exit:
	unlock();
	return ret;
}

StatusType
ChainTask(TaskType TaskID)
{
	StatusType ret = E_OK;

	ERRCHK_TaskID(TaskID);

	lock();

	if ( TaskID != runtask ) {
		terminate(TaskID);
		dispatch();
	}

exit:
	unlock();
	return ret;
error0:
	lock();
error:
	goto exit;
}

StatusType
Schedule(void)
{
	StatusType ret = E_OK;

	lock();
	dispatch();
exit:
	unlock();
	return ret;
}

StatusType
GetTaskID(TaskRefType TaskID)
{
	StatusType ret = E_OK;

	lock();
	*TaskID = runtask;
exit:
	unlock();
	return ret;
error0:
	lock();
error:
	goto exit;
}

StatusType
GetTaskState(TaskType TaskID,
			 TaskStateRefType State)
{
	StatusType ret = E_OK;

	ERRCHK_TaskID(TaskID);

	lock();
	*State = tstate[TaskID];
exit:
	unlock();
	return ret;
error0:
	lock();
error:
	goto exit;
}

