/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * !! Do not reference this file directly !!
 *
 * It is logically a part of camera_metadata.c.  It is broken out for ease of
 * maintaining the tag info.
 *
 * Array assignments are done using specified-index syntax to keep things in
 * sync with camera_metadata_tags.h
 */

/**
 * ! Do not edit this file directly !
 *
 * Generated automatically from camera_metadata_tag_info.mako
 */

const char *camera_metadata_section_names[ANDROID_SECTION_COUNT] = {
    [ANDROID_COLOR_CORRECTION]     = "android.colorCorrection",
    [ANDROID_CONTROL]              = "android.control",
    [ANDROID_DEMOSAIC]             = "android.demosaic",
    [ANDROID_EDGE]                 = "android.edge",
    [ANDROID_FLASH]                = "android.flash",
    [ANDROID_FLASH_INFO]           = "android.flash.info",
    [ANDROID_GEOMETRIC]            = "android.geometric",
    [ANDROID_HOT_PIXEL]            = "android.hotPixel",
    [ANDROID_HOT_PIXEL_INFO]       = "android.hotPixel.info",
    [ANDROID_JPEG]                 = "android.jpeg",
    [ANDROID_LENS]                 = "android.lens",
    [ANDROID_LENS_INFO]            = "android.lens.info",
    [ANDROID_NOISE_REDUCTION]      = "android.noiseReduction",
    [ANDROID_QUIRKS]               = "android.quirks",
    [ANDROID_REQUEST]              = "android.request",
    [ANDROID_SCALER]               = "android.scaler",
    [ANDROID_SENSOR]               = "android.sensor",
    [ANDROID_SENSOR_INFO]          = "android.sensor.info",
    [ANDROID_SHADING]              = "android.shading",
    [ANDROID_STATISTICS]           = "android.statistics",
    [ANDROID_STATISTICS_INFO]      = "android.statistics.info",
    [ANDROID_TONEMAP]              = "android.tonemap",
};

unsigned int camera_metadata_section_bounds[ANDROID_SECTION_COUNT][2] = {
    [ANDROID_COLOR_CORRECTION]     = { ANDROID_COLOR_CORRECTION_START,
                                       ANDROID_COLOR_CORRECTION_END },
    [ANDROID_CONTROL]              = { ANDROID_CONTROL_START,
                                       ANDROID_CONTROL_END },
    [ANDROID_DEMOSAIC]             = { ANDROID_DEMOSAIC_START,
                                       ANDROID_DEMOSAIC_END },
    [ANDROID_EDGE]                 = { ANDROID_EDGE_START,
                                       ANDROID_EDGE_END },
    [ANDROID_FLASH]                = { ANDROID_FLASH_START,
                                       ANDROID_FLASH_END },
    [ANDROID_FLASH_INFO]           = { ANDROID_FLASH_INFO_START,
                                       ANDROID_FLASH_INFO_END },
    [ANDROID_GEOMETRIC]            = { ANDROID_GEOMETRIC_START,
                                       ANDROID_GEOMETRIC_END },
    [ANDROID_HOT_PIXEL]            = { ANDROID_HOT_PIXEL_START,
                                       ANDROID_HOT_PIXEL_END },
    [ANDROID_HOT_PIXEL_INFO]       = { ANDROID_HOT_PIXEL_INFO_START,
                                       ANDROID_HOT_PIXEL_INFO_END },
    [ANDROID_JPEG]                 = { ANDROID_JPEG_START,
                                       ANDROID_JPEG_END },
    [ANDROID_LENS]                 = { ANDROID_LENS_START,
                                       ANDROID_LENS_END },
    [ANDROID_LENS_INFO]            = { ANDROID_LENS_INFO_START,
                                       ANDROID_LENS_INFO_END },
    [ANDROID_NOISE_REDUCTION]      = { ANDROID_NOISE_REDUCTION_START,
                                       ANDROID_NOISE_REDUCTION_END },
    [ANDROID_QUIRKS]               = { ANDROID_QUIRKS_START,
                                       ANDROID_QUIRKS_END },
    [ANDROID_REQUEST]              = { ANDROID_REQUEST_START,
                                       ANDROID_REQUEST_END },
    [ANDROID_SCALER]               = { ANDROID_SCALER_START,
                                       ANDROID_SCALER_END },
    [ANDROID_SENSOR]               = { ANDROID_SENSOR_START,
                                       ANDROID_SENSOR_END },
    [ANDROID_SENSOR_INFO]          = { ANDROID_SENSOR_INFO_START,
                                       ANDROID_SENSOR_INFO_END },
    [ANDROID_SHADING]              = { ANDROID_SHADING_START,
                                       ANDROID_SHADING_END },
    [ANDROID_STATISTICS]           = { ANDROID_STATISTICS_START,
                                       ANDROID_STATISTICS_END },
    [ANDROID_STATISTICS_INFO]      = { ANDROID_STATISTICS_INFO_START,
                                       ANDROID_STATISTICS_INFO_END },
    [ANDROID_TONEMAP]              = { ANDROID_TONEMAP_START,
                                       ANDROID_TONEMAP_END },
};

static tag_info_t android_color_correction[ANDROID_COLOR_CORRECTION_END -
        ANDROID_COLOR_CORRECTION_START] = {
    [ ANDROID_COLOR_CORRECTION_MODE - ANDROID_COLOR_CORRECTION_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_COLOR_CORRECTION_TRANSFORM - ANDROID_COLOR_CORRECTION_START ] =
    { "transform",                     TYPE_FLOAT  },
};

static tag_info_t android_control[ANDROID_CONTROL_END -
        ANDROID_CONTROL_START] = {
    [ ANDROID_CONTROL_AE_ANTIBANDING_MODE - ANDROID_CONTROL_START ] =
    { "aeAntibandingMode",             TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_EXPOSURE_COMPENSATION - ANDROID_CONTROL_START ] =
    { "aeExposureCompensation",        TYPE_INT32  },
    [ ANDROID_CONTROL_AE_LOCK - ANDROID_CONTROL_START ] =
    { "aeLock",                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_MODE - ANDROID_CONTROL_START ] =
    { "aeMode",                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_REGIONS - ANDROID_CONTROL_START ] =
    { "aeRegions",                     TYPE_INT32  },
    [ ANDROID_CONTROL_AE_TARGET_FPS_RANGE - ANDROID_CONTROL_START ] =
    { "aeTargetFpsRange",              TYPE_INT32  },
    [ ANDROID_CONTROL_AF_MODE - ANDROID_CONTROL_START ] =
    { "afMode",                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AF_REGIONS - ANDROID_CONTROL_START ] =
    { "afRegions",                     TYPE_INT32  },
    [ ANDROID_CONTROL_AWB_LOCK - ANDROID_CONTROL_START ] =
    { "awbLock",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AWB_MODE - ANDROID_CONTROL_START ] =
    { "awbMode",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AWB_REGIONS - ANDROID_CONTROL_START ] =
    { "awbRegions",                    TYPE_INT32  },
    [ ANDROID_CONTROL_CAPTURE_INTENT - ANDROID_CONTROL_START ] =
    { "captureIntent",                 TYPE_BYTE   },
    [ ANDROID_CONTROL_EFFECT_MODE - ANDROID_CONTROL_START ] =
    { "effectMode",                    TYPE_BYTE   },
    [ ANDROID_CONTROL_MODE - ANDROID_CONTROL_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_CONTROL_SCENE_MODE - ANDROID_CONTROL_START ] =
    { "sceneMode",                     TYPE_BYTE   },
    [ ANDROID_CONTROL_VIDEO_STABILIZATION_MODE - ANDROID_CONTROL_START ] =
    { "videoStabilizationMode",        TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_AVAILABLE_ANTIBANDING_MODES - ANDROID_CONTROL_START ] =
    { "aeAvailableAntibandingModes",   TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_AVAILABLE_MODES - ANDROID_CONTROL_START ] =
    { "aeAvailableModes",              TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES - ANDROID_CONTROL_START ] =
    { "aeAvailableTargetFpsRanges",    TYPE_INT32  },
    [ ANDROID_CONTROL_AE_COMPENSATION_RANGE - ANDROID_CONTROL_START ] =
    { "aeCompensationRange",           TYPE_INT32  },
    [ ANDROID_CONTROL_AE_COMPENSATION_STEP - ANDROID_CONTROL_START ] =
    { "aeCompensationStep",            TYPE_RATIONAL
                },
    [ ANDROID_CONTROL_AF_AVAILABLE_MODES - ANDROID_CONTROL_START ] =
    { "afAvailableModes",              TYPE_BYTE   },
    [ ANDROID_CONTROL_AVAILABLE_EFFECTS - ANDROID_CONTROL_START ] =
    { "availableEffects",              TYPE_BYTE   },
    [ ANDROID_CONTROL_AVAILABLE_SCENE_MODES - ANDROID_CONTROL_START ] =
    { "availableSceneModes",           TYPE_BYTE   },
    [ ANDROID_CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES - ANDROID_CONTROL_START ] =
    { "availableVideoStabilizationModes",
                                        TYPE_BYTE   },
    [ ANDROID_CONTROL_AWB_AVAILABLE_MODES - ANDROID_CONTROL_START ] =
    { "awbAvailableModes",             TYPE_BYTE   },
    [ ANDROID_CONTROL_MAX_REGIONS - ANDROID_CONTROL_START ] =
    { "maxRegions",                    TYPE_INT32  },
    [ ANDROID_CONTROL_SCENE_MODE_OVERRIDES - ANDROID_CONTROL_START ] =
    { "sceneModeOverrides",            TYPE_BYTE   },
    [ ANDROID_CONTROL_AE_PRECAPTURE_ID - ANDROID_CONTROL_START ] =
    { "aePrecaptureId",                TYPE_INT32  },
    [ ANDROID_CONTROL_AE_STATE - ANDROID_CONTROL_START ] =
    { "aeState",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AF_STATE - ANDROID_CONTROL_START ] =
    { "afState",                       TYPE_BYTE   },
    [ ANDROID_CONTROL_AF_TRIGGER_ID - ANDROID_CONTROL_START ] =
    { "afTriggerId",                   TYPE_INT32  },
    [ ANDROID_CONTROL_AWB_STATE - ANDROID_CONTROL_START ] =
    { "awbState",                      TYPE_BYTE   },
};

static tag_info_t android_demosaic[ANDROID_DEMOSAIC_END -
        ANDROID_DEMOSAIC_START] = {
    [ ANDROID_DEMOSAIC_MODE - ANDROID_DEMOSAIC_START ] =
    { "mode",                          TYPE_BYTE   },
};

static tag_info_t android_edge[ANDROID_EDGE_END -
        ANDROID_EDGE_START] = {
    [ ANDROID_EDGE_MODE - ANDROID_EDGE_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_EDGE_STRENGTH - ANDROID_EDGE_START ] =
    { "strength",                      TYPE_BYTE   },
};

static tag_info_t android_flash[ANDROID_FLASH_END -
        ANDROID_FLASH_START] = {
    [ ANDROID_FLASH_FIRING_POWER - ANDROID_FLASH_START ] =
    { "firingPower",                   TYPE_BYTE   },
    [ ANDROID_FLASH_FIRING_TIME - ANDROID_FLASH_START ] =
    { "firingTime",                    TYPE_INT64  },
    [ ANDROID_FLASH_MODE - ANDROID_FLASH_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_FLASH_COLOR_TEMPERATURE - ANDROID_FLASH_START ] =
    { "colorTemperature",              TYPE_BYTE   },
    [ ANDROID_FLASH_MAX_ENERGY - ANDROID_FLASH_START ] =
    { "maxEnergy",                     TYPE_BYTE   },
    [ ANDROID_FLASH_STATE - ANDROID_FLASH_START ] =
    { "state",                         TYPE_BYTE   },
};

static tag_info_t android_flash_info[ANDROID_FLASH_INFO_END -
        ANDROID_FLASH_INFO_START] = {
    [ ANDROID_FLASH_INFO_AVAILABLE - ANDROID_FLASH_INFO_START ] =
    { "available",                     TYPE_BYTE   },
    [ ANDROID_FLASH_INFO_CHARGE_DURATION - ANDROID_FLASH_INFO_START ] =
    { "chargeDuration",                TYPE_INT64  },
};

static tag_info_t android_geometric[ANDROID_GEOMETRIC_END -
        ANDROID_GEOMETRIC_START] = {
    [ ANDROID_GEOMETRIC_MODE - ANDROID_GEOMETRIC_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_GEOMETRIC_STRENGTH - ANDROID_GEOMETRIC_START ] =
    { "strength",                      TYPE_BYTE   },
};

static tag_info_t android_hot_pixel[ANDROID_HOT_PIXEL_END -
        ANDROID_HOT_PIXEL_START] = {
    [ ANDROID_HOT_PIXEL_MODE - ANDROID_HOT_PIXEL_START ] =
    { "mode",                          TYPE_BYTE   },
};

static tag_info_t android_hot_pixel_info[ANDROID_HOT_PIXEL_INFO_END -
        ANDROID_HOT_PIXEL_INFO_START] = {
    [ ANDROID_HOT_PIXEL_INFO_MAP - ANDROID_HOT_PIXEL_INFO_START ] =
    { "map",                           TYPE_INT32  },
};

static tag_info_t android_jpeg[ANDROID_JPEG_END -
        ANDROID_JPEG_START] = {
    [ ANDROID_JPEG_GPS_COORDINATES - ANDROID_JPEG_START ] =
    { "gpsCoordinates",                TYPE_DOUBLE },
    [ ANDROID_JPEG_GPS_PROCESSING_METHOD - ANDROID_JPEG_START ] =
    { "gpsProcessingMethod",           TYPE_BYTE   },
    [ ANDROID_JPEG_GPS_TIMESTAMP - ANDROID_JPEG_START ] =
    { "gpsTimestamp",                  TYPE_INT64  },
    [ ANDROID_JPEG_ORIENTATION - ANDROID_JPEG_START ] =
    { "orientation",                   TYPE_INT32  },
    [ ANDROID_JPEG_QUALITY - ANDROID_JPEG_START ] =
    { "quality",                       TYPE_BYTE   },
    [ ANDROID_JPEG_THUMBNAIL_QUALITY - ANDROID_JPEG_START ] =
    { "thumbnailQuality",              TYPE_BYTE   },
    [ ANDROID_JPEG_THUMBNAIL_SIZE - ANDROID_JPEG_START ] =
    { "thumbnailSize",                 TYPE_INT32  },
    [ ANDROID_JPEG_AVAILABLE_THUMBNAIL_SIZES - ANDROID_JPEG_START ] =
    { "availableThumbnailSizes",       TYPE_INT32  },
    [ ANDROID_JPEG_MAX_SIZE - ANDROID_JPEG_START ] =
    { "maxSize",                       TYPE_INT32  },
    [ ANDROID_JPEG_SIZE - ANDROID_JPEG_START ] =
    { "size",                          TYPE_INT32  },
};

static tag_info_t android_lens[ANDROID_LENS_END -
        ANDROID_LENS_START] = {
    [ ANDROID_LENS_APERTURE - ANDROID_LENS_START ] =
    { "aperture",                      TYPE_FLOAT  },
    [ ANDROID_LENS_FILTER_DENSITY - ANDROID_LENS_START ] =
    { "filterDensity",                 TYPE_FLOAT  },
    [ ANDROID_LENS_FOCAL_LENGTH - ANDROID_LENS_START ] =
    { "focalLength",                   TYPE_FLOAT  },
    [ ANDROID_LENS_FOCUS_DISTANCE - ANDROID_LENS_START ] =
    { "focusDistance",                 TYPE_FLOAT  },
    [ ANDROID_LENS_OPTICAL_STABILIZATION_MODE - ANDROID_LENS_START ] =
    { "opticalStabilizationMode",      TYPE_BYTE   },
    [ ANDROID_LENS_FACING - ANDROID_LENS_START ] =
    { "facing",                        TYPE_BYTE   },
    [ ANDROID_LENS_OPTICAL_AXIS_ANGLE - ANDROID_LENS_START ] =
    { "opticalAxisAngle",              TYPE_FLOAT  },
    [ ANDROID_LENS_POSITION - ANDROID_LENS_START ] =
    { "position",                      TYPE_FLOAT  },
    [ ANDROID_LENS_FOCUS_RANGE - ANDROID_LENS_START ] =
    { "focusRange",                    TYPE_FLOAT  },
    [ ANDROID_LENS_STATE - ANDROID_LENS_START ] =
    { "state",                         TYPE_BYTE   },
};

static tag_info_t android_lens_info[ANDROID_LENS_INFO_END -
        ANDROID_LENS_INFO_START] = {
    [ ANDROID_LENS_INFO_AVAILABLE_APERTURES - ANDROID_LENS_INFO_START ] =
    { "availableApertures",            TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_AVAILABLE_FILTER_DENSITIES - ANDROID_LENS_INFO_START ] =
    { "availableFilterDensities",      TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_AVAILABLE_FOCAL_LENGTHS - ANDROID_LENS_INFO_START ] =
    { "availableFocalLengths",         TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION - ANDROID_LENS_INFO_START ] =
    { "availableOpticalStabilization", TYPE_BYTE   },
    [ ANDROID_LENS_INFO_GEOMETRIC_CORRECTION_MAP - ANDROID_LENS_INFO_START ] =
    { "geometricCorrectionMap",        TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_GEOMETRIC_CORRECTION_MAP_SIZE - ANDROID_LENS_INFO_START ] =
    { "geometricCorrectionMapSize",    TYPE_INT32  },
    [ ANDROID_LENS_INFO_HYPERFOCAL_DISTANCE - ANDROID_LENS_INFO_START ] =
    { "hyperfocalDistance",            TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_MINIMUM_FOCUS_DISTANCE - ANDROID_LENS_INFO_START ] =
    { "minimumFocusDistance",          TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_SHADING_MAP - ANDROID_LENS_INFO_START ] =
    { "shadingMap",                    TYPE_FLOAT  },
    [ ANDROID_LENS_INFO_SHADING_MAP_SIZE - ANDROID_LENS_INFO_START ] =
    { "shadingMapSize",                TYPE_INT32  },
};

static tag_info_t android_noise_reduction[ANDROID_NOISE_REDUCTION_END -
        ANDROID_NOISE_REDUCTION_START] = {
    [ ANDROID_NOISE_REDUCTION_MODE - ANDROID_NOISE_REDUCTION_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_NOISE_REDUCTION_STRENGTH - ANDROID_NOISE_REDUCTION_START ] =
    { "strength",                      TYPE_BYTE   },
};

static tag_info_t android_quirks[ANDROID_QUIRKS_END -
        ANDROID_QUIRKS_START] = {
    [ ANDROID_QUIRKS_METERING_CROP_REGION - ANDROID_QUIRKS_START ] =
    { "meteringCropRegion",            TYPE_BYTE   },
    [ ANDROID_QUIRKS_TRIGGER_AF_WITH_AUTO - ANDROID_QUIRKS_START ] =
    { "triggerAfWithAuto",             TYPE_BYTE   },
    [ ANDROID_QUIRKS_USE_ZSL_FORMAT - ANDROID_QUIRKS_START ] =
    { "useZslFormat",                  TYPE_BYTE   },
};

static tag_info_t android_request[ANDROID_REQUEST_END -
        ANDROID_REQUEST_START] = {
    [ ANDROID_REQUEST_FRAME_COUNT - ANDROID_REQUEST_START ] =
    { "frameCount",                    TYPE_INT32  },
    [ ANDROID_REQUEST_ID - ANDROID_REQUEST_START ] =
    { "id",                            TYPE_INT32  },
    [ ANDROID_REQUEST_INPUT_STREAMS - ANDROID_REQUEST_START ] =
    { "inputStreams",                  TYPE_BYTE   },
    [ ANDROID_REQUEST_METADATA_MODE - ANDROID_REQUEST_START ] =
    { "metadataMode",                  TYPE_BYTE   },
    [ ANDROID_REQUEST_OUTPUT_STREAMS - ANDROID_REQUEST_START ] =
    { "outputStreams",                 TYPE_BYTE   },
    [ ANDROID_REQUEST_TYPE - ANDROID_REQUEST_START ] =
    { "type",                          TYPE_BYTE   },
    [ ANDROID_REQUEST_MAX_NUM_OUTPUT_STREAMS - ANDROID_REQUEST_START ] =
    { "maxNumOutputStreams",           TYPE_INT32  },
    [ ANDROID_REQUEST_MAX_NUM_REPROCESS_STREAMS - ANDROID_REQUEST_START ] =
    { "maxNumReprocessStreams",        TYPE_INT32  },
};

static tag_info_t android_scaler[ANDROID_SCALER_END -
        ANDROID_SCALER_START] = {
    [ ANDROID_SCALER_CROP_REGION - ANDROID_SCALER_START ] =
    { "cropRegion",                    TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_FORMATS - ANDROID_SCALER_START ] =
    { "availableFormats",              TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_JPEG_MIN_DURATIONS - ANDROID_SCALER_START ] =
    { "availableJpegMinDurations",     TYPE_INT64  },
    [ ANDROID_SCALER_AVAILABLE_JPEG_SIZES - ANDROID_SCALER_START ] =
    { "availableJpegSizes",            TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_MAX_DIGITAL_ZOOM - ANDROID_SCALER_START ] =
    { "availableMaxDigitalZoom",       TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_PROCESSED_MIN_DURATIONS - ANDROID_SCALER_START ] =
    { "availableProcessedMinDurations",
                                        TYPE_INT64  },
    [ ANDROID_SCALER_AVAILABLE_PROCESSED_SIZES - ANDROID_SCALER_START ] =
    { "availableProcessedSizes",       TYPE_INT32  },
    [ ANDROID_SCALER_AVAILABLE_RAW_MIN_DURATIONS - ANDROID_SCALER_START ] =
    { "availableRawMinDurations",      TYPE_INT64  },
    [ ANDROID_SCALER_AVAILABLE_RAW_SIZES - ANDROID_SCALER_START ] =
    { "availableRawSizes",             TYPE_INT32  },
    [ ANDROID_SCALER_MAX_DIGITAL_ZOOM - ANDROID_SCALER_START ] =
    { "maxDigitalZoom",                TYPE_FLOAT  },
};

static tag_info_t android_sensor[ANDROID_SENSOR_END -
        ANDROID_SENSOR_START] = {
    [ ANDROID_SENSOR_EXPOSURE_TIME - ANDROID_SENSOR_START ] =
    { "exposureTime",                  TYPE_INT64  },
    [ ANDROID_SENSOR_FRAME_DURATION - ANDROID_SENSOR_START ] =
    { "frameDuration",                 TYPE_INT64  },
    [ ANDROID_SENSOR_SENSITIVITY - ANDROID_SENSOR_START ] =
    { "sensitivity",                   TYPE_INT32  },
    [ ANDROID_SENSOR_BASE_GAIN_FACTOR - ANDROID_SENSOR_START ] =
    { "baseGainFactor",                TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_BLACK_LEVEL_PATTERN - ANDROID_SENSOR_START ] =
    { "blackLevelPattern",             TYPE_INT32  },
    [ ANDROID_SENSOR_CALIBRATION_TRANSFORM1 - ANDROID_SENSOR_START ] =
    { "calibrationTransform1",         TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_CALIBRATION_TRANSFORM2 - ANDROID_SENSOR_START ] =
    { "calibrationTransform2",         TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_COLOR_TRANSFORM1 - ANDROID_SENSOR_START ] =
    { "colorTransform1",               TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_COLOR_TRANSFORM2 - ANDROID_SENSOR_START ] =
    { "colorTransform2",               TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_FORWARD_MATRIX1 - ANDROID_SENSOR_START ] =
    { "forwardMatrix1",                TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_FORWARD_MATRIX2 - ANDROID_SENSOR_START ] =
    { "forwardMatrix2",                TYPE_RATIONAL
                },
    [ ANDROID_SENSOR_MAX_ANALOG_SENSITIVITY - ANDROID_SENSOR_START ] =
    { "maxAnalogSensitivity",          TYPE_INT32  },
    [ ANDROID_SENSOR_NOISE_MODEL_COEFFICIENTS - ANDROID_SENSOR_START ] =
    { "noiseModelCoefficients",        TYPE_FLOAT  },
    [ ANDROID_SENSOR_ORIENTATION - ANDROID_SENSOR_START ] =
    { "orientation",                   TYPE_INT32  },
    [ ANDROID_SENSOR_REFERENCE_ILLUMINANT1 - ANDROID_SENSOR_START ] =
    { "referenceIlluminant1",          TYPE_BYTE   },
    [ ANDROID_SENSOR_REFERENCE_ILLUMINANT2 - ANDROID_SENSOR_START ] =
    { "referenceIlluminant2",          TYPE_BYTE   },
    [ ANDROID_SENSOR_TIMESTAMP - ANDROID_SENSOR_START ] =
    { "timestamp",                     TYPE_INT64  },
};

static tag_info_t android_sensor_info[ANDROID_SENSOR_INFO_END -
        ANDROID_SENSOR_INFO_START] = {
    [ ANDROID_SENSOR_INFO_ACTIVE_ARRAY_SIZE - ANDROID_SENSOR_INFO_START ] =
    { "activeArraySize",               TYPE_INT32  },
    [ ANDROID_SENSOR_INFO_AVAILABLE_SENSITIVITIES - ANDROID_SENSOR_INFO_START ] =
    { "availableSensitivities",        TYPE_INT32  },
    [ ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT - ANDROID_SENSOR_INFO_START ] =
    { "colorFilterArrangement",        TYPE_BYTE   },
    [ ANDROID_SENSOR_INFO_EXPOSURE_TIME_RANGE - ANDROID_SENSOR_INFO_START ] =
    { "exposureTimeRange",             TYPE_INT64  },
    [ ANDROID_SENSOR_INFO_MAX_FRAME_DURATION - ANDROID_SENSOR_INFO_START ] =
    { "maxFrameDuration",              TYPE_INT64  },
    [ ANDROID_SENSOR_INFO_PHYSICAL_SIZE - ANDROID_SENSOR_INFO_START ] =
    { "physicalSize",                  TYPE_FLOAT  },
    [ ANDROID_SENSOR_INFO_PIXEL_ARRAY_SIZE - ANDROID_SENSOR_INFO_START ] =
    { "pixelArraySize",                TYPE_INT32  },
    [ ANDROID_SENSOR_INFO_WHITE_LEVEL - ANDROID_SENSOR_INFO_START ] =
    { "whiteLevel",                    TYPE_INT32  },
};

static tag_info_t android_shading[ANDROID_SHADING_END -
        ANDROID_SHADING_START] = {
    [ ANDROID_SHADING_MODE - ANDROID_SHADING_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_SHADING_STRENGTH - ANDROID_SHADING_START ] =
    { "strength",                      TYPE_BYTE   },
};

static tag_info_t android_statistics[ANDROID_STATISTICS_END -
        ANDROID_STATISTICS_START] = {
    [ ANDROID_STATISTICS_FACE_DETECT_MODE - ANDROID_STATISTICS_START ] =
    { "faceDetectMode",                TYPE_BYTE   },
    [ ANDROID_STATISTICS_HISTOGRAM_MODE - ANDROID_STATISTICS_START ] =
    { "histogramMode",                 TYPE_BYTE   },
    [ ANDROID_STATISTICS_SHARPNESS_MAP_MODE - ANDROID_STATISTICS_START ] =
    { "sharpnessMapMode",              TYPE_BYTE   },
    [ ANDROID_STATISTICS_FACE_IDS - ANDROID_STATISTICS_START ] =
    { "faceIds",                       TYPE_INT32  },
    [ ANDROID_STATISTICS_FACE_LANDMARKS - ANDROID_STATISTICS_START ] =
    { "faceLandmarks",                 TYPE_INT32  },
    [ ANDROID_STATISTICS_FACE_RECTANGLES - ANDROID_STATISTICS_START ] =
    { "faceRectangles",                TYPE_INT32  },
    [ ANDROID_STATISTICS_FACE_SCORES - ANDROID_STATISTICS_START ] =
    { "faceScores",                    TYPE_BYTE   },
    [ ANDROID_STATISTICS_HISTOGRAM - ANDROID_STATISTICS_START ] =
    { "histogram",                     TYPE_INT32  },
    [ ANDROID_STATISTICS_SHARPNESS_MAP - ANDROID_STATISTICS_START ] =
    { "sharpnessMap",                  TYPE_INT32  },
};

static tag_info_t android_statistics_info[ANDROID_STATISTICS_INFO_END -
        ANDROID_STATISTICS_INFO_START] = {
    [ ANDROID_STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES - ANDROID_STATISTICS_INFO_START ] =
    { "availableFaceDetectModes",      TYPE_BYTE   },
    [ ANDROID_STATISTICS_INFO_HISTOGRAM_BUCKET_COUNT - ANDROID_STATISTICS_INFO_START ] =
    { "histogramBucketCount",          TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_MAX_FACE_COUNT - ANDROID_STATISTICS_INFO_START ] =
    { "maxFaceCount",                  TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_MAX_HISTOGRAM_COUNT - ANDROID_STATISTICS_INFO_START ] =
    { "maxHistogramCount",             TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_MAX_SHARPNESS_MAP_VALUE - ANDROID_STATISTICS_INFO_START ] =
    { "maxSharpnessMapValue",          TYPE_INT32  },
    [ ANDROID_STATISTICS_INFO_SHARPNESS_MAP_SIZE - ANDROID_STATISTICS_INFO_START ] =
    { "sharpnessMapSize",              TYPE_INT32  },
};

static tag_info_t android_tonemap[ANDROID_TONEMAP_END -
        ANDROID_TONEMAP_START] = {
    [ ANDROID_TONEMAP_CURVE_BLUE - ANDROID_TONEMAP_START ] =
    { "curveBlue",                     TYPE_BYTE   },
    [ ANDROID_TONEMAP_CURVE_GREEN - ANDROID_TONEMAP_START ] =
    { "curveGreen",                    TYPE_BYTE   },
    [ ANDROID_TONEMAP_CURVE_RED - ANDROID_TONEMAP_START ] =
    { "curveRed",                      TYPE_FLOAT  },
    [ ANDROID_TONEMAP_MODE - ANDROID_TONEMAP_START ] =
    { "mode",                          TYPE_BYTE   },
    [ ANDROID_TONEMAP_MAX_CURVE_POINTS - ANDROID_TONEMAP_START ] =
    { "maxCurvePoints",                TYPE_INT32  },
};


tag_info_t *tag_info[ANDROID_SECTION_COUNT] = {
    android_color_correction,
    android_control,
    android_demosaic,
    android_edge,
    android_flash,
    android_flash_info,
    android_geometric,
    android_hot_pixel,
    android_hot_pixel_info,
    android_jpeg,
    android_lens,
    android_lens_info,
    android_noise_reduction,
    android_quirks,
    android_request,
    android_scaler,
    android_sensor,
    android_sensor_info,
    android_shading,
    android_statistics,
    android_statistics_info,
    android_tonemap,
};

int camera_metadata_enum_snprint(uint32_t tag,
                                 uint32_t value,
                                 char *dst,
                                 size_t size) {
    const char *msg = "error: not an enum";
    int ret = -1;

    switch(tag) {
        case ANDROID_COLOR_CORRECTION_MODE: {
            switch (value) {
                case ANDROID_COLOR_CORRECTION_MODE_TRANSFORM_MATRIX:
                    msg = "TRANSFORM_MATRIX";
                    ret = 0;
                    break;
                case ANDROID_COLOR_CORRECTION_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_COLOR_CORRECTION_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_COLOR_CORRECTION_TRANSFORM: {
            break;
        }

        case ANDROID_CONTROL_AE_ANTIBANDING_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_50HZ:
                    msg = "50HZ";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_60HZ:
                    msg = "60HZ";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_ANTIBANDING_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_EXPOSURE_COMPENSATION: {
            break;
        }
        case ANDROID_CONTROL_AE_LOCK: {
            switch (value) {
                case ANDROID_CONTROL_AE_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AE_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON_AUTO_FLASH:
                    msg = "ON_AUTO_FLASH";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON_ALWAYS_FLASH:
                    msg = "ON_ALWAYS_FLASH";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_MODE_ON_AUTO_FLASH_REDEYE:
                    msg = "ON_AUTO_FLASH_REDEYE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_AE_TARGET_FPS_RANGE: {
            break;
        }
        case ANDROID_CONTROL_AF_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AF_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_MACRO:
                    msg = "MACRO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_CONTINUOUS_VIDEO:
                    msg = "CONTINUOUS_VIDEO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_CONTINUOUS_PICTURE:
                    msg = "CONTINUOUS_PICTURE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_MODE_EDOF:
                    msg = "EDOF";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AF_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_AWB_LOCK: {
            switch (value) {
                case ANDROID_CONTROL_AWB_LOCK_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_LOCK_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AWB_MODE: {
            switch (value) {
                case ANDROID_CONTROL_AWB_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_INCANDESCENT:
                    msg = "INCANDESCENT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_FLUORESCENT:
                    msg = "FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_WARM_FLUORESCENT:
                    msg = "WARM_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_DAYLIGHT:
                    msg = "DAYLIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_CLOUDY_DAYLIGHT:
                    msg = "CLOUDY_DAYLIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_TWILIGHT:
                    msg = "TWILIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_MODE_SHADE:
                    msg = "SHADE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AWB_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_CAPTURE_INTENT: {
            switch (value) {
                case ANDROID_CONTROL_CAPTURE_INTENT_CUSTOM:
                    msg = "CUSTOM";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_PREVIEW:
                    msg = "PREVIEW";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_STILL_CAPTURE:
                    msg = "STILL_CAPTURE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_VIDEO_RECORD:
                    msg = "VIDEO_RECORD";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_VIDEO_SNAPSHOT:
                    msg = "VIDEO_SNAPSHOT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_CAPTURE_INTENT_ZERO_SHUTTER_LAG:
                    msg = "ZERO_SHUTTER_LAG";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_EFFECT_MODE: {
            switch (value) {
                case ANDROID_CONTROL_EFFECT_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_MONO:
                    msg = "MONO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_NEGATIVE:
                    msg = "NEGATIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_SOLARIZE:
                    msg = "SOLARIZE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_SEPIA:
                    msg = "SEPIA";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_POSTERIZE:
                    msg = "POSTERIZE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_WHITEBOARD:
                    msg = "WHITEBOARD";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_BLACKBOARD:
                    msg = "BLACKBOARD";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_EFFECT_MODE_AQUA:
                    msg = "AQUA";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_MODE: {
            switch (value) {
                case ANDROID_CONTROL_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_MODE_AUTO:
                    msg = "AUTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_MODE_USE_SCENE_MODE:
                    msg = "USE_SCENE_MODE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_SCENE_MODE: {
            switch (value) {
                case ANDROID_CONTROL_SCENE_MODE_UNSUPPORTED:
                    msg = "UNSUPPORTED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_FACE_PRIORITY:
                    msg = "FACE_PRIORITY";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_ACTION:
                    msg = "ACTION";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_PORTRAIT:
                    msg = "PORTRAIT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_LANDSCAPE:
                    msg = "LANDSCAPE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_NIGHT:
                    msg = "NIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_NIGHT_PORTRAIT:
                    msg = "NIGHT_PORTRAIT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_THEATRE:
                    msg = "THEATRE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_BEACH:
                    msg = "BEACH";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_SNOW:
                    msg = "SNOW";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_SUNSET:
                    msg = "SUNSET";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_STEADYPHOTO:
                    msg = "STEADYPHOTO";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_FIREWORKS:
                    msg = "FIREWORKS";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_SPORTS:
                    msg = "SPORTS";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_PARTY:
                    msg = "PARTY";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_CANDLELIGHT:
                    msg = "CANDLELIGHT";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_SCENE_MODE_BARCODE:
                    msg = "BARCODE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_VIDEO_STABILIZATION_MODE: {
            switch (value) {
                case ANDROID_CONTROL_VIDEO_STABILIZATION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_VIDEO_STABILIZATION_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AE_AVAILABLE_ANTIBANDING_MODES: {
            break;
        }
        case ANDROID_CONTROL_AE_AVAILABLE_MODES: {
            break;
        }
        case ANDROID_CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES: {
            break;
        }
        case ANDROID_CONTROL_AE_COMPENSATION_RANGE: {
            break;
        }
        case ANDROID_CONTROL_AE_COMPENSATION_STEP: {
            break;
        }
        case ANDROID_CONTROL_AF_AVAILABLE_MODES: {
            break;
        }
        case ANDROID_CONTROL_AVAILABLE_EFFECTS: {
            break;
        }
        case ANDROID_CONTROL_AVAILABLE_SCENE_MODES: {
            break;
        }
        case ANDROID_CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES: {
            break;
        }
        case ANDROID_CONTROL_AWB_AVAILABLE_MODES: {
            break;
        }
        case ANDROID_CONTROL_MAX_REGIONS: {
            break;
        }
        case ANDROID_CONTROL_SCENE_MODE_OVERRIDES: {
            break;
        }
        case ANDROID_CONTROL_AE_PRECAPTURE_ID: {
            break;
        }
        case ANDROID_CONTROL_AE_STATE: {
            switch (value) {
                case ANDROID_CONTROL_AE_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_SEARCHING:
                    msg = "SEARCHING";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_CONVERGED:
                    msg = "CONVERGED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_LOCKED:
                    msg = "LOCKED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_FLASH_REQUIRED:
                    msg = "FLASH_REQUIRED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AE_STATE_PRECAPTURE:
                    msg = "PRECAPTURE";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AF_STATE: {
            switch (value) {
                case ANDROID_CONTROL_AF_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_PASSIVE_SCAN:
                    msg = "PASSIVE_SCAN";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_PASSIVE_FOCUSED:
                    msg = "PASSIVE_FOCUSED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_ACTIVE_SCAN:
                    msg = "ACTIVE_SCAN";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_FOCUSED_LOCKED:
                    msg = "FOCUSED_LOCKED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AF_STATE_NOT_FOCUSED_LOCKED:
                    msg = "NOT_FOCUSED_LOCKED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_CONTROL_AF_TRIGGER_ID: {
            break;
        }
        case ANDROID_CONTROL_AWB_STATE: {
            switch (value) {
                case ANDROID_CONTROL_AWB_STATE_INACTIVE:
                    msg = "INACTIVE";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_STATE_SEARCHING:
                    msg = "SEARCHING";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_STATE_CONVERGED:
                    msg = "CONVERGED";
                    ret = 0;
                    break;
                case ANDROID_CONTROL_AWB_STATE_LOCKED:
                    msg = "LOCKED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_DEMOSAIC_MODE: {
            switch (value) {
                case ANDROID_DEMOSAIC_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_DEMOSAIC_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_EDGE_MODE: {
            switch (value) {
                case ANDROID_EDGE_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_EDGE_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_EDGE_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_EDGE_STRENGTH: {
            break;
        }

        case ANDROID_FLASH_FIRING_POWER: {
            break;
        }
        case ANDROID_FLASH_FIRING_TIME: {
            break;
        }
        case ANDROID_FLASH_MODE: {
            switch (value) {
                case ANDROID_FLASH_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_FLASH_MODE_SINGLE:
                    msg = "SINGLE";
                    ret = 0;
                    break;
                case ANDROID_FLASH_MODE_TORCH:
                    msg = "TORCH";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_FLASH_COLOR_TEMPERATURE: {
            break;
        }
        case ANDROID_FLASH_MAX_ENERGY: {
            break;
        }
        case ANDROID_FLASH_STATE: {
            switch (value) {
                case ANDROID_FLASH_STATE_UNAVAILABLE:
                    msg = "UNAVAILABLE";
                    ret = 0;
                    break;
                case ANDROID_FLASH_STATE_CHARGING:
                    msg = "CHARGING";
                    ret = 0;
                    break;
                case ANDROID_FLASH_STATE_READY:
                    msg = "READY";
                    ret = 0;
                    break;
                case ANDROID_FLASH_STATE_FIRED:
                    msg = "FIRED";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_FLASH_INFO_AVAILABLE: {
            break;
        }
        case ANDROID_FLASH_INFO_CHARGE_DURATION: {
            break;
        }

        case ANDROID_GEOMETRIC_MODE: {
            switch (value) {
                case ANDROID_GEOMETRIC_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_GEOMETRIC_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_GEOMETRIC_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_GEOMETRIC_STRENGTH: {
            break;
        }

        case ANDROID_HOT_PIXEL_MODE: {
            switch (value) {
                case ANDROID_HOT_PIXEL_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_HOT_PIXEL_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_HOT_PIXEL_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_HOT_PIXEL_INFO_MAP: {
            break;
        }

        case ANDROID_JPEG_GPS_COORDINATES: {
            break;
        }
        case ANDROID_JPEG_GPS_PROCESSING_METHOD: {
            break;
        }
        case ANDROID_JPEG_GPS_TIMESTAMP: {
            break;
        }
        case ANDROID_JPEG_ORIENTATION: {
            break;
        }
        case ANDROID_JPEG_QUALITY: {
            break;
        }
        case ANDROID_JPEG_THUMBNAIL_QUALITY: {
            break;
        }
        case ANDROID_JPEG_THUMBNAIL_SIZE: {
            break;
        }
        case ANDROID_JPEG_AVAILABLE_THUMBNAIL_SIZES: {
            break;
        }
        case ANDROID_JPEG_MAX_SIZE: {
            break;
        }
        case ANDROID_JPEG_SIZE: {
            break;
        }

        case ANDROID_LENS_APERTURE: {
            break;
        }
        case ANDROID_LENS_FILTER_DENSITY: {
            break;
        }
        case ANDROID_LENS_FOCAL_LENGTH: {
            break;
        }
        case ANDROID_LENS_FOCUS_DISTANCE: {
            break;
        }
        case ANDROID_LENS_OPTICAL_STABILIZATION_MODE: {
            switch (value) {
                case ANDROID_LENS_OPTICAL_STABILIZATION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_LENS_OPTICAL_STABILIZATION_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_LENS_FACING: {
            switch (value) {
                case ANDROID_LENS_FACING_FRONT:
                    msg = "FRONT";
                    ret = 0;
                    break;
                case ANDROID_LENS_FACING_BACK:
                    msg = "BACK";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_LENS_OPTICAL_AXIS_ANGLE: {
            break;
        }
        case ANDROID_LENS_POSITION: {
            break;
        }
        case ANDROID_LENS_FOCUS_RANGE: {
            break;
        }
        case ANDROID_LENS_STATE: {
            switch (value) {
                case ANDROID_LENS_STATE_STATIONARY:
                    msg = "STATIONARY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }

        case ANDROID_LENS_INFO_AVAILABLE_APERTURES: {
            break;
        }
        case ANDROID_LENS_INFO_AVAILABLE_FILTER_DENSITIES: {
            break;
        }
        case ANDROID_LENS_INFO_AVAILABLE_FOCAL_LENGTHS: {
            break;
        }
        case ANDROID_LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION: {
            break;
        }
        case ANDROID_LENS_INFO_GEOMETRIC_CORRECTION_MAP: {
            break;
        }
        case ANDROID_LENS_INFO_GEOMETRIC_CORRECTION_MAP_SIZE: {
            break;
        }
        case ANDROID_LENS_INFO_HYPERFOCAL_DISTANCE: {
            break;
        }
        case ANDROID_LENS_INFO_MINIMUM_FOCUS_DISTANCE: {
            break;
        }
        case ANDROID_LENS_INFO_SHADING_MAP: {
            break;
        }
        case ANDROID_LENS_INFO_SHADING_MAP_SIZE: {
            break;
        }

        case ANDROID_NOISE_REDUCTION_MODE: {
            switch (value) {
                case ANDROID_NOISE_REDUCTION_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_NOISE_REDUCTION_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_NOISE_REDUCTION_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_NOISE_REDUCTION_STRENGTH: {
            break;
        }

        case ANDROID_QUIRKS_METERING_CROP_REGION: {
            break;
        }
        case ANDROID_QUIRKS_TRIGGER_AF_WITH_AUTO: {
            break;
        }
        case ANDROID_QUIRKS_USE_ZSL_FORMAT: {
            break;
        }

        case ANDROID_REQUEST_FRAME_COUNT: {
            break;
        }
        case ANDROID_REQUEST_ID: {
            break;
        }
        case ANDROID_REQUEST_INPUT_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_METADATA_MODE: {
            switch (value) {
                case ANDROID_REQUEST_METADATA_MODE_NONE:
                    msg = "NONE";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_METADATA_MODE_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_REQUEST_OUTPUT_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_TYPE: {
            switch (value) {
                case ANDROID_REQUEST_TYPE_CAPTURE:
                    msg = "CAPTURE";
                    ret = 0;
                    break;
                case ANDROID_REQUEST_TYPE_REPROCESS:
                    msg = "REPROCESS";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_REQUEST_MAX_NUM_OUTPUT_STREAMS: {
            break;
        }
        case ANDROID_REQUEST_MAX_NUM_REPROCESS_STREAMS: {
            break;
        }

        case ANDROID_SCALER_CROP_REGION: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_FORMATS: {
            switch (value) {
                case ANDROID_SCALER_AVAILABLE_FORMATS_RAW_SENSOR:
                    msg = "RAW_SENSOR";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_YV12:
                    msg = "YV12";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_YCbCr_420_SP:
                    msg = "YCbCr_420_SP";
                    ret = 0;
                    break;
                case ANDROID_SCALER_AVAILABLE_FORMATS_JPEG:
                    msg = "JPEG";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SCALER_AVAILABLE_JPEG_MIN_DURATIONS: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_JPEG_SIZES: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_MAX_DIGITAL_ZOOM: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_PROCESSED_MIN_DURATIONS: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_PROCESSED_SIZES: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_RAW_MIN_DURATIONS: {
            break;
        }
        case ANDROID_SCALER_AVAILABLE_RAW_SIZES: {
            break;
        }
        case ANDROID_SCALER_MAX_DIGITAL_ZOOM: {
            break;
        }

        case ANDROID_SENSOR_EXPOSURE_TIME: {
            break;
        }
        case ANDROID_SENSOR_FRAME_DURATION: {
            break;
        }
        case ANDROID_SENSOR_SENSITIVITY: {
            break;
        }
        case ANDROID_SENSOR_BASE_GAIN_FACTOR: {
            break;
        }
        case ANDROID_SENSOR_BLACK_LEVEL_PATTERN: {
            break;
        }
        case ANDROID_SENSOR_CALIBRATION_TRANSFORM1: {
            break;
        }
        case ANDROID_SENSOR_CALIBRATION_TRANSFORM2: {
            break;
        }
        case ANDROID_SENSOR_COLOR_TRANSFORM1: {
            break;
        }
        case ANDROID_SENSOR_COLOR_TRANSFORM2: {
            break;
        }
        case ANDROID_SENSOR_FORWARD_MATRIX1: {
            break;
        }
        case ANDROID_SENSOR_FORWARD_MATRIX2: {
            break;
        }
        case ANDROID_SENSOR_MAX_ANALOG_SENSITIVITY: {
            break;
        }
        case ANDROID_SENSOR_NOISE_MODEL_COEFFICIENTS: {
            break;
        }
        case ANDROID_SENSOR_ORIENTATION: {
            break;
        }
        case ANDROID_SENSOR_REFERENCE_ILLUMINANT1: {
            switch (value) {
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT:
                    msg = "DAYLIGHT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_FLUORESCENT:
                    msg = "FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_TUNGSTEN:
                    msg = "TUNGSTEN";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_FLASH:
                    msg = "FLASH";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_FINE_WEATHER:
                    msg = "FINE_WEATHER";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_CLOUDY_WEATHER:
                    msg = "CLOUDY_WEATHER";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_SHADE:
                    msg = "SHADE";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT_FLUORESCENT:
                    msg = "DAYLIGHT_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_DAY_WHITE_FLUORESCENT:
                    msg = "DAY_WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_COOL_WHITE_FLUORESCENT:
                    msg = "COOL_WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_WHITE_FLUORESCENT:
                    msg = "WHITE_FLUORESCENT";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_A:
                    msg = "STANDARD_A";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_B:
                    msg = "STANDARD_B";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_C:
                    msg = "STANDARD_C";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_D55:
                    msg = "D55";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_D65:
                    msg = "D65";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_D75:
                    msg = "D75";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_D50:
                    msg = "D50";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_REFERENCE_ILLUMINANT1_ISO_STUDIO_TUNGSTEN:
                    msg = "ISO_STUDIO_TUNGSTEN";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SENSOR_REFERENCE_ILLUMINANT2: {
            break;
        }
        case ANDROID_SENSOR_TIMESTAMP: {
            break;
        }

        case ANDROID_SENSOR_INFO_ACTIVE_ARRAY_SIZE: {
            break;
        }
        case ANDROID_SENSOR_INFO_AVAILABLE_SENSITIVITIES: {
            break;
        }
        case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT: {
            switch (value) {
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGGB:
                    msg = "RGGB";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GRBG:
                    msg = "GRBG";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GBRG:
                    msg = "GBRG";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_BGGR:
                    msg = "BGGR";
                    ret = 0;
                    break;
                case ANDROID_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGB:
                    msg = "RGB";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SENSOR_INFO_EXPOSURE_TIME_RANGE: {
            break;
        }
        case ANDROID_SENSOR_INFO_MAX_FRAME_DURATION: {
            break;
        }
        case ANDROID_SENSOR_INFO_PHYSICAL_SIZE: {
            break;
        }
        case ANDROID_SENSOR_INFO_PIXEL_ARRAY_SIZE: {
            break;
        }
        case ANDROID_SENSOR_INFO_WHITE_LEVEL: {
            break;
        }

        case ANDROID_SHADING_MODE: {
            switch (value) {
                case ANDROID_SHADING_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_SHADING_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_SHADING_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_SHADING_STRENGTH: {
            break;
        }

        case ANDROID_STATISTICS_FACE_DETECT_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_FACE_DETECT_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_FACE_DETECT_MODE_SIMPLE:
                    msg = "SIMPLE";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_FACE_DETECT_MODE_FULL:
                    msg = "FULL";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_HISTOGRAM_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_HISTOGRAM_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_HISTOGRAM_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_SHARPNESS_MAP_MODE: {
            switch (value) {
                case ANDROID_STATISTICS_SHARPNESS_MAP_MODE_OFF:
                    msg = "OFF";
                    ret = 0;
                    break;
                case ANDROID_STATISTICS_SHARPNESS_MAP_MODE_ON:
                    msg = "ON";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_STATISTICS_FACE_IDS: {
            break;
        }
        case ANDROID_STATISTICS_FACE_LANDMARKS: {
            break;
        }
        case ANDROID_STATISTICS_FACE_RECTANGLES: {
            break;
        }
        case ANDROID_STATISTICS_FACE_SCORES: {
            break;
        }
        case ANDROID_STATISTICS_HISTOGRAM: {
            break;
        }
        case ANDROID_STATISTICS_SHARPNESS_MAP: {
            break;
        }

        case ANDROID_STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES: {
            break;
        }
        case ANDROID_STATISTICS_INFO_HISTOGRAM_BUCKET_COUNT: {
            break;
        }
        case ANDROID_STATISTICS_INFO_MAX_FACE_COUNT: {
            break;
        }
        case ANDROID_STATISTICS_INFO_MAX_HISTOGRAM_COUNT: {
            break;
        }
        case ANDROID_STATISTICS_INFO_MAX_SHARPNESS_MAP_VALUE: {
            break;
        }
        case ANDROID_STATISTICS_INFO_SHARPNESS_MAP_SIZE: {
            break;
        }

        case ANDROID_TONEMAP_CURVE_BLUE: {
            break;
        }
        case ANDROID_TONEMAP_CURVE_GREEN: {
            break;
        }
        case ANDROID_TONEMAP_CURVE_RED: {
            break;
        }
        case ANDROID_TONEMAP_MODE: {
            switch (value) {
                case ANDROID_TONEMAP_MODE_CONTRAST_CURVE:
                    msg = "CONTRAST_CURVE";
                    ret = 0;
                    break;
                case ANDROID_TONEMAP_MODE_FAST:
                    msg = "FAST";
                    ret = 0;
                    break;
                case ANDROID_TONEMAP_MODE_HIGH_QUALITY:
                    msg = "HIGH_QUALITY";
                    ret = 0;
                    break;
                default:
                    msg = "error: enum value out of range";
            }
            break;
        }
        case ANDROID_TONEMAP_MAX_CURVE_POINTS: {
            break;
        }

    }

    strncpy(dst, msg, size - 1);
    dst[size - 1] = '\0';

    return ret;
}


