/**
	@file	counter.c
	@brief	JE^\[X
	@author	yasu
	@date	2014/05/18
 */

/*==============================================================
 *	Include
 *==============================================================
 */
#include "counter.h"


/*==============================================================
 *	Function
 *==============================================================
 */

/**
	@brief		Init
	@author		yasu
	@date		2014/05/18
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		p֐@RXgN^
 */
void	COUNTER_Init(Counter *This)
{
	This->mCount = 0;
	This->mState = COUNTER_STATE_DISABLE;
}



/**
	@brief		Increment
	@author		yasu
	@date		2014/05/18
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		̏Ԃ ENABLE ̎CNg
 */
void	COUNTER_Increment(Counter *This)
{
	if (COUNTER_STATE_ENABLE == This->mState) {
		This->mCount++;
	}
}



/**
	@brief		Decrement
	@author		yasu
	@date		2014/05/18
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		̏Ԃ ENABLE ̎fNg
 */
void	COUNTER_Decrement(Counter *This)
{
	if (COUNTER_STATE_ENABLE == This->mState) {
		This->mCount--;
	}
}



/**
	@brief		Reset JE^Zbg
	@author		yasu
	@date		2014/05/18
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		̏Ԃ͕ύXȂ
 */
void	COUNTER_ResetCount(Counter *This)
{
	This->mCount = 0;
}



/**
	@brief		Enable JE^Lɂ
	@author		yasu
	@date		2014/05/18
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		
 */
void	COUNTER_Enable(Counter *This)
{
	This->mState = COUNTER_STATE_ENABLE;
}



/**
	@brief		Disable JE^𖳌ɂ
	@author		yasu
	@date		2014/05/18
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		
 */
void	COUNTER_Disable(Counter *This)
{
	This->mState = COUNTER_STATE_DISABLE;
}



/**
	@brief		Get JE^l擾
	@author		yasu
	@date		2014/05/18
	@param		*This	CX^Xւ̃|C^
	@return		JEgl
	@remarks		
 */
int	COUNTER_GetCount(Counter *This)
{
	return This->mCount;
}
