/**
	@file	counter.h
	@brief	JE^wb_
	@author	yasu
	@date	2014/05/18
 */

#ifndef COUNTER_H_
#define COUNTER_H_

/*******************************************************************************
	include
*******************************************************************************/


/*******************************************************************************
	define/enum
*******************************************************************************/
enum {
	COUNTER_STATE_DISABLE = 0,
	COUNTER_STATE_ENABLE,
};

/* o̒` */
typedef struct {
	int	mCount;
	int	mState;
} Counter;

/*******************************************************************************
	function
*******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif

extern void	COUNTER_Init(Counter *This);
extern void	COUNTER_Increment(Counter *This);
extern void	COUNTER_Decrement(Counter *This);
extern void	COUNTER_ResetCount(Counter *This);
extern void	COUNTER_Enable(Counter *This);
extern void	COUNTER_Disable(Counter *This);
extern int	COUNTER_GetCount(Counter *This);

#if defined(__cplusplus)
}
#endif

#endif /* COUNTER_H_ */
