/**
	@file	counter_manager.c
	@brief	JE^}l[W\[X
	@author	yasu
	@date	2014/05/19
 */

/*==============================================================
 *	Include
 *==============================================================
 */
#include "define.h"
#include "counter_manager.h"

/*==============================================================
 *	Static function prototype
 *==============================================================
 */
static void	sIncrementCounter(CounterMgr *This, int theCounterID);
static void	sDecrementCounter(CounterMgr *This, int theCounterID);
static void	sStopCounter(CounterMgr *This, int theCounterID);
static void	sResetCounter(CounterMgr *This, int theCounterID);
static void	sPutBonusHistory(CounterMgr *This, int theBonusID);

/*==============================================================
 *	Function
 *==============================================================
 */

/**
	@brief	Init
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	p֐@RXgN^
 */
void	COUNTER_MANAGER_Init(CounterMgr *This)
{
	int i;
	for (i = 0; i < NUMOF_COUNTER_ID; i++) {
		This->mCounter[i] = NULL;
	}

	This->mSlumpHistory = NULL;
	This->mSlumpTimer = 0;

	This->mBonusHistory = NULL;
}



/**
	@brief	SetCounter JE^̎̂o^
	@author	yasu
	@date	2014/05/19
	@param	*This		CX^Xւ̃|C^
	@param	theCounterType	o^JE^̃^Cv(COUNTER_ID)
	@param	*theCounter	o^JE^̃CX^Xւ̃|C^
	@return	none
	@remarks		
 */
void	COUNTER_MANAGER_SetCounter(CounterMgr *This, int theCounterType, Counter *theCounter)
{
	This->mCounter[theCounterType] = theCounter;
}



/**
	@brief	SetSlumpHistoryBuf Xvobt@̎̂o^
	@author	yasu
	@date	2014/05/19
	@param	*This			CX^Xւ̃|C^
	@param	*theSlumpHistoryBuf	o^CX^Xւ̃|C^
	@return	none
	@remarks		
 */
void	COUNTER_MANAGER_SetSlumpHistoryBuf(CounterMgr *This, HistoryBuffer *theSlumpHistoryBuf)
{
	This->mSlumpHistory = theSlumpHistoryBuf;
}



/**
	@brief	SetBonusHistoryBuf {[iXobt@̎̂o^
	@author	yasu
	@date	2014/05/19
	@param	*This			CX^Xւ̃|C^
	@param	*theBonusHistoryBuf	o^CX^Xւ̃|C^
	@return	none
	@remarks		
 */
void	COUNTER_MANAGER_SetBonusHistoryBuf(CounterMgr *This, HistoryBuffer *theBonusHisotryBuf)
{
	This->mBonusHistory = theBonusHisotryBuf;
}



/**
	@brief	EnableAllCounter	o^ĂJE^S ENABLE ɂ
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	JEgJnOɌĂԂ
 */
void	COUNTER_MANAGER_EnableAllCounter(CounterMgr *This)
{
	int i;

	for (i = 0; i < NUMOF_COUNTER_ID; i++) {
		Counter *aCounter = This->mCounter[i];

		if (NULL != aCounter) {
			COUNTER_Enable(aCounter);
		}
	}
}



/**
	@brief	ResetAll	o^ĂJE^Ɨobt@SăZbg
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	JE^̓Ԃ͋I ENABLE ƂȂ̂Œ
 */
void	COUNTER_MANAGER_ResetAll(CounterMgr *This)
{
	int i;
	for (i = 0; i < NUMOF_COUNTER_ID; i++) {
		sResetCounter(This, i);
	}

	if (NULL != This->mSlumpHistory) {
		HISTORY_BUFFER_Reset(This->mSlumpHistory);
	}

	This->mSlumpTimer = 0;
}



/**
	@brief	StartBig	BIGJn
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	BIGJnCxgĂ
 */
void	COUNTER_MANAGER_StartBig(CounterMgr *This)
{
	/* BIGJE^CNg */
	sIncrementCounter(This, COUNTER_ID_BIG);

	/* Q[JE^~߂ */
	sStopCounter(This, COUNTER_ID_GAME);
}



/**
	@brief	EndBig	BIGI
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	BIGICxgĂ
 */
void	COUNTER_MANAGER_EndBig(CounterMgr *This)
{
	/* Q[HISOTRYobt@Ɏc */
	sPutBonusHistory(This, BONUS_ID_BIG);

	/* Q[JE^ZbgāALɂ */
	sResetCounter(This, COUNTER_ID_GAME);
}



/**
	@brief	StartReg	REGJn
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	REGJnCxgĂ
 */
void	COUNTER_MANAGER_StartReg(CounterMgr *This)
{
	/* REGJE^CNg */
	sIncrementCounter(This, COUNTER_ID_REG);

	/* Q[JE^~߂ */
	sStopCounter(This, COUNTER_ID_GAME);
}



/**
	@brief	EndReg	REGI
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	REGICxgĂ
 */
void	COUNTER_MANAGER_EndReg(CounterMgr *This)
{
	/* Q[HISTORYobt@Ɏc */
	sPutBonusHistory(This, BONUS_ID_REG);

	/* Q[JE^ZbgALɂ */
	sResetCounter(This, COUNTER_ID_GAME);
}



/**
	@brief	StartART	ARTJn
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	ARTJnCxgĂ
 */
void	COUNTER_MANAGER_StartART(CounterMgr *This)
{
	/* ARTJE^CNg */
	sIncrementCounter(This, COUNTER_ID_ART);
}



/**
	@brief	EndART	ARTI
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	ARTICxgĂ
 */
void	COUNTER_MANAGER_EndART(CounterMgr *This)
{
	/* no operation */
}



/**
	@brief	CountGame		Q[JEg
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	Q[JEgCxgĂ
 */
void	COUNTER_MANAGER_CountGame(CounterMgr *This)
{
	/* g[^Q[JE^JEgAbv */
	sIncrementCounter(This, COUNTER_ID_TOTAL_GAME);

	/* Q[JE^JEgAbv */
	sIncrementCounter(This, COUNTER_ID_GAME);

	/* COUNTER_SLUMP_CYCLEGameɈxAXvɍo^ */
	This->mSlumpTimer++;
	if (COUNTER_SLUMP_CYCLE <= This->mSlumpTimer) {
		Counter *aMedalCounter = This->mCounter[COUNTER_ID_MEDAL];

		if ((NULL != aMedalCounter) && (NULL != This->mSlumpHistory) ) {
			HistoryData aHistoryData;
			HISTORY_DATA_Init(&aHistoryData);

			aHistoryData.SlumpData.mMedals    = COUNTER_GetCount(aMedalCounter);
			HISTORY_BUFFER_Put(This->mSlumpHistory, &aHistoryData);
		}
		This->mSlumpTimer = 0;
	}
}



/**
	@brief	OutMedak	_o
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	_oCxgĂ
 */
void	COUNTER_MANAGER_OutMedal(CounterMgr *This)
{
	sIncrementCounter(This, COUNTER_ID_MEDAL);
}



/**
	@brief	BetMedal	_xbg
	@author	yasu
	@date	2014/05/19
	@param	*This	CX^Xւ̃|C^
	@return	none
	@remarks	_xbgCxgĂ
 */
void	COUNTER_MANAGER_BetMedal(CounterMgr *This)
{
	sDecrementCounter(This, COUNTER_ID_MEDAL);
}




/*==============================================================
 *	Static Function
 *==============================================================
 */

/**
	@brief	JE^JEgAbv
	@author	yasu
	@date	2014/05/19
	@param	*This		CX^Xւ̃|C^
	@param	theCounterID	JEgAbvJE^ID
	@return	none
	@remarks	
 */
void	sIncrementCounter(CounterMgr *This, int theCounterID)
{
	Counter *aCounter = This->mCounter[theCounterID];

	if (NULL != aCounter) {
		COUNTER_Increment(aCounter);
	}
}



/**
	@brief	JE^JEg_E
	@author	yasu
	@date	2014/05/19
	@param	*This		CX^Xւ̃|C^
	@param	theCounterID	JEg_EJE^ID
	@return	none
	@remarks	
 */
void	sDecrementCounter(CounterMgr *This, int theCounterID)
{
	Counter *aCounter = This->mCounter[theCounterID];

	if (NULL != aCounter) {
		COUNTER_Decrement(aCounter);
	}
}



/**
	@brief	JE^~߂
	@author	yasu
	@date	2014/05/19
	@param	*This		CX^Xւ̃|C^
	@param	theCounterID	JEg~߂JE^ID
	@return	none
	@remarks	
 */
void	sStopCounter(CounterMgr *This, int theCounterID)
{
	Counter *aCounter = This->mCounter[theCounterID];

	if (NULL != aCounter) {
		COUNTER_Disable(aCounter);
	}
}



/**
	@brief	JE^ZbgALɂ
	@author	yasu
	@date	2014/05/19
	@param	*This		CX^Xւ̃|C^
	@param	theCounterID	ZbgJE^ID
	@return	none
	@remarks	
 */
void	sResetCounter(CounterMgr *This, int theCounterID)
{
	Counter *aCounter = This->mCounter[theCounterID];

	if (NULL != aCounter) {
		/* JE^Zbg */
		COUNTER_ResetCount(aCounter);

		/* JE^Lɂ */
		COUNTER_Enable(aCounter);
	}
}



/**
	@brief	{[iXc
	@author	yasu
	@date	2014/05/19
	@param	*This		CX^Xւ̃|C^
	@param	theBonusID	ɕێĂ{[iX
	@return	none
	@remarks	
 */
void	sPutBonusHistory(CounterMgr *This, int theBonusID)
{
	HistoryBuffer *aBonusHistoryBuf = This->mBonusHistory;
	Counter *aGameCounter = This->mCounter[COUNTER_ID_GAME];

	if ((NULL != aBonusHistoryBuf) && (NULL != aGameCounter)) {
		HistoryData aHistoryData;
		HISTORY_DATA_Init(&aHistoryData);

		aHistoryData.BonusHistory.mGameCount = COUNTER_GetCount(aGameCounter);
		aHistoryData.BonusHistory.mBonusID   = theBonusID;

		HISTORY_BUFFER_Put(aBonusHistoryBuf, &aHistoryData);
	}
}

