/**
	@file	counter_manager.h
	@brief	JE^}l[Wwb_
	@author	yasu
	@date	2014/05/19
 */

#ifndef COUNTER_MANAGER_H_
#define COUNTER_MANAGER_H_

/*******************************************************************************
	include
*******************************************************************************/
#include "counter.h"
#include "history_buffer.h"

/*******************************************************************************
	define/enum
*******************************************************************************/
enum {
	COUNTER_ID_GAME = 0,	// Q[
	COUNTER_ID_BIG,		// BIG
	COUNTER_ID_REG,		// REG
	COUNTER_ID_ART,		// ART
	COUNTER_ID_MEDAL,		// 
	COUNTER_ID_TOTAL_GAME,	// g[^Q[
	
	NUMOF_COUNTER_ID,
};

enum {
	COUNTER_SLUMP_CYCLE = 50,
};

/* o̒` */
typedef struct {
	Counter	*mCounter[NUMOF_COUNTER_ID];

	unsigned long	mSlumpTimer;	// XvOtpf[^i[^C~OvJE^
	HistoryBuffer	*mSlumpHistory;
	HistoryBuffer	*mBonusHistory;
} CounterMgr;


/*******************************************************************************
	function
*******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif

extern void	COUNTER_MANAGER_Init(CounterMgr *This);
extern void	COUNTER_MANAGER_SetCounter(CounterMgr *This, int theCounterID, Counter *theCounter);
extern void	COUNTER_MANAGER_SetSlumpHistoryBuf(CounterMgr *This, HistoryBuffer *theSlumpHistoryBuf);
extern void	COUNTER_MANAGER_SetBonusHistoryBuf(CounterMgr *This, HistoryBuffer *theBonusHistoryBuf);
extern void	COUNTER_MANAGER_EnableAllCounter(CounterMgr*This);

extern void	COUNTER_MANAGER_ResetAll(CounterMgr *This);

extern void	COUNTER_MANAGER_StartBig(CounterMgr *This);
extern void	COUNTER_MANAGER_EndBig(CounterMgr *This);

extern void	COUNTER_MANAGER_StartReg(CounterMgr *This);
extern void	COUNTER_MANAGER_EndReg(CounterMgr *This);

extern void	COUNTER_MANAGER_StartART(CounterMgr *This);
extern void	COUNTER_MANAGER_EndART(CounterMgr *This);

extern void	COUNTER_MANAGER_CountGame(CounterMgr *This);

extern void	COUNTER_MANAGER_OutMedal(CounterMgr *This);
extern void	COUNTER_MANAGER_BetMedal(CounterMgr *This);


#if defined(__cplusplus)
}
#endif


#endif /* COUNTER_MANAGER_H_ */
