/**
	@file	history_buffer.h
	@brief	f[^uwb_
	@author	yasu
	@date	2014/05/19
 */

/*==============================================================
 *	Include
 *==============================================================
 */
#include <stdlib.h>
#include "history_buffer.h"
#include "define.h"


/*==============================================================
 *	Function
 *==============================================================
 */

/**
	@brief		Init
	@author		yasu
	@date		2014/05/19
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		p֐@RXgN^
			ŏ̈ȊOĂ΂Ȃ
 */
void	HISTORY_BUFFER_Init(HistoryBuffer *This)
{
	This->mHistoryData    = NULL;
	This->mWritePointer   = 0;
	This->mHistoryBufSize = 0;
	This->mHistoryBufMask = 0;
}



/**
	@brief		Malloc m
	@author		yasu
	@date		2014/05/19
	@param		*This	CX^Xւ̃|C^
	@param		theSize	mۂ郁TCY (2^n) n ̒l
	@return		TRUE: mې / FALSE: mێs
	@remarks		mۂ郁TCY2ׂ̂ɂȂ邽ߒ
			sgpɂꍇ͕K Free ֐ĂŃ̊Js
 */
int	HISTORY_BUFFER_Malloc(HistoryBuffer *This, int theSize)
{
	int aRet = FALSE;
	unsigned long aSize;

	if (NULL != This->mHistoryData) {
		HISTORY_BUFFER_Free(This);
	}

	aSize = (1 << theSize);
	This->mHistoryData = (HistoryData *)malloc(sizeof(HistoryData) * aSize);

	if (NULL != This->mHistoryData) {
		This->mHistoryBufSize = aSize;
		This->mHistoryBufMask = (aSize - 1);
		HISTORY_BUFFER_Reset(This);
		aRet = TRUE;
	}

	return aRet;
}



/**
	@brief		Free ̉
	@author		yasu
	@date		2014/05/19
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		
 */
void	HISTORY_BUFFER_Free(HistoryBuffer *This)
{
	free(This->mHistoryData);

	This->mHistoryData    = NULL;
	This->mHistoryBufSize = 0;
	This->mHistoryBufMask = 0;
}



/**
	@brief		Put f[^̊i[
	@author		yasu
	@date		2014/05/19
	@param		*This	CX^Xւ̃|C^
	@param		*theData	i[f[^ւ̃|C^
	@return		none
	@remarks		MallocɂămۂɌĂԂ
 */
/* f[^i[ */
void	HISTORY_BUFFER_Put(HistoryBuffer *This, HistoryData *theData)
{
	if (NULL != This->mHistoryData) {
		HISTORY_DATA_Copy(&This->mHistoryData[This->mWritePointer], theData);

		This->mWritePointer++;
		This->mWritePointer &= This->mHistoryBufMask;
	}
}



/**
	@brief		Reset ێĂf[^Sď
	@author		yasu
	@date		2014/05/19
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		͍̉sȂߒ
 */
/* Sf[^폜 */
void	HISTORY_BUFFER_Reset(HistoryBuffer *This)
{
	if (NULL != This->mHistoryData) {
		int i;

		for (i = 0; i < This->mHistoryBufSize; i++) {
			HISTORY_DATA_Init(&This->mHistoryData[i]);
		}

		This->mWritePointer = 0;
	}
}



/**
	@brief		GetData ێĂf[^̎擾
	@author		yasu
	@date		2014/05/19
	@param		*This		CX^Xւ̃|C^
	@param		thePreviousSum	Õf[^擾邩B(1ȏ̒l)
	@param		*theBuf		擾f[^̊i[
	@return		none
	@remarks		
 */
/* f[^擾 */
void	HISTORY_BUFFER_GetData(HistoryBuffer *This, int thePreviousNum, HistoryData *theBuf)
{
	if (NULL != This->mHistoryData) {
		unsigned long aPointer;
		aPointer = This->mWritePointer - thePreviousNum;
		aPointer &= This->mHistoryBufMask;

		HISTORY_DATA_Copy(theBuf, &This->mHistoryData[aPointer]);
	}
}
