/**
	@file	history_buffer.h
	@brief	f[^uwb_
	@author	yasu
	@date	2014/05/19
 */

#ifndef HISTORY_BUFFER_H_
#define HISTORY_BUFFER_H_

/*******************************************************************************
	include
*******************************************************************************/
#include "history_data.h"

/*******************************************************************************
	define/enum
*******************************************************************************/
typedef struct {
	HistoryData	*mHistoryData;
	int		mWritePointer;
	unsigned long	mHistoryBufSize;
	unsigned long	mHistoryBufMask;
} HistoryBuffer;

/*******************************************************************************
	function
*******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif

extern void	HISTORY_BUFFER_Init(HistoryBuffer *This);
extern int	HISTORY_BUFFER_Malloc(HistoryBuffer *This, int theSize);
extern void	HISTORY_BUFFER_Free(HistoryBuffer *This);

extern void	HISTORY_BUFFER_Put(HistoryBuffer *This, HistoryData *theData);
extern void	HISTORY_BUFFER_Reset(HistoryBuffer *This);
extern void	HISTORY_BUFFER_GetData(HistoryBuffer *This, int thePreviousNum, HistoryData *theBuf);

#if defined(__cplusplus)
}
#endif

#endif /* HISTORY_BUFFER_H_ */
