/**
	@file	history_data.h
	@brief	f[^p̌^pwb_
	@author	yasu
	@date	2014/05/20
 */

#ifndef HISTORY_DATA_H_
#define HISTORY_DATA_H_

/*******************************************************************************
	define/enum
*******************************************************************************/

enum {
	HISTORY_DATA_ALIGN_SIZE = 2,
};

typedef union {
	unsigned long align[HISTORY_DATA_ALIGN_SIZE];

	struct {
		int	mMedals;
	} SlumpData;

	struct {
		int	mGameCount;
		int	mBonusID;
	} BonusHistory;
} HistoryData;

enum {
	HISTORY_DATA_DEFAULT = 0,

	BONUS_ID_NONE = HISTORY_DATA_DEFAULT,
	BONUS_ID_BIG,
	BONUS_ID_REG,
	BONUS_ID_ART,
};

/*******************************************************************************
	function
*******************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

extern void	HISTORY_DATA_Init(HistoryData *This);
extern void	HISTORY_DATA_Copy(HistoryData *This, HistoryData *theData);

#if defined(__cplusplus)
}
#endif

#endif /* HISTORY_DATA_H_ */
