#include "ring_buffer.h"
#include "port_event_handler.h"
#include <stdio.h>
#include "define.h"
enum {
	EVENT_ID_HIGH = EVENT_ID_0
};

void	test(ActObjType *This)
{
	printf("test\n");
	fflush(stdout);
}

void	SetEvent(RingBuffer *theRingBuffer, short thePortID, short theEventID)
{
	Packet	aPacket;

	aPacket.event.eventID = theEventID;
	aPacket.event.portID  = thePortID;

	RING_BUFFER_Put(theRingBuffer, &aPacket);
}

int main(void)
{
	RingBuffer		aRingBuffer;
	PortEventHandler	aPortEventHandler;
	EventAction		aEventAction;
	Counter			aGameCounter;
	Counter			aBonusCounter;
	Counter			aMedalCounter;
	HistoryBuffer		aSlumpHistory;
	HistoryBuffer		aBonusHistory;
	CounterMgr		aCounterMgr;

	Packet aPacketBuf;


	RING_BUFFER_Init(&aRingBuffer);
	PORT_EVENT_HANDLER_Init(&aPortEventHandler);
	EVENT_ACTION_Init(&aEventAction);
	COUNTER_Init(&aGameCounter);
	COUNTER_Init(&aBonusCounter);
	COUNTER_Init(&aMedalCounter);
	HISTORY_BUFFER_Init(&aSlumpHistory);
	HISTORY_BUFFER_Init(&aBonusHistory);
	COUNTER_MANAGER_Init(&aCounterMgr);

	HISTORY_BUFFER_Malloc(&aSlumpHistory, 8);
	HISTORY_BUFFER_Malloc(&aBonusHistory, 5);
	COUNTER_MANAGER_SetCounter(&aCounterMgr, COUNTER_ID_GAME, &aGameCounter);
	COUNTER_MANAGER_SetCounter(&aCounterMgr, COUNTER_ID_BIG, &aBonusCounter);
	COUNTER_MANAGER_SetCounter(&aCounterMgr, COUNTER_ID_MEDAL, &aMedalCounter);
	COUNTER_MANAGER_SetSlumpHistoryBuf(&aCounterMgr, &aSlumpHistory);
	COUNTER_MANAGER_SetBonusHistoryBuf(&aCounterMgr, &aBonusHistory);

	COUNTER_MANAGER_EnableAllCounter(&aCounterMgr);

	EVENT_ACTION_SetAction(&aEventAction, &aCounterMgr, COUNTER_MANAGER_CountGame);
	PORT_EVENT_HANDLER_SetFunc(&aPortEventHandler, PORT_ID_0, EVENT_ID_HIGH, &aEventAction);

	SetEvent(&aRingBuffer, PORT_ID_1, EVENT_ID_1);
	SetEvent(&aRingBuffer, PORT_ID_0, EVENT_ID_1);
	SetEvent(&aRingBuffer, PORT_ID_1, EVENT_ID_0);
	SetEvent(&aRingBuffer, PORT_ID_0, EVENT_ID_0);

	while(TRUE == RING_BUFFER_Get(&aRingBuffer, &aPacketBuf)) {
		PORT_EVENT_HANDLER_DoFunc(&aPortEventHandler, aPacketBuf.event.portID, aPacketBuf.event.eventID);
		SetEvent(&aRingBuffer, PORT_ID_0, EVENT_ID_0);
	}

	return 0;

}
