/**
	@file	port_event_handler.h
	@brief	|[gCxgɑ΂nhNXwb_
	@author	yasu
	@date	2014/05/04
 */

#if !defined(_PORT_EVENT_HANDLER_H_)
#define	_PORT_EVENT_HANDLER_H_

/*******************************************************************************
	include
*******************************************************************************/
#include "event_handler.h"

/*******************************************************************************
	define/enum
*******************************************************************************/
enum {
	PORT_ID_0 = 0,
	PORT_ID_1,
	PORT_ID_2,
	PORT_ID_3,
	PORT_ID_4,
	PORT_ID_5,
	PORT_ID_6,
	PORT_ID_7,

	NUMOF_PORT_ID,
};

enum {
	PORT_EVENT_HIGH = EVENT_ID_0,
	PORT_EVENT_LOW = EVENT_ID_1,
};

/* o̒` */
typedef struct {
	EventHandler mPortEventHandler[NUMOF_PORT_ID];
} PortEventHandler;


/*******************************************************************************
	function
*******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif

extern void	PORT_EVENT_HANDLER_Init(PortEventHandler *This);
extern void	PORT_EVENT_HANDLER_SetFunc(PortEventHandler *This, int thePortID, int theEventID, EventAction *theEventAction);
extern void	PORT_EVENT_HANDLER_DoFunc(PortEventHandler *This, int thePortID, int theEventID);

#if defined(__cplusplus)
}
#endif

#endif	/* _PORT_EVENT_HANDLER_H_ */
