/**
	@file	ring_buffer.c
	@brief	Oobt@NX\[X
	@author	yasu
	@date	2014/05/04
 */

/*==============================================================
 *	Include
 *==============================================================
 */
#include "ring_buffer.h"
#include "define.h"


/*==============================================================
 *	Function
 *==============================================================
 */


/**
	@brief		Init
	@author		yasu
	@date		2014/05/04
	@param		*This	CX^Xւ̃|C^
	@return		none
	@remarks		p֐@RXgN^
 */
void	RING_BUFFER_Init(RingBuffer *This)
{
	int i;
	int j;

	for(i = 0; i < BUFFER_SIZE; i++ ) {
		for (j = 0; j < PACKET_ALIGN_SIZE; j++) {
			This->mBuffer[i].align[j] = 0;
		}
	}

	This->mReadPointer  = 0;
	This->mWritePointer = 0;
	This->mReadPhase    = 0;
	This->mWritePhase   = 0;
}



/**
	@brief		Put f[^
	@author		yasu
	@date		2014/05/04
	@param		*This	CX^Xւ̃|C^
	@param		*theData	ރf[^
	@return		TRUE:  / FALSE: s
	@remarks		f[^͖ǂ̃f[^cĂꍇ͏㏑łȂdlł
 */
int	RING_BUFFER_Put(RingBuffer *This, Packet *theData)
{
	if (This->mReadPointer == This->mWritePointer) {
		if (This->mWritePhase != This->mReadPhase) {
			/* ʑႢ̎ WritePointer  ReadPointer Ɠʒuɂ鎞͖ǂ̃f[^ׂĂ܂Ȃ̂ŃG[ */
			return FALSE;
		}
	}

	/* f[^̊i[ */
	This->mBuffer[This->mWritePointer] = *theData;

	/* WritePointer  1 i߂ */
	This->mWritePointer++;

	if (BUFFER_SIZE <= This->mWritePointer) {
		This->mWritePointer &= BUFFER_SIZE_MASK;

		/* ʑ̍XV */
		This->mWritePhase ^= 1;
	}

	return TRUE;
}



/**
	@brief		Put f[^擾
	@author		yasu
	@date		2014/05/04
	@param		*This	CX^Xւ̃|C^
	@param		*theBuf	ǂݏof[^̊i[ꏊ
	@return		TRUE:  / FALSE: s
	@remarks		
 */
int	RING_BUFFER_Get(RingBuffer *This, Packet *theBuf)
{
	if (This->mReadPointer == This->mWritePointer) {
		if (This->mReadPhase == This->mWritePhase) {
			/* ʑ ReadPointer  WritePointer Ɠʒuɂ鎞͖ĂȂGAǂݏoĂ܂Ȃ̂ŃG[ */
			return FALSE;
		}
	}

	*theBuf = This->mBuffer[This->mReadPointer];

	This->mReadPointer++;

	if (BUFFER_SIZE <= This->mReadPointer) {
		This->mReadPointer &= BUFFER_SIZE_MASK;

		/* ʑ̍XV */
		This->mReadPhase ^= 1;
	}

	return TRUE;
}

