/**
	@file	ring_buffer.h
	@brief	Oobt@wb_
	@author	yasu
	@date	2014/05/04
 */
#if !defined(_RING_BUFFER_H_)
#define	_RING_BUFFER_H_

/*******************************************************************************
	include
*******************************************************************************/


/*******************************************************************************
	define/enum
*******************************************************************************/
/* Oobt@Ƀobt@f[^̌^` */
enum {
	PACKET_ALIGN_SIZE = 2,
};

typedef union {
	unsigned long	align[PACKET_ALIGN_SIZE];

	struct {
		int	x;
		int	y;
	} test;

	struct {
		short	portID;
		short	eventID;
	} event;
} Packet;


/* ̐ݒ(萔)߂ */
enum {
	BUFFER_SIZE = (1 << 4),
	BUFFER_SIZE_MASK = (BUFFER_SIZE - 1),
};

/* Oobt@NX̃oɑ\̂ */
typedef struct {
	Packet mBuffer[BUFFER_SIZE];

	unsigned short	mWritePointer;
	unsigned short	mReadPointer;
	unsigned char	mWritePhase;
	unsigned char	mReadPhase;
} RingBuffer;


/*******************************************************************************
	function
*******************************************************************************/
/* \bh̒` */
#if defined(__cplusplus)
extern "C" {
#endif

extern void	RING_BUFFER_Init(RingBuffer *This);	// RXgN^ɑ

extern int	RING_BUFFER_Put(RingBuffer *This, Packet *theData);
extern int	RING_BUFFER_Get(RingBuffer *This, Packet *theBuf);

#if defined(__cplusplus)
}
#endif

#endif	/* _RING_BUFFER_H_ */

