
#include "AppIF.h"
#include "define.h"

AppIF::AppIF()
{
	RING_BUFFER_Init(&this->mRingBuffer);
	PORT_EVENT_HANDLER_Init(&this->mPortEventHandler);
	EVENT_ACTION_Init(&this->mActionGameCount);
	EVENT_ACTION_Init(&this->mActionBigStart);
	EVENT_ACTION_Init(&this->mActionBigEnd);
	EVENT_ACTION_Init(&this->mActionRegStart);
	EVENT_ACTION_Init(&this->mActionRegEnd);
	EVENT_ACTION_Init(&this->mActionPayMedal);
	EVENT_ACTION_Init(&this->mActionBetMedal);
	COUNTER_Init(&this->mGameCounter);
	COUNTER_Init(&this->mBigCounter);
	COUNTER_Init(&this->mRegCounter);
	COUNTER_Init(&this->mMedalCounter);
	COUNTER_Init(&this->mTotalGameCounter);
	HISTORY_BUFFER_Init(&this->mSlumpHistory);
	HISTORY_BUFFER_Init(&this->mBonusHistory);
	COUNTER_MANAGER_Init(&this->mCounterMgr);
	
	HISTORY_BUFFER_Malloc(&this->mSlumpHistory, 8);
	HISTORY_BUFFER_Malloc(&this->mBonusHistory, 5);
	COUNTER_MANAGER_SetCounter(&this->mCounterMgr, COUNTER_ID_GAME, &this->mGameCounter);
	COUNTER_MANAGER_SetCounter(&this->mCounterMgr, COUNTER_ID_BIG, &this->mBigCounter);
	COUNTER_MANAGER_SetCounter(&this->mCounterMgr, COUNTER_ID_MEDAL, &this->mMedalCounter);
	COUNTER_MANAGER_SetCounter(&this->mCounterMgr, COUNTER_ID_REG, &this->mRegCounter);
	COUNTER_MANAGER_SetCounter(&this->mCounterMgr, COUNTER_ID_TOTAL_GAME, &this->mTotalGameCounter);
	COUNTER_MANAGER_SetSlumpHistoryBuf(&this->mCounterMgr, &this->mSlumpHistory);
	COUNTER_MANAGER_SetBonusHistoryBuf(&this->mCounterMgr, &this->mBonusHistory);

	COUNTER_MANAGER_EnableAllCounter(&this->mCounterMgr);

	EVENT_ACTION_SetAction(&this->mActionGameCount, &this->mCounterMgr, COUNTER_MANAGER_CountGame);
	EVENT_ACTION_SetAction(&this->mActionBigStart, &this->mCounterMgr, COUNTER_MANAGER_StartBig);
	EVENT_ACTION_SetAction(&this->mActionBigEnd, &this->mCounterMgr, COUNTER_MANAGER_EndBig);
	EVENT_ACTION_SetAction(&this->mActionRegStart, &this->mCounterMgr, COUNTER_MANAGER_StartReg);
	EVENT_ACTION_SetAction(&this->mActionRegEnd, &this->mCounterMgr, COUNTER_MANAGER_EndReg);
	EVENT_ACTION_SetAction(&this->mActionPayMedal, &this->mCounterMgr, COUNTER_MANAGER_OutMedal);
	EVENT_ACTION_SetAction(&this->mActionBetMedal, &this->mCounterMgr, COUNTER_MANAGER_BetMedal);
	PORT_EVENT_HANDLER_SetFunc(&this->mPortEventHandler, PORT_ID_0, EVENT_ID_HIGH, &this->mActionGameCount);
	PORT_EVENT_HANDLER_SetFunc(&this->mPortEventHandler, PORT_ID_1, EVENT_ID_HIGH, &this->mActionBigStart);
	PORT_EVENT_HANDLER_SetFunc(&this->mPortEventHandler, PORT_ID_1, EVENT_ID_LOW, &this->mActionBigEnd);
	PORT_EVENT_HANDLER_SetFunc(&this->mPortEventHandler, PORT_ID_2, EVENT_ID_HIGH, &this->mActionRegStart);
	PORT_EVENT_HANDLER_SetFunc(&this->mPortEventHandler, PORT_ID_2, EVENT_ID_LOW, &this->mActionRegEnd);
	PORT_EVENT_HANDLER_SetFunc(&this->mPortEventHandler, PORT_ID_3, EVENT_ID_HIGH, &this->mActionPayMedal);
	PORT_EVENT_HANDLER_SetFunc(&this->mPortEventHandler, PORT_ID_4, EVENT_ID_HIGH, &this->mActionBetMedal);
}



void	AppIF::SetEvent(int thePortID, int theEventID)
{
	Packet	aPacket;

	aPacket.event.portID  = thePortID;
	aPacket.event.eventID = theEventID;

	RING_BUFFER_Put(&this->mRingBuffer, &aPacket);
}


void	AppIF::ParseEvent(void)
{
	Packet aPacketBuf;
	while(TRUE == RING_BUFFER_Get(&this->mRingBuffer, &aPacketBuf)) {
		PORT_EVENT_HANDLER_DoFunc(&this->mPortEventHandler, aPacketBuf.event.portID, aPacketBuf.event.eventID);
	}
}


int	AppIF::GetGameCount(void)
{
	return COUNTER_GetCount(&this->mGameCounter);
}


int	AppIF::GetBigCount(void)
{
	return COUNTER_GetCount(&this->mBigCounter);
}


int	AppIF::GetRegCount(void)
{
	return COUNTER_GetCount(&this->mRegCounter);
}


int	AppIF::GetMedalCount(void)
{
	return COUNTER_GetCount(&this->mMedalCounter);
}


int	AppIF::GetTotalGameCount(void)
{
	return COUNTER_GetCount(&this->mTotalGameCounter);
}


void	AppIF::GetBonusHisotry(int thePreviousNum, HistoryData *theBuf)
{
	HISTORY_BUFFER_GetData(&this->mBonusHistory, thePreviousNum, theBuf);
}