#ifndef	APP_IF_H_
#define APP_IF_H_
#include "ring_buffer.h"
#include "port_event_handler.h"

enum {
	EVENT_ID_HIGH = EVENT_ID_0,
	EVENT_ID_LOW  = EVENT_ID_1
};

class AppIF
{
private:
	RingBuffer		mRingBuffer;
	PortEventHandler	mPortEventHandler;
	EventAction		mActionGameCount;
	EventAction		mActionBigStart;
	EventAction		mActionBigEnd;
	EventAction		mActionRegStart;
	EventAction		mActionRegEnd;
	EventAction		mActionPayMedal;
	EventAction		mActionBetMedal;
	Counter			mGameCounter;
	Counter			mBigCounter;
	Counter			mMedalCounter;
	Counter			mRegCounter;
	Counter			mTotalGameCounter;
	HistoryBuffer		mSlumpHistory;
	HistoryBuffer		mBonusHistory;
	CounterMgr		mCounterMgr;

public:
	/* RXgN^ */
	AppIF();
	
	void	SetEvent(int thePortID, int theEventID);
	void	ParseEvent(void);

	int	GetGameCount(void);
	int	GetBigCount(void);
	int	GetRegCount(void);
	int	GetMedalCount(void);
	int	GetTotalGameCount(void);

	void	GetBonusHisotry(int thePreviousNum, HistoryData *theBuf);
};



#endif	/* APP_IF_H_ */