#include <windows.h>
#include "AppIF.h"

#define	ID_BIG_START	1000
#define	ID_BIG_END	1100
#define	ID_REG_START	1200
#define	ID_REG_END	1300
#define	ID_BET_MEDAL	1400
#define	ID_PAY_MEDAL	1500
#define	ID_GAME_COUNT	1600

#define	ID_MYTIMER	32767

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
BOOL InitApp(HINSTANCE);
BOOL InitInstance(HINSTANCE, int);

HFONT SetMyFont(HDC);
void	PrintHistory(HDC hdc, int thePreviousNum);

LPCSTR szClassName = "font02";    //NX

AppIF	gAppIF;
int WINAPI WinMain(HINSTANCE hCurInst, HINSTANCE hPrevInst, LPSTR lpsCmdLine, int nCmdShow)
{
    MSG msg;

	if (!hPrevInst) {
		if (!InitApp(hCurInst)) {
			return FALSE;
		}
	}
	if (!InitInstance(hCurInst, nCmdShow)) {
		return FALSE;
	}
	while (GetMessage(&msg, NULL, NULL, NULL)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

//EBhEENX̓o^

BOOL InitApp(HINSTANCE hInst)
{
	WNDCLASS wc;
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WndProc;    //vV[W
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInst;        //CX^X
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = NULL;    //j[
	wc.lpszClassName = szClassName;
	return (RegisterClass(&wc));
}

//EBhE̐

BOOL InitInstance(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;

	hWnd = CreateWindow(szClassName,
		"JE^[V~[^",//^Cgo[ɂ̖O\܂
		WS_OVERLAPPEDWINDOW,    //EBhE̎
		CW_USEDEFAULT,    //wW
		CW_USEDEFAULT,    //xW
		500,//CW_USEDEFAULT,    //
		500,//CW_USEDEFAULT,    //
		NULL,            //eEBhẼnhAeƂNULL
		NULL,            //j[nhANXj[gƂNULL
		hInst,            //CX^Xnh
		NULL);
	if (!hWnd) {
	        return FALSE;
	}
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
	return TRUE;
}

//EBhEvV[W

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	int id;
	HDC hdc;
	HFONT hFont, hFontOld;
	PAINTSTRUCT ps;
	HWND hButtonWnd1, hButtonWnd2, hButtonWnd3, hButtonWnd4, hButtonWnd5, hButtonWnd6, hButtonWnd7;
	HINSTANCE hInst;
	hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
	switch (msg) {
	case WM_CREATE:
		if (SetTimer(hWnd, ID_MYTIMER, 200, NULL) == 0) {
			MessageBox(hWnd, (LPCSTR)"s ", (LPCSTR)"s", MB_OK | MB_ICONEXCLAMATION);
		}

		hButtonWnd1 = CreateWindow(
			"BUTTON", "BIG START", 
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			20, 20, 110, 30, hWnd, (HMENU)ID_BIG_START, hInst ,NULL);
		hButtonWnd2 = CreateWindow(
			"BUTTON", "BIG END",
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			140, 20, 110, 30, hWnd, (HMENU)ID_BIG_END, hInst, NULL);
		hButtonWnd3 = CreateWindow(
			"BUTTON", "REG START", 
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			20, 60, 110, 30, hWnd, (HMENU)ID_REG_START, hInst, NULL);
		hButtonWnd4 = CreateWindow(
			"BUTTON", "REG END",
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			140, 60, 110, 30, hWnd, (HMENU)ID_REG_END, hInst, NULL);
		hButtonWnd5 = CreateWindow(
			"BUTTON", "BET MEDAL",
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			20, 100, 110, 30, hWnd, (HMENU)ID_BET_MEDAL, hInst, NULL);
		hButtonWnd6 = CreateWindow(
			"BUTTON", "PAY MEDAL",
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			140, 100, 110, 30, hWnd, (HMENU)ID_PAY_MEDAL, hInst, NULL);
		hButtonWnd7 = CreateWindow(
			"BUTTON", "GAME COUNT",
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			20, 140, 110, 30, hWnd, (HMENU)ID_GAME_COUNT, hInst, NULL);
		break;
	case WM_TIMER:
		gAppIF.ParseEvent();
		InvalidateRect(hWnd, NULL, FALSE);
		break;
	case WM_COMMAND:
		switch(LOWORD(wp)) {
		case ID_BIG_START:
			gAppIF.SetEvent(PORT_ID_1, EVENT_ID_HIGH);
			break;
		case ID_BIG_END:
			gAppIF.SetEvent(PORT_ID_1, EVENT_ID_LOW);
			break;
		case ID_REG_START:
			gAppIF.SetEvent(PORT_ID_2, EVENT_ID_HIGH);
			break;
		case ID_REG_END:
			gAppIF.SetEvent(PORT_ID_2, EVENT_ID_LOW);
			break;
		case ID_PAY_MEDAL:
			gAppIF.SetEvent(PORT_ID_3, EVENT_ID_HIGH);
			break;
		case ID_BET_MEDAL:
			gAppIF.SetEvent(PORT_ID_4, EVENT_ID_HIGH);
			break;
		case ID_GAME_COUNT:
			gAppIF.SetEvent(PORT_ID_0, EVENT_ID_HIGH);
			break;
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		hFont = SetMyFont(hdc);
		hFontOld = (HFONT)SelectObject(hdc, hFont);
		{
			char str[50];

			TextOut(hdc, 300, 20, "BIG", 3);
			wsprintf((LPSTR)str, ": %5d", gAppIF.GetBigCount());
			TextOut(hdc, 350, 20, (LPCTSTR)str, strlen(str));

			TextOut(hdc, 300, 60, "REG", 3);
			wsprintf((LPSTR)str, ": %5d", gAppIF.GetRegCount());
			TextOut(hdc, 350, 60, (LPCTSTR)str, strlen(str));
			
			TextOut(hdc, 300, 100, "MEDAL", 5);
			wsprintf((LPSTR)str, ": %5d", gAppIF.GetMedalCount());
			TextOut(hdc, 350, 100, (LPCTSTR)str, strlen(str));

			TextOut(hdc, 300, 140, "GAME", 4);
			wsprintf((LPSTR)str, ": %5d", gAppIF.GetGameCount());
			TextOut(hdc, 350, 140, (LPCTSTR)str, strlen(str));
			
			TextOut(hdc, 300, 180, "TOTAL", 5);
			wsprintf((LPSTR)str, ": %5d", gAppIF.GetTotalGameCount());
			TextOut(hdc, 350, 180, (LPCTSTR)str, strlen(str));

			TextOut(hdc, 20, 210, "", 5);

			for (int i = 1; i <= 5; i++) {
				PrintHistory(hdc, i);
			}

		}
		SelectObject(hdc, hFont);
		EndPaint(hWnd, &ps);
		break;
	case WM_CLOSE:
		id = MessageBox(hWnd,
			(LPCSTR)"IĂ悢ł",
			(LPCSTR)"ImF",
			MB_YESNO | MB_ICONQUESTION);
		if (id == IDYES) {
			DestroyWindow(hWnd);
		}
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return (DefWindowProc(hWnd, msg, wp, lp));
	}
	return 0L;
}

HFONT SetMyFont(HDC hdc)
{
	HFONT hFont;
	hFont = CreateFont(20,			// tHg
		0,				// 
		0,				// eLXg̊px
		0,				// x[XCƂƂ̊px
		FW_REGULAR,			// tHg̏dij
		FALSE,				// C^bN
		FALSE,				// A_[C
		FALSE,				// ł
		SHIFTJIS_CHARSET,		// Zbg
		OUT_DEFAULT_PRECIS,		// o͐x
		CLIP_DEFAULT_PRECIS,		// NbsOx
		PROOF_QUALITY,			// o͕i
		FIXED_PITCH | FF_MODERN,	// sb`ƃt@~[
		(LPCTSTR)"lr SVbN");	// ̖
	return hFont;
}

void	PrintHistory(HDC hdc, int thePreviousNum)
{
	HistoryData	aData;
	char bonusType[10];
	char str[50];

	gAppIF.GetBonusHisotry(thePreviousNum, &aData);
	switch (aData.BonusHistory.mBonusID) {
	case BONUS_ID_BIG:
		wsprintf((LPSTR)bonusType, "BIG");
		break;
	case BONUS_ID_REG:
		wsprintf((LPSTR)bonusType, "REG");
		break;
	default:
		wsprintf((LPSTR)bonusType, "");
		break;
	}
	wsprintf((LPSTR)str, "%5d. GAME : %5d, BONUS : %4s", thePreviousNum, aData.BonusHistory.mGameCount, bonusType);
	TextOut(hdc, 20, 210+(thePreviousNum * 30), (LPCTSTR)str, strlen(str));
}

