#ifndef GGAFCORE_GGAFGACTORY_H_
#define GGAFCORE_GGAFGACTORY_H_
#include "GgafCommonHeader.h"

#ifndef _MSC_VER
    #include <atomic>
#endif

#define ORDER_ID_MAX     (0xffffffffffffffffULL)

namespace GgafCore {

/**
 * CX^XHNX .
 * CXbhi̐̃V[c[jA(GgafOrder)nƁAʃXbhiHjɁA
 * ̃CX^X𐶐(new)܂B<BR>
 * oオCX^X(iƌĂ)̃|C^B͍HŃXgbNACKvɉďi
 * oƂo܂<BR>
 * y⑫z<BR>
 * ȂȂ₱̂B́AʃCX^X鎞_ŐȂ΂Ȃ悤ȌŁA
 * 炩ɏ߁B<BR>
 * Xe[W̃[fBOÂ悭̂łA{XOŁAQ[isuuEbvƎ~܂(킩邩Ȃ)
 * ̂𖳂߂łB<BR>
 * 𑁂߂ɂĂƁAX[YɃQ[is͂Ɩژ_ށB<BR>
 * @version 1.00
 * @since 2007/12/27
 * @author Masatoshi Tsuge
 */
class GgafFactory {
    friend class GgafGod;

private:
    /**
     * HɒsiCXbhgpj .
     * @param prm_order_no	ԍ
     * @param prm_pFunc	ۂɐs֐̃|C^
     * @param prm_pOrderer 
     * @param prm_pReceiver 󂯎\
     * @param prm_pArg1	s֐ւ̈1
     * @param prm_pArg2	s֐ւ̈2
     * @param prm_pArg3	s֐ւ̈3
     */
    static void order(uint64_t prm_order_no,
                      GgafObject* (*prm_pFunc)(void*, void*, void*),
                      GgafObject* prm_pOrderer,
                      GgafObject* prm_pReceiver,
                      void* prm_pArg1,
                      void* prm_pArg2,
                      void* prm_pArg3);

    /**
     * i󂯎iCXbhgpj .
     * ꍇA܂ő҂B<BR>
     * @param   prm_order_no	ԍ
     * @param   prm_pReceiver	l
     * @return	ĩ|C^
     */
    static void* obtain(uint64_t prm_order_no, GgafObject* prm_pReceiver);

public:
    /** 擪̒ */
    static GgafOrder* ROOT_ORDER;
    /** ݐ̒ */
    static GgafOrder* CREATING_ORDER;
    //CREATING_ORDER ́ASĐς݂̏ꍇAŏIwÂ
    //SĐς݂AiSĎ擾Ă܂ꍇ nullptr ɂȂB
    //_is_last_order_flg == false ɔ肵AŏIłȂȂiVK΁jA
    //sĎɐi߂B _is_last_order_flg == false ɂȂ܂ŐÂ
    // ܂A擪Ɩ̒|C^łȂĂ()

    //      ROOT_ORDER
    //        
    //      pOrder <-> pOrder <-> pOrder <-> pOrder <-> pOrder <-> pOrder
    //     ()   ()  ij  ()   ()   ()
    //                                                          _is_last_order_flg == true
    //                        CREATING_ORDER
    //                    IƉEɓ  ===>
    //
    //prev <------Â----------------------------------V-----> next
    //                                               ͖ɂĂ
#ifdef _MSC_VER
    //x86nȂ΃Ag~bNEEEEEEEEB
    /** [r]tO(_삷) */
    static volatile bool _is_working_flg;
    /** [r]xރtO */
    static volatile bool _have_to_rest_flg;
    /** [r]xłtO */
    static volatile bool _is_resting_flg;
    /** [r]SXI */
    static volatile bool _was_finished_flg;
#else
    /** [r]tO(_삷) */
    static volatile std::atomic<bool> _is_working_flg;
    /** [r]xރtO */
    static volatile std::atomic<bool> _have_to_rest_flg;
    /** [r]xłtO */
    static volatile std::atomic<bool> _is_resting_flg;
    /** [r]SXI */
    static volatile std::atomic<bool> _was_finished_flg;
#endif
public:
    /**
     * HɃAN^[쐬̒siCXbhgpj .
     * ꍇA܂ő҂B<BR>
     * @tparam X AN^[̌^
     * @param prm_order_no ԍ
     * @param prm_pFunc ۂɐs֐̃|C^
     * @param prm_pOrderer 
     * @param prm_pReceiver l
     * @param prm_pArg1 s֐ւ̈1
     * @param prm_pArg2 s֐ւ̈2
     * @param prm_pArg3 s֐ւ̈3
     */
    template<class X>
    static void orderActor(uint64_t prm_order_no,
                           X* (*prm_pFunc)(void*, void*, void*),
                           GgafObject* prm_pOrderer,
                           GgafObject* prm_pReceiver,
                           void* prm_pArg1,
                           void* prm_pArg2,
                           void* prm_pArg3) {
        order(prm_order_no, (GgafObject* (*)(void*, void*, void*))prm_pFunc, prm_pOrderer, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
    }

    /**
     * HɃV[쐬̒siCXbhgpj .
     * ꍇA܂ő҂B<BR>
     * @tparam X V[̌^
     * @param prm_order_no ԍ
     * @param prm_pFunc	ۂɐs֐̃|C^
     * @param prm_pOrderer 
     * @param prm_pReceiver l
     * @param prm_pArg1	s֐ւ̈1
     * @param prm_pArg2	s֐ւ̈2
     * @param prm_pArg3	s֐ւ̈3
     */
    template<class X>
    static void orderScene(uint64_t prm_order_no,
                           X* (*prm_pFunc)(void*, void*, void*),
                           GgafObject* prm_pOrderer,
                           GgafObject* prm_pReceiver,
                           void* prm_pArg1,
                           void* prm_pArg2,
                           void* prm_pArg3) {
        GgafFactory::order(prm_order_no, (GgafObject* (*)(void*, void*, void*))prm_pFunc, prm_pOrderer, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
    }

    /**
     * AN^[󂯎BiCXbhgpj .
     * CĂяo܂B<BR>
     * ꍇA܂ő҂B<BR>
     * @param   prm_order_no ԍ
     * @param   prm_pReceiver l
     * @return	ꂽAN^[̃|C^
     */
    static GgafMainActor* obtainActor(uint64_t prm_order_no, GgafObject* prm_pReceiver);

    /**
     * V[󂯎BiCXbhgpj .
     * CĂяo܂B<BR>
     * ꍇA܂ő҂B<BR>
     * @param   prm_order_no ԍ
     * @param   prm_pReceiver l
     * @return	ꂽV[̃|C^
     */
    static GgafMainScene* obtainScene(uint64_t prm_order_no, GgafObject* prm_pReceiver);

    /**
     * 󂯎B
     * @tparam X ǐ^
     * @param prm_pFunc
     * @param prm_pOrderer
     * @param prm_pReceiver
     * @param prm_pArg1
     * @param prm_pArg2
     * @param prm_pArg3
     * @param prm_org
     * @return oオi
     */
    template<class X>
    static X* makeObject(X* (*prm_pFunc)(void*, void*, void*),
                         GgafObject* prm_pOrderer,
                         GgafObject* prm_pReceiver,
                         void* prm_pArg1,
                         void* prm_pArg2,
                         void* prm_pArg3,
                         GgafObject* prm_org) {
        GgafFactory::order(ORDER_ID_MAX, (GgafObject* (*)(void*, void*, void*))prm_pFunc, prm_pOrderer, prm_pReceiver, prm_pArg1, prm_pArg2, prm_pArg3);
        return (X*)(GgafFactory::obtain(ORDER_ID_MAX, prm_org));
    }

    /**
     * ioオĂ邩ׂBiCXbhgpj .
     * @param   prm_order_no   ԍ
     * @return   ԍ̏i̐i(-2:Hꎩ̂ĂȂ/-1:炵ĂȂ/0:ς݂ōHꖢ/1:/2:ς݁j
     */
    static int chkProgress(uint64_t prm_order_no);

    /**
     * H|iCXbhgpj .
     * C̐_Ăяo܂B<BR>
     * ROOT_ORDER wĂ鐻i̘AXgSĉ<BR>
     * ӁFKȉ̂悤ɃNeBJZNVň͂ŌĂяoĂIB<BR>
     * R[h၄ <BR>
     *     BEGIN_SYNCHRONIZED1; // ----->rJn<BR>
     * GgafFactory::clean();<BR>
     *     END_SYNCHRONIZED1; // <----- rI<BR>
     */
    static void clean();

    static void removeOrder(GgafObject* prm_pReceiver);

    /**
     * ғBiHXbhC[vj.
     * _iGgafGodjݒ莞ɕʃXbhňxsA\bhŖ[vĂ܂B<BR>
     * ΍쐬AXgbN܂B<BR>
     * _ʂ܂ŁiAvI܂ŁjiɉғłB<BR>
     */
    static unsigned __stdcall work(void* prm_arg);

    /**
     * Hꎞx~w iCXbhgpj .
     * ĂяoĂɋx~ԂɂȂƂ͌܂B<BR>
     * isResting() ŊSx~܂Œׂ鑱Kv܂B<BR>
     */
    static void beginRest();
    /**
     * H̏Ԃ擾iCXbhgpj .
     * @return true=x~/false=ғ
     */
    static bool isResting();

    /**
     * Hx~̉w iCXbhgpj .
     */
    static void finishRest();

    /**
     * i𐶐(͂P) .
     * @tparam X ǐ^
     * @param p1 ïׂ̈1 (gp)
     * @param p2 ïׂ̈2 ()
     * @param p3 ïׂ̈3 ()
     * @return ꂽi
     */
    template<class X>
    static X* create(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((const char*)p1);
        return p;
    }

    /**
     * i𐶐(͂Q) .
     * @tparam X ǐ^
     * @param p1 ïׂ̈1 (gp)
     * @param p2 ïׂ̈2 (gp)
     * @param p3 ïׂ̈3 ()
     * @return ꂽi
     */
    template<class X>
    static X* create2(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((const char*)p1, (const char*)p2);
        return p;
    }

    /**
     * AN^[𐶐(͂P) .
     * @tparam X AN^[̌^
     * @param p1 AN^[ׂ̈̈1 (gp)
     * @param p2 AN^[ׂ̈̈2 ()
     * @param p3 AN^[ׂ̈̈3 ()
     * @return ꂽAN^[
     */
    template<class X>
    static X* createActor(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((const char*)p1);
        return p;
    }

    /**
     * V[𐶐(͂P) .
     * @tparam X AN^[̌^
     * @param p1 V[ׂ̈̈1 (gp)
     * @param p2 V[ׂ̈̈2 ()
     * @param p3 V[ׂ̈̈3 ()
     * @return ꂽV[
     */
    template<class X>
    static X* createScene(void* p1, void* p2, void* p3) {
        //Sceneňԑ`̈B
        //p1 : ʖ
        X* p = NEW X((const char*)p1);
        return p;
    }

    static void debuginfo();

};
#define orderSceneToFactory(ID, CLASS, NAME) (GgafCore::GgafFactory::orderScene<CLASS>((ID),GgafCore::GgafFactory::createScene, this, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr)))
#define orderActorToFactory(ID, CLASS, NAME) (GgafCore::GgafFactory::orderActor<CLASS>((ID),GgafCore::GgafFactory::createActor, this, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr)))
#define obtainActorFromFactory(ID) (GgafCore::GgafFactory::obtainActor((ID),this))
#define obtainSceneFromFactory(ID) (GgafCore::GgafFactory::obtainScene((ID),this))
#define createInFactory(CLASS, NAME) (GgafCore::GgafFactory::makeObject<CLASS>(GgafCore::GgafFactory::create, this, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr),this))
#define createInFactory2(CLASS, NAME, MODEL) (GgafCore::GgafFactory::makeObject<CLASS>(GgafCore::GgafFactory::create2, this, this, (void*)(NAME),(void*)(MODEL),(void*)(nullptr),this))

}
#endif /*GGAFCORE_GGAFGACTORY_H_*/
