#ifndef GGAFCORE_GGAFPROGRESS_H_
#define GGAFCORE_GGAFPROGRESS_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#define PROGRESS_NOTHING (-1)
#define PROGRESS_NULL (-2)

typedef int progress;

namespace GgafCore {

/**
 * ԑJڐiǗNX .
 * ԑJڂǗ@\̃NXłB
 * Ԍo߂ɔAiԍύXs\bh񋟁A
 * ܂AiԍύXɔlXȏ̃\bh񋟂B<br>
 * @version 1.00
 * @since 2010/11/18
 * @author Masatoshi Tsuge
 */
class GgafProgress : public GgafObject {

public:
    /** [r]ݐiԍ(-1, 0`) */
    progress _progress;
    /** [r]PPʎԑO̐iԍ(-1, 0`) */
    progress _progress_prev;
    /** [r]̒PʎԉZɔf\̐iԍ(-1, 0`) */
    progress _progress_next;
    /** [r]eiԍ̐iύX̎Ԃ̕ۑ */
    frame* _pa_frame_of_progress_changed;
    /** [r]ԃJE^[(Ԍo߂ɔ鉽炩̕ϐ)̎Q */
    frame* _p_frame_counter;
    /** Ǘiԍ̌ */
    int _num_progress;

public:
    /**
     * RXgN^ .
     * ̐iԍ PROGRESS_NOTHING(-1) ɐݒ肳ĂB<BR>
     * ́Aǂ̐iԂłӖŐݒ肵ĂB<BR>
     * ʏ̐iԂ 0` ƂB<BR>
     * @param prm_p_frame_counter ԃJE^[̎Q(炩o߂ɔCNg(+1)Ăϐ̎Q)
     * @param prm_num_progress őiԍ(10ݒ肷 0ԁ`10Ԃ11̐iԂgp\ƂȂ)
     */
    GgafProgress(frame* prm_p_frame_counter, int prm_num_progress);


    void reset();

    /**
     * ݂̐iԍ擾 .
     * @return iԍ(PROGRESS_NOTHING or 0`)
     */
    inline progress get() const {
        return _progress;
    }

    inline int getProgressNum() const {
        return _num_progress;
    }

    /**
     * ݂̐i𑦍ɐݒ肷 .
     * ɔfB-1 ͐ݒsB<BR>
     * Ȃǂł͂ reset(int) gpA<BR>
     * ԕω change(int) gpB<BR>
     * Ƃ݌vB<BR>
     * yӁz<BR>
     * hasJustChanged() ͐܂B<BR>
     * @param prm_progress iԍ(0`)
     */
    void reset(progress prm_progress);

    /**
     * ݂̐i𖳂 PROGRESS_NOTHING(-1) ɐݒ肷 .
     * ɔfB
     */
    void setNothing();

    /**
     * ̐iԍ֕ύXꂽ̎Ԃ𒲂ׂ .
     * @param prm_progress iԍ(0`)
     * @return ̐iԍ֕ύXꂽ()̎
     */
    frame getFrameWhenChanged(progress prm_progress) const;

    /**
     * ݂̐iԍŉt[Ȃ̂擾(0`) .
     * hasJustChanged()  1 ԂBiZbgj
     * ̌AZĂB
     * @return ioߎ
     */
    inline frame getFrame() const {
        return ((*_p_frame_counter) - _pa_frame_of_progress_changed[_progress+1]);
    }

    /**
     * ݂̐iԍł̃t[ƈ̃t[𒲂ׂ .
     * @param prm_frame
     * @return
     */
    inline bool hasArrivedAt(frame prm_frame) const {
        return prm_frame == ((*_p_frame_counter) - _pa_frame_of_progress_changed[_progress+1]) ? true : false;
    }

    /**
     * iԍύX .
     * AAɂ͔fꂸ update() ɔfB
     * PROGRESS_NOTHING(-1) ͐ݒsB
     * reset(progress) Ǝg邱ƁB
     * @param prm_progress iԍ(0`)
     */
    virtual void change(progress prm_progress);

    /**
     * iԍmʂŕύX .
     * yLz<br>
     * <code>
     * _pProg->changeProbab(
     *              60, PROG_MOVE01,
     *               0, PROG_MOVE02,
     *              20, PROG_MOVE03,
     *               0, PROG_MOVE04,
     *              15, PROG_MOVE05,
     *              10, PROG_MOVE06,
     *               5, PROG_MOVE07
     *         );
     * </code>
     * yL̈Ӗz<br>
     * 60% ̊mŐiԍ PROG_MOVE01 ɕύXA<br>
     *  0% ̊mŐiԍ PROG_MOVE02 ɕύXA<br>
     * 20% ̊mŐiԍ PROG_MOVE03 ɕύXA<br>
     *  0% ̊mŐiԍ PROG_MOVE04 ɕύXA<br>
     * 15% ̊mŐiԍ PROG_MOVE05 ɕύXA<br>
     * 10% ̊mŐiԍ PROG_MOVE06 ɕύXA<br>
     *  5% ̊mŐiԍ PROG_MOVE07 ɕύXA<br>
     * <br>
     * miSj̍vK 100 ɂȂKv܂B<br>
     * iIɁÅm̘a100ɂȂ܂ŁAiɈǂݍݑ܂BӂĎgpāIj<br>
     * @param prm_p1 m̂P
     * @param prm_v1 ̊mŕύXiԍ̂P(0`)
     */
    void changeProbab(uint32_t prm_p1, progress prm_v1, ...);

    /**
     * iԍ𖳂 PROGRESS_NOTHING(-1) ɕύX .
     * AAɂ͔fꂸ update() ɔfB
     */
    virtual void changeNothing();

    /**
     * iԍ+1 .
     * AAɂ͔fꂸ update() ɔfB
     * change(_progress+1) ƓӖłB
     */
    virtual void changeNext();

    /**
     * ݂̐iԍł̃t[ƈ̃t[Ȃ΁Aiԍ+1 .
     * AAɂ͔fꂸ update() ɔfB
     * @param prm_frame
     */
    inline void changeNextWhenArrivedAt(frame prm_frame) {
        if (hasArrivedAt(prm_frame)) {
            changeNext();
        }
    }

    /**
     * iԍ؂ւȂ̂ǂ𔻒B .
     * change(progress) ɂiԍ؂ւ update()  true ɂȂ܂B<BR>
     * reset(progress) ɂiԍ؂ւꍇ͐܂B<BR>
     * change(progress)  changeNext() st[Ŏ擾B
     * @return true:iɐ؂ւł^false:ȊO
     */
    inline bool hasJustChanged() const {
        if (_progress != _progress_prev && _progress_prev >= PROGRESS_NOTHING) {
            return true;
        } else {
            return false;
        }
    }
    /**
     * ݂̐iԍPROGRESS_NOTHINGۂׂB .
     * @return
     */
    inline bool isNothing() const {
        return _progress == PROGRESS_NOTHING ? true : false;
    }

    /**
     * ̐iԍɐ؂ւȂ̂ǂׂB.
     * hasJustChanged() Ɍ݂̐iԍ̏t܂B
     * change(progress)  changeNext() st[Ŏ擾B
     * @param prm_progress ݂̐iԍ
     * @return true:̐iԍɐ؂ւ^false:ł͂Ȃ
     */
    bool hasJustChangedTo(progress prm_progress) const;

    /**
     * ̐iԍ؂ւȂ̂ǂ𒲂ׂB.
     * hasJustChanged() ɑO̐iԍ̏t܂B
     * change(progress)  changeNext() st[Ŏ擾B
     * @param prm_progress Oi؂ւOj̐iԍ
     * @return true:؂ւہAO̐iԍ͈̐iԍ^false:ł͂Ȃ
     */
    bool hasJustChangedFrom(progress prm_progress) const;

    /**
     * iԍωiOƓǂjׂ .
     * ωꍇA̐ViԍԂB
     * change(progress)  changeNext() st[Ŏ擾B
     * reset(progress) ɂiԍ؂ւꍇ͐܂B<BR>
     * @return PROGRESS_NULL(-2)  PROGRESS_NOTHING(-1)  iԍ
     *         PROGRESS_NULL   FiԍωĂȂ
     *         PROGRESS_NOTHINGFiԍ PROGRESS_NOTHING(-1) ɕωゾB
     *         0`             Fiԍωł̂ŁA̐ViԍԂ
     */
    progress getProgOnChange() const;

    /**
     * iԍωׂ .
     * ωꍇǍ̐iԍԂB
     * change(progress)  changeNext() st[Ŏ擾B
     * reset(progress) ɂiԍ؂ւꍇ͐܂B<BR>
     * @return PROGRESS_NULL(-2)  PROGRESS_NOTHING(-1)  iԍ
     *         PROGRESS_NULL   FiԍωĂȂ
     *         PROGRESS_NOTHINGFiԍ PROGRESS_NOTHING(-1) ωゾB
     *         0`             Fiԍωł̂ŁAωǑ̐iԍԂ
     */
    progress getFromProgOnChange() const;

    /**
     * iԍt[ɕύX\Ȃ΁A݂̐iԍ擾 .
     * t[ change(progress)  changeNext() sς݂̏ꍇA擾B
     * @return PROGRESS_NULL(-2)  PROGRESS_NOTHING(-1)  iԍ
     *         PROGRESS_NULL   Ft[ɐiԍύX\ł͂ȂB
     *         PROGRESS_NOTHINGFݐi PROGRESS_NOTHING(-1) ŁAt[ɐiԍύX\łB
     *         0`             Ft[ɐiԍύX\ł̂ŁA݂̐iԍԂB
     */
    progress getProgWhenProgWillChange() const;

    /**
     * iԍt[ɕύX\Ȃ΁A̕ύXiԍ擾 .
     * t[ change(progress)  changeNext() sς݂̏ꍇA擾B
     * @return PROGRESS_NULL(-2)  PROGRESS_NOTHING(-1)  iԍ
     *         PROGRESS_NULL   Ft[ɐiԍύX\ł͂ȂB
     *         PROGRESS_NOTHINGFt[ɐi PROGRESS_NOTHING(-1) ƂȂ\łB
     *         0`             Ft[ɐiԍύX\ł̂ŁA̐ViԍԂB
     */
    progress getToProgWhenProgWillChange() const;

    /**
     * ԂɔĐiXV .
     * ԃJE^[̑ŁȀR[ĂB
     */
    virtual void update();

    virtual ~GgafProgress();
};

}
#endif /*GGAFCORE_GGAFPROGRESS_H_*/
