#include "jp/ggaf/core/actor/ex/GgafTreeFormation.h"

#include "jp/ggaf/core/actor/GgafSceneDirector.h"
#include "jp/ggaf/core/actor/GgafGroupHead.h"
#include "jp/ggaf/core/util/GgafStatus.h"

using namespace GgafCore;

GgafTreeFormation::GgafTreeFormation(const char* prm_name, frame prm_offset_frames_end) :
        GgafFormation(prm_name, prm_offset_frames_end)
{
    _class_name = "GgafTreeFormation";
    _pIte = nullptr;
    _can_call_up = true;
    _is_addmember_experienced = false;
}

void GgafTreeFormation::addFormationMember(GgafActor* prm_pSub) {
#ifdef MY_DEBUG
    if (wasDeclaredEnd()) {
        //I҂̂
        _TRACE_("x GgafTreeFormation::addSubLast("<<NODE_INFO_P(prm_pSub)<<") Ɏɂ䂭߂FormationłBTuɒǉ邱Ƃ͂̂ł͂ȂĤHBthis="<<NODE_INFO);
    }
#endif
    _num_formation_member++;
    if (_pSubFirst == nullptr) {
        //cɎʂ𐳂`邽߂ɁAǉ̎ʂAg̎ʂɏ㏑iGgafTreeFormationj
        actorkind kind = prm_pSub->getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND);
        getStatus()->set(STAT_DEFAULT_ACTOR_KIND, kind);
        //o[ GgafTreeFormation AaddSubGroup  addFormationMember sꍇA
        //܂o[ GgafTreeFormation AaddSubGroup ́A=0Ȃ̂ŁA쐬ꂽc̎ʂ0ō쐬Ă܂B
        //̌addFormationMembersĂA0ɑĂ܂Ƃ肪LB
        //ŁAc̎0ꍇAʂ𖳗XVB
        GgafGroupHead* myGroupHead = getMyGroupHead(); //c
        if (myGroupHead) {
            //ɏĂ܂ĂBiV[ɑĂj
            if (myGroupHead->_kind == kind) {
                //Aʂɐ̂ŖȂB
            } else {
                //ʂςĂB̒c̎ʂ𖳗ύXł邩H
                if (myGroupHead->_kind == 0) {
                    //0̂Ŗc̎ʂĂ܂B
                    _TRACE_("GgafTreeFormation::addFormationMember "<<NODE_INFO<<" ́Aςݒc̎(g̎)"<<myGroupHead->_kind<<"ƁAǉo[̎"<<kind<<"قȂ܂B"<<
                            "KɂAcʂ 0 ̂ŁAXV܂Bc="<<myGroupHead->_kind<<"  Vc="<<kind<<"");
                    myGroupHead->setKind(kind);
                } else {
                    _TRACE_("GgafTreeFormation::addFormationMember "<<NODE_INFO<<" ́Aςݒc̎(g̎)"<<myGroupHead->_kind<<"ƁAǉo[̎"<<kind<<"قȂ܂B");
                    _TRACE_("ςݒcz̏Ԃ͈ȉł");
                    myGroupHead->dump();
                    throwGgafCriticalException(
                            "GgafTreeFormation::addFormationMember "<<NODE_INFO<<" ́Aςݒc̎(g̎)"<<myGroupHead->_kind<<"ƁAǉo[̎"<<kind<<"قȂ܂B");
                }
            }
        } else {
            //cȂV[ɂ͖Ȃ̂ŁA
            //V[ɏɎg̎ʂŒc쐬̂ł悵B
        }
    } else {
#ifdef MY_DEBUG
        if (getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND) != prm_pSub->getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND)) {
            throwGgafCriticalException("GgafTreeFormation::addSubLast قȂʂ̃AN^[o^悤ƂĂ܂B \n"<<
                                       "z="<<getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND)<<"[_pSubFirst="<<_pSubFirst->getName()<<"] \n"<<
                                       "="<<prm_pSub->getStatus()->getUint(STAT_DEFAULT_ACTOR_KIND)<<"["<<prm_pSub->getName()<<"]");
        }
#endif
    }
    prm_pSub->_pFormation = this; //o[փtH[[Vݒ
    GgafFormation::addSubLast(prm_pSub);
    prm_pSub->inactivate(); //tH[[VȂ̂callUp܂Ŕ񊈓B
    _is_addmember_experienced = true;
}

void GgafTreeFormation::processFinal() {
    if (_was_all_sayonara || wasDeclaredEnd() || willInactivateAfter()) {
        //I҂̂
    } else {
        if (getSubFirst() == nullptr) {  //zȂꍇAtH[[V͂ȂƂɂȂAgIȁH
            if (_is_addmember_experienced) {
                onSayonaraAll(); //R[obN
                sayonara(_offset_frames_end);
                _was_all_sayonara = true;
            } else {
                //A܂addFormationMember()oĂȂ̂ŏIȂB
                //TreeFormationƂĂ̖ʂ܂ł͎˂ȂB
            }
        }
    }
}

void GgafTreeFormation::onEnd() {
    GgafFormation::onEnd();
}

GgafActor* GgafTreeFormation::callUpMember() {
    if (wasDeclaredEnd() || willInactivateAfter()) {
        //I҂̂
        return nullptr;
    }
    if (_can_call_up) {
        if (_pIte) {
            _pIte = _pIte->getNext();
            if (_pIte == getSubFirst()) { //P
                _can_call_up = false;
                return nullptr;
            }
        } else {
            _pIte = getSubFirst(); //̓Tu擪
        }
        _pIte->activate();
        if (_pIte->getNext() == getSubFirst()) {
            //Ō̂P
            _can_call_up = false;
        }
        return _pIte;
    } else {
        return nullptr;
    }
}

GgafTreeFormation::~GgafTreeFormation() {

}
