#include "jp/ggaf/core/util/GgafLinearOctree.h"

#include "jp/ggaf/core/exception/GgafCriticalException.h"
#include "jp/ggaf/core/util/GgafLinearOctreeOctant.h"
#include "jp/ggaf/core/util/GgafLinearOctreeElem.h"
#include "jp/ggaf/core/util/GgafUtil.h"


using namespace GgafCore;


GgafLinearOctree::GgafLinearOctree(int prm_level) : GgafObject() {
    _top_space_level = prm_level;
    _top_level_dx = 0;
    _top_level_dy = 0;
    _top_level_dz = 0;
    _r_top_level_dx = 0.0;
    _r_top_level_dy = 0.0;
    _r_top_level_dz = 0.0;
    _root_x1 = 0;
    _root_y1 = 0;
    _root_z1 = 0;
    _root_x2 = 0;
    _root_y2 = 0;
    _root_z2 = 0;
    //ׂ쐬
    _pa_8pow = NEW uint32_t[(prm_level+1)+1];
    _pa_8pow[0] = 1;
    for(int i = 1; i < (prm_level+1)+1; i++) {
        _pa_8pow[i] = _pa_8pow[i-1] * 8;
        //_TRACE_("_pa_8pow["<<i<<"]="<<_pa_8pow[i]);
    }
    //`ؔz쐬
    _num_space = (int)((_pa_8pow[_top_space_level+1] -1) / 7); //Ԑ
    _TRACE_("GgafLinearOctree::GgafLinearOctree("<<prm_level<<") `؋Ԕzvf _num_space="<<_num_space);
    _paOctant = NEW GgafLinearOctreeOctant[_num_space];
    for (uint32_t i = 0; i < _num_space; i++) {
        _paOctant[i]._my_index = i;
    }
    _pRegElemFirst = nullptr;
}

void GgafLinearOctree::setRootOctant(int x1, int y1, int z1, int x2, int y2, int z2) {
    _root_x1 = x1;
    _root_y1 = y1;
    _root_z1 = z1;
    _root_x2 = x2;
    _root_y2 = y2;
    _root_z2 = z2;
    _top_level_dx = ((_root_x2-_root_x1) / ((float)(1<<_top_space_level))) + 1;
    _top_level_dy = ((_root_y2-_root_y1) / ((float)(1<<_top_space_level))) + 1;
    _top_level_dz = ((_root_z2-_root_z1) / ((float)(1<<_top_space_level))) + 1; //+1͋ԐI[o[Ȃ悤ɗ]T邽
    _r_top_level_dx = 1.0 / _top_level_dx;
    _r_top_level_dy = 1.0 / _top_level_dy;
    _r_top_level_dz = 1.0 / _top_level_dz;

    _TRACE_("GgafLinearOctree::setRootOctant ؃[gx(level=0)̋Ԃ̍L=" << _root_x2-_root_x1 << "x" << _root_y2-_root_y1 << "x" << _root_z2-_root_z1);
    _TRACE_("GgafLinearOctree::setRootOctant ؖ[x(level="<<_top_space_level<<")̋Ԃ̍L=" << _top_level_dx << "x" << _top_level_dy << "x" << _top_level_dz);
}

void GgafLinearOctree::registerElem(GgafLinearOctreeElem* const prm_pElem,
                                    int tx1, int ty1, int tz1,
                                    int tx2, int ty2, int tz2) {

    //͂ݏoꍇ͕␳
    tx1 = tx1<=_root_x1 ? _root_x1 : tx1;
    tx2 = tx2>=_root_x2 ? _root_x2 : tx2;
    ty1 = ty1<=_root_y1 ? _root_y1 : ty1;
    ty2 = ty2>=_root_y2 ? _root_y2 : ty2;
    tz1 = tz1<=_root_z1 ? _root_z1 : tz1;
    tz2 = tz2>=_root_z2 ? _root_z2 : tz2;

    //W̑召ԂꍇA܂Level0OALevel0Ŝ傫ꍇ͖
    if (tx1 >= tx2 || ty1 >= ty2 || tz1 >= tz2) {
        return; //ԊO͓o^Ȃ
    }

    //tx1,ty1,tz1,tx2,ty2,tz2 AԔԍ ߂遄
    //BOẌWԔzvfԍi`ؔz̗vfԍjZo .
    //܂ABOX̏ Level ƁA̋Level̃[gʂԔԍ
    //[gʂԔԍvZĔz index ߂B


    //BOX̍OXYZW_Ԃ́Aő僌xԂŃ[gʂԔԍ͉Ԃ擾
    const uint32_t minnum_in_toplevel = GgafLinearOctree::getMortonOrderNumFromXYZindex(
                                            (uint32_t)((tx1 - _root_x1) * _r_top_level_dx),
                                            (uint32_t)((ty1 - _root_y1) * _r_top_level_dy),
                                            (uint32_t)((tz1 - _root_z1) * _r_top_level_dz)
                                        );

    //BOX̉E㉜XYZW_Ԃ́Aő僌xԂŃ[gʂԔԍ͉Ԃ擾
    const uint32_t maxnum_in_toplevel = GgafLinearOctree::getMortonOrderNumFromXYZindex(
                                            (uint32_t)((tx2 - _root_x1) * _r_top_level_dx),
                                            (uint32_t)((ty2 - _root_y1) * _r_top_level_dy),
                                            (uint32_t)((tz2 - _root_z1) * _r_top_level_dz)
                                        );                 //_root_x2,_root_y2,_root_z2 ƊԈႦĂ܂B


    //BOX́Aǂ̃x̋ԂɏĂ̂擾
    const uint32_t differ_bit_pos = maxnum_in_toplevel ^ minnum_in_toplevel;
    uint32_t shift_num = 0;
    const uint32_t lv = (uint32_t)_top_space_level;
    for(uint32_t i = 0; i < lv; i++) {
        if (((differ_bit_pos>>(i*3)) & 0x7) != 0 ) {
            shift_num = i+1;
        }
    }
    //xordiffer_bit_pos  E3rbgVtgA}XN &B111(&H7) ANDA&B000 
    //ȂȂĂꍇAshift_numɒlB
    //܂肱 differ_bit_pos  ܂ Rrbgɋ؂A3rbgHĂӏ̂A
    //łʒuׂĂB
    //HႤ3rbg̈ʒúÃx̃g[ʒuHĂ邱ƂӖB
    //čł3rbgHĂӏ(Vtg񐔁shift_num)菊ԃx킩
    //őԕLevel = 5ƂāAO6001ԁAE㉜6041ԂɏĂBOXɂ
    //
    //exԂ̃[gʒu lv0 lv1 lv2 lv3 lv4 lv5
    //     6001 = 00 000 000 000 000 000 001 011 101 110 001
    // XOR)6041 = 00 000 000 000 000 000 001 011 110 011 001
    // -----------------------------------------------------
    //      232 = 00 000 000 000 000 000 000 000 011 101 000
    //
    //                                                   111
    //                                               111
    //                                           111
    //                                       111
    //  AND)                             111     <--- ܂ōsāAł3rbgHĂӏ3ڂƂ
    // ------------------------------------------------------
    //                                   000 000 011 101 000
    //                                    o   o   x   x   o      if (differ_bit_pos>>(i*3)) & 0x7 != 0 ) ̔
    //                                    5   4   3   2   1   0   shift_num(Vtg)
    //
    //   LA6001Ԃ6041Ԃ͋ԃx1Ax2 ܂ł͓ԃxɑĂA
    //   ԃx3烂[gʒuقȂĂ܂ƂBāA
    //   uԃxvLv2ԂłƊmłB𒲂ׂ邽߂
    //   XOR0ȊOɂȂō̃Vtg  shift_num = 3 ߂B
    //   ߂邽߂ɂ́AE3rbgVtg 0x7  AND𒲂ׂ邱ƂJԂKvƂƂB
    //   v shift_num ̃Vtg񐔂𒲂ׂ΁AԃxI

    //XORʂ
    // 000 000 000 000 000 000 000 111 ̏ꍇȂ shift_num=1
    //
    //őԕLevel=5 ̏ꍇ͏ԃx4(=ԃx5ŐHႤ)
    //őԕLevel=8 ̏ꍇ͏ԃx7(=ԃx8ŐHႤ)

    // 000 000 000 111 110 000 101 111 Ȃǂ̏ꍇ shift_num=5
    //
    //őԕLevel=5 ̏ꍇ͏ԃx0 ܂胋[gԃx
    //őԕLevel=8 ̏ꍇ͏ԃx4

    //܂Ƃ߂
    //őԕLevel = 5 ̏ꍇ
    //shift_num   = 0 1 2 3 4 5
    //Level = 5 4 3 2 1 0
    //őԕLevel=8 ̏ꍇ
    //shift_num   = 0 1 2 3 4 5 6 7 8
    //Level = 8 7 6 5 4 3 2 1 0

    //Ԃ̃[g̒ʂԔԍ߂
    const uint32_t morton_order_space_num = minnum_in_toplevel>>(shift_num*3);
    //s̉ʂ̃rbg3rbgPʂŏÃ[gԍ߂
    //
    // minnum_in_toplevel>>(shift_num*3); ɂāA
    // minnum_in_toplevel=6001 ł 6041łǂł悭
    //        lv0 lv1 lv2 lv3 lv4 lv5          lv0 lv1 lv2
    // 6001 = 000 001 011 101 110 001   -->    000 001 011 = 11
    // 6041 = 000 001 011 110 011 001   -->    000 001 011 = 11
    //                    ^^^ ^^^ ^^^
    //                  (shift_num*3 rbg)
    //
    // ̂悤ɕs̃rbgEփVtgĂ
    // ŁAO6001ԁAE㉜6041ԂƂBOX́ALv2̏ꍇ́A[gʂԔԍ11ԂłƂ킩B
    // Ƃ͂zIndexɕϊ̂

    //(Vtg)Ƃ̋Ԃ̃[gʂԔԍ`ؔz̗vfԍ߂
    const uint32_t index = morton_order_space_num + (_pa_8pow[_top_space_level-shift_num]-1)/7;
    //(_pa_8pow[_top_space_level-shift_num]-1)/7;
    //́A`؋ԔźAԃx̍ŏ̋Ԃ̗vfԍ킷B
    //䐔̘a
    // r^k = r^0 + r^1 + r^2 + ... + r^n
    // r^k = (1 - r^(n+1)) / (1 - r)
    //
    //`8؂̔zvf̋ԃx܂ł̍v֐ r=8 
    //(1 - 8^(n+1)) / (1-8)  =  (1-8^(n+1)) / -7  =  (8^(n+1) - 1) / 7 ƂȂ
    //ŁAԂ̍ŏ̋ԗvf߂邽߁A n = ԃx-1 ̌vZlieԃx܂ł̗vfj́A
    //̗̎vfԃx̐擪̗vfɂȂ͂IBƂߕB
    //čŌɒl +1 ̂قlł邪Az0Ԃn܂邽߁A+1 -1 = 0 ŁAȗĂ܂B
    //̗ł shift_num = 3 ŁAőԕLevel(_top_space_level) = 5 ł̂
    // 5 - 3 = 2 ŏԃx 2
    // n = 2 - 1 = 1   (8^(1+1) - 1) / 7 = 9 
    //Ԃ̃x2e̋ԃxłAԃx1܂ł̔zvfv9Ƃ킩B
    //]̏ԃx 2̍ŏ̋Ԃ͔z 9+1 10Ԗڂn܂B
    //z10ԖڂƂ́Azvfԍ-19ɂȂB
    //+1  -1 ̂ŌǁAԃxx̍ŏ̔zvfԍ  (8^x - 1) / 7 ƂȂ


#ifdef MY_DEBUG
    if (index > _num_space-1) {

        _TRACE_(
           "GgafLinearOctree::registerElem() ԃI[o[ !. \n"<<
           "Root=("<<_root_x1<<","<<_root_y1<<","<<_root_z1<<")-("<<_root_x2<<","<<_root_y2<<","<<_root_z2<<")\n"<<
           "Elem=("<<tx1<<","<<ty1<<","<<tz1<<")-("<<tx2<<","<<ty2<<","<<tz2<<")\n"<<
           "_top_level_dx="<<_top_level_dx<<" _top_level_dy="<<_top_level_dy<<" _top_level_dz="<<_top_level_dz<<"\n"<<
           "minnum_in_toplevel="<<minnum_in_toplevel<<" maxnum_in_toplevel="<<maxnum_in_toplevel<<"\n"<<
           "differ_bit_pos="<<differ_bit_pos<<" shift_num="<<shift_num<<" morton_order_space_num="<<morton_order_space_num<<"\n"<<
           "index="<<index<<" _num_space="<<_num_space
        );
        _TRACE_("Min_x_index="<<((uint32_t)((tx1 - _root_x1) / _top_level_dx)));
        _TRACE_("Min_y_index="<<((uint32_t)((ty1 - _root_y1) / _top_level_dy)));
        _TRACE_("Min_z_index="<<((uint32_t)((tz1 - _root_z1) / _top_level_dz)));
        _TRACE_("Man_x_index="<<((uint32_t)((tx2 - _root_x1) / _top_level_dx)));
        _TRACE_("Man_y_index="<<((uint32_t)((ty2 - _root_y1) / _top_level_dy)));
        _TRACE_("Man_z_index="<<((uint32_t)((tz2 - _root_z1) / _top_level_dz)));
    }
#endif

    //o^ElemXgɒǉiŃNAׁj
    if (prm_pElem->_pOctant_current == nullptr) {
        if (_pRegElemFirst == nullptr) {
            prm_pElem->_pRegLinkNext = nullptr;
            _pRegElemFirst = prm_pElem;
        } else {
            prm_pElem->_pRegLinkNext = _pRegElemFirst;
            _pRegElemFirst = prm_pElem;
        }
    } else {
#ifdef MY_DEBUG
        throwGgafCriticalException("GgafLinearOctree::registerElem() o^悤Ƃvf́A̋ԂɏԂłB"<<
                                   "NAȂĂȂAQdo^Ă܂BԃCfbNX="<<(prm_pElem->_pOctant_current->_my_index)<<"  vfΏۃIuWFNg="<<(prm_pElem->_pObject));
#endif
    }
    //vf`؋Ԃɓo^()
    prm_pElem->belongTo(&(_paOctant[index]));
}

void GgafLinearOctree::clearElem() {
    GgafLinearOctreeElem* pElem = _pRegElemFirst;
    while (pElem) {
        pElem->clear();
        pElem = pElem->_pRegLinkNext;
    }
    _pRegElemFirst = nullptr;
}

GgafLinearOctree::~GgafLinearOctree() {
    GGAF_DELETEARR(_paOctant);
    GGAF_DELETEARR(_pa_8pow);
}


void GgafLinearOctree::putTree() {
    char aChar_strbit[33];
    int lv0_order_num = 0;
    int lv1_order_num = 0;
    int lv2_order_num = 0;
    int lv3_order_num = 0;
    int lv4_order_num = 0;
    int lv5_order_num = 0;
    int lv6_order_num = 0;
    int lv7_order_num = 0;
    int lv8_order_num = 0;

    int lv0_order_pos = 0;

    int LV0 = 0;

    if (_paOctant[0]._kindinfobit == 0) {
        _TRACE_("8؂ɉI");
    } else {
        UTIL::strbin(_paOctant[LV0]._kindinfobit, aChar_strbit);
        _TRACE_N_("LV0."<<lv0_order_num<<"(POS:"<<lv0_order_pos<<")["<<LV0<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
        _paOctant[LV0].dump();
        _TRACE_N_("\n");
    }

    uint32_t index_lv1_begin = LV0*8 + 1;
    if (index_lv1_begin > _num_space-1) { return; }

    for (uint32_t LV1 = index_lv1_begin, lv1_order_pos = 0; LV1 < index_lv1_begin+8; LV1++, lv1_order_num++, lv1_order_pos++) {
        if (_paOctant[LV1]._kindinfobit == 0) { continue; }
        UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
        _TRACE_N_("  LV1-"<<lv1_order_num<<"(POS:"<<lv1_order_pos<<")["<<LV1<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
        _paOctant[LV1].dump();
        _TRACE_N_("\n");
        ////
        uint32_t index_lv2_begin = LV1*8 + 1;
        if (index_lv2_begin > _num_space-1) { continue; } //̊Kwɂ邩Lv`FbN

        for (uint32_t LV2 = index_lv2_begin, lv2_order_pos = 0; LV2 < index_lv2_begin+8; LV2++, lv2_order_num++, lv2_order_pos++) {
            if (_paOctant[LV2]._kindinfobit == 0) { continue; }  //̂ŉʕ\΂
            UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
            _TRACE_N_("    LV2-"<<lv2_order_num<<"(POS:"<<lv2_order_pos<<")["<<LV2<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
            _paOctant[LV2].dump();
            _TRACE_N_("\n");
            ///
            uint32_t index_lv3_begin = LV2*8 + 1;
            if (index_lv3_begin > _num_space-1) { continue; } //̊Kwɂ邩Lv`FbN
            for (uint32_t LV3 = index_lv3_begin, lv3_order_pos = 0; LV3 < index_lv3_begin+8; LV3++, lv3_order_num++, lv3_order_pos++) {
                if (_paOctant[LV3]._kindinfobit == 0) { continue; }  //̂ŉʕ\΂
                UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
                _TRACE_N_("      LV3-"<<lv3_order_num<<"(POS:"<<lv3_order_pos<<")["<<LV3<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
                _paOctant[LV3].dump();
                _TRACE_N_("\n");
                ///
                uint32_t index_lv4_begin = LV3*8 + 1;
                if (index_lv4_begin > _num_space-1) { continue; } //̊Kwɂ邩Lv`FbN
                for (uint32_t LV4 = index_lv4_begin, lv4_order_pos = 0; LV4 < index_lv4_begin+8; LV4++, lv4_order_num++, lv4_order_pos++) {
                    if (_paOctant[LV4]._kindinfobit == 0) { continue; }  //̂ŉʕ\΂
                    UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
                    _TRACE_N_("        LV4-"<<lv4_order_num<<"(POS:"<<lv4_order_pos<<")["<<LV4<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
                    _paOctant[LV4].dump();
                    _TRACE_N_("\n");
                    ///
                    uint32_t index_lv5_begin = LV4*8 + 1;
                    if (index_lv5_begin > _num_space-1) { continue; } //̊Kwɂ邩Lv`FbN
                    for (uint32_t LV5 = index_lv5_begin, lv5_order_pos = 0; LV5 < index_lv5_begin+8; LV5++, lv5_order_num++, lv5_order_pos++) {
                        if (_paOctant[LV5]._kindinfobit == 0) { continue; }  //̂ŉʕ\΂
                        UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
                        _TRACE_N_("          LV5-"<<lv5_order_num<<"(POS:"<<lv5_order_pos<<")["<<LV5<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
                        _paOctant[LV5].dump();
                        _TRACE_N_("\n");
                        ///
                        uint32_t index_lv6_begin = LV5*8 + 1;
                        if (index_lv6_begin > _num_space-1) { continue; } //̊Kwɂ邩Lv`FbN
                        for (uint32_t LV6 = index_lv6_begin, lv6_order_pos = 0; LV6 < index_lv6_begin+8; LV6++, lv6_order_num++, lv6_order_pos++) {
                            if (_paOctant[LV6]._kindinfobit == 0) { continue; }  //̂ŉʕ\΂
                            UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
                            _TRACE_N_("            LV6-"<<lv6_order_num<<"(POS:"<<lv6_order_pos<<")["<<LV6<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
                            _paOctant[LV6].dump();
                            _TRACE_N_("\n");
                            ///
                            uint32_t index_lv7_begin = LV6*8 + 1;
                            if (index_lv7_begin > _num_space-1) { continue; } //̊Kwɂ邩Lv`FbN
                            for (uint32_t LV7 = index_lv7_begin, lv7_order_pos = 0; LV7 < index_lv7_begin+8; LV7++, lv7_order_num++, lv7_order_pos++) {
                                if (_paOctant[LV7]._kindinfobit == 0) { continue; }  //̂ŉʕ\΂
                                UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
                                _TRACE_N_("              LV7-"<<lv7_order_num<<"(POS:"<<lv7_order_pos<<")["<<LV7<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
                                _paOctant[LV7].dump();
                                _TRACE_N_("\n");
                                ///
                                uint32_t index_lv8_begin = LV7*8 + 1;
                                if (index_lv8_begin > _num_space-1) { continue; } //̊Kwɂ邩Lv`FbN
                                for (uint32_t LV8 = index_lv8_begin, lv8_order_pos = 0; LV8 < index_lv8_begin+8; LV8++, lv8_order_num++, lv8_order_pos++) {
                                    if (_paOctant[LV8]._kindinfobit == 0) { continue; }  //̂ŉʕ\΂
                                    UTIL::strbin(_paOctant[LV1]._kindinfobit, aChar_strbit);
                                    _TRACE_N_("                LV8-"<<lv8_order_num<<"(POS:"<<lv8_order_pos<<")["<<LV8<<"]="<<aChar_strbit<<" /GgafLinearOctreeElem->");
                                    _paOctant[LV8].dump();
                                    _TRACE_N_("\n");
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}


