#include "stdafx.h"
#include "EnemyEmiliaFragment3.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyEmiliaFragment3::EnemyEmiliaFragment3(const char* prm_name) :
        EnemyEmiliaBase(prm_name, "Emilia", STATUS(EnemyEmiliaFragment3)) {
}

void EnemyEmiliaFragment3::onCreateModel() {
}

void EnemyEmiliaFragment3::initialize() {
    setHitAble(true);
    setScaleR(0.04);
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliSphere(0, PX_C(20));
    _pKurokoA->setFaceAngVelo(D_ANG(0), D_ANG(10), D_ANG(0));
}

void EnemyEmiliaFragment3::onActive() {
    //Xe[^XZbg
    UTIL::resetEnemyEmiliaFragment3Status(_pStatus);
    setHitAble(true);
}


void EnemyEmiliaFragment3::onInactive() {
    sayonara();
}
void EnemyEmiliaFragment3::processStaminaEnd(GgafDxGeometricActor* prm_pOther) {
    //@Ɍďł̏ꍇA
    if (prm_pOther->getKind() & KIND_MY) {
        //ACeo
        UTIL::activateItemOf(this);
    }
}

EnemyEmiliaFragment3::~EnemyEmiliaFragment3() {
}
