#include "stdafx.h"
#include "EnemyErmione.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxMorpher.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAlphaFader.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Ermione/EnemyErmioneArmWeak.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Ermione/EnemyErmioneArmHead.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Ermione/EnemyErmioneArmBody.h"


using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyErmione::EnemyErmione(const char* prm_name) :
        DefaultMorphMeshActor(prm_name, "1/Ermione", STATUS(EnemyErmione)) {
    _class_name = "EnemyErmione";

    num_arm_ = 6; //r̐
    num_arm_part_ = 7;  //r̐ߐi3ȏj
    angle pos_rz[] = {D_ANG(0),   D_ANG(90),   D_ANG(180),  D_ANG(270), D_ANG(0) , D_ANG(0)  }; //₷ꏊ
    angle pos_ry[] = {D_ANG(0),   D_ANG(0),    D_ANG(0)  ,  D_ANG(0)  , D_ANG(90), D_ANG(270) };
    static coord R = PX_C(100);     //{Ermione̔a
    static coord arm_R = PX_C(45);  //̘r̊֐߂P̔a

    //̂悤ȃc[\(rR{̏ꍇ)
    //Ermione
    // 
    //GroupHead()
    // 
    //ArmPart({)     ArmPart({)     ArmPart({)
    //                                      
    //ArmPart              ArmPart             ArmPart
    //                                      
    //ArmPart(_)        ArmPart(_)       ArmPart(_)
    //                                      
    //ArmPart              ArmPart             ArmPart
    //                                      
    //ArmPart              ArmPart             ArmPart
    //                                      
    //ArmPart()          ArmPart()          ArmPart()

    paArm_ = NEW EnemyErmione::Arm[num_arm_];
    float vx, vy, vz;
    for (int arm = 0; arm < num_arm_; arm++) { //r̖{Ń[v
        paArm_[arm].pos_Rz_ = pos_rz[arm];
        paArm_[arm].pos_Ry_ = pos_ry[arm];
        UTIL::convRzRyToVector(paArm_[arm].pos_Rz_, paArm_[arm].pos_Ry_,
                               vx, vy, vz); //r̃xNg
        paArm_[arm].papArmPart_ = NEW EnemyErmioneArm*[num_arm_part_];

        for (int i = 0; i < num_arm_part_; i++) { //r̓(֐)
            if (i == (num_arm_part_-1)/2) {
                //r̐߂̎_(r̐ߐ̔Ɏ_߂쐬)
                paArm_[arm].papArmPart_[i] = NEW EnemyErmioneArmWeak("ArmWeak");
            } else if (i == num_arm_part_-1) {
                //r̐߂̐擪
                paArm_[arm].papArmPart_[i] = NEW EnemyErmioneArmHead("ArmHead");
            } else {
                //ʂ̘r̐
                paArm_[arm].papArmPart_[i] = NEW EnemyErmioneArmBody("ArmBody");
            }
            if (i == 0) {
                //߂{̏ꍇ
                //֐ߌŒ肳
                paArm_[arm].papArmPart_[i]->config(0, 0);
                //gyƂFKݒ
                this->addSubGroupAsFk(
                        paArm_[arm].papArmPart_[i],
                        vx*R, vy*R, vz*R,
                        D0ANG, paArm_[arm].pos_Ry_, paArm_[arm].pos_Rz_);
            } else {
                //߂{ȊOꍇ
                //ɍsقǉ͈͂Ɖ]Xs[h傫iŁAFKȂ̂IKۂIj
                paArm_[arm].papArmPart_[i]->config(D_ANG(25+(i*2.5)), 20+(i*60));
                //O̘r̐߂yƂFKݒ
                paArm_[arm].papArmPart_[i-1]->addSubGroupAsFk(
                                               paArm_[arm].papArmPart_[i],
                                               arm_R, 0, 0,
                                               D0ANG, D0ANG, D0ANG);
            }
        }
    }

    _pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    _pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");
    useProgress(PROG_MOVE);
}

void EnemyErmione::onCreateModel() {
}

void EnemyErmione::initialize() {
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliSphere(0, 90000);
}

void EnemyErmione::onActive() {
    _pStatus->reset();
    _pMorpher->setWeight(0, 1.0);
    _pMorpher->setWeight(1, 0.0);

    _pProg->reset(PROG_INIT);
    setHitAble(false);
}

void EnemyErmione::processBehavior() {
    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));
    switch (_pProg->get()) {
        case PROG_INIT: {
            setHitAble(false);
            _pAFader->setAlpha(0);
            _pKurokoA->setMvVelo(0);
            UTIL::activateEntryEffectOf(this);
            _pProg->changeNext();
            break;
        }

        case PROG_ENTRY: {
            if (_pProg->getFrameInProgress() == 120) {
                _pAFader->fadeAcceStep(1.0, 0.000, 0.0001);
            }
            if (getAlpha() > 0.8) {
                setHitAble(true);
                throwEventLowerTree(EVENT_ERMIONE_ENTRY_DONE);
                _pProg->changeNext();
            }
            break;
        }

        case PROG_MOVE: {
            if (_pProg->isJustChanged()) {
                _pKurokoA->setMvVelo(1000);
//                _pKurokoA->setFaceAngVelo(20, 67, 99);
                _pKurokoA->turnFaceAngTwd(P_MYSHIP,
                                          1, 10,
                                          TURN_ANTICLOSE_TO, false);
                _pKurokoA->setMvAngTwd(P_MYSHIP);
            }
            break;
        }

        default:
            break;
    }
    _pAFader->behave();
    _pKurokoA->behave();
    _pMorpher->behave();
    _pSeTx->behave();
}

void EnemyErmione::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyErmione::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        _pSeTx->play3D(SE_EXPLOSION);
        throwEventLowerTree(EVENT_ERMIONE_SAYONARA);
    } else {
        //j
        _pSeTx->play3D(SE_DAMAGED);
    }
}

void EnemyErmione::onInactive() {
    //sayonara();
}

void EnemyErmione::addArm(angle prm_rz, angle prm_ry) {

}

EnemyErmione::~EnemyErmione() {
    GGAF_DELETEARR(paArm_);
}
