#ifndef GGAFLIB_DEFAULTSCENE_H_
#define GGAFLIB_DEFAULTSCENE_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dxcore/scene/GgafDxScene.h"

#include "jp/ggaf/lib/util/SceneProgress.h"

namespace GgafLib {

/**
 * V[̋ۃNX .
 * GgafDxCore::GgafDxScene pAۃV[łB
 * @version 1.00
 * @since 2007/12/06
 * @author Masatoshi Tsuge
 */
class DefaultScene : public GgafDxCore::GgafDxScene {

public:
    /** [r]V[Cxgp̃t[l̔z(uV[Creater.xlsv}N̐PGɑgݍ܂j */
    uint32_t* _paFrame_NextEvent;
    /** [r]V[̃Cxgi_paFrame_NextEvent̗vfj(uV[Creater.xlsv}N̐PGɑgݍ܂j */
    int _event_num;
    /** V[̌݃Cxg(uV[Creater.xlsv}N̐PGɑgݍ܂j */
    int _cnt_event;

    /** XN[x */
    velo _scroll_speed;
    /** [r/w]XN[֐ւ̃|C^ */
    void (*_pFuncScrolling)(GgafCore::GgafObject*, void*, void*);

public:
    DefaultScene(const char* prm_name);

    void useProgress(int prm_num = 10) override;

    SceneProgress* getProgress() override;

    virtual void initialize() override {
    }

    /**
     * V[ZbgAėp\ɂ .
     * ʂŎĂB
     */
    virtual void onReset() override {
    }

    virtual void processBehavior() override {
    }
    /**
     * XN[̒ǉ .
     */
    virtual void processSettlementBehavior() override;

    virtual void processJudgement() override {
    }

    virtual void processDraw() override {
    }

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }


public:

    /**
     * XN[֐ݒ肷B
     * ݒ肳ꂽXN[֐zc[V[̑SAN^[ɎssB<BR>
     * Pɂ́AΏۃAN^[AQɂ́AXN[Xs[h(_scroll_speedւ̃|C^)nB<BR>
     * W DefaultScene::scroll_x(GgafObject*, void*, void*) pӂĂ̂ŁAw\A<BR>
     * Cӂ̃[U[`XN[֐ɐ؂ւłB<BR>
     * @param prm_pFuncScrolling (GgafObject*, void*, void*) ƂȂ֐|C^
     */
    void setScrollingFunction(void (*prm_pFuncScrolling)(GgafCore::GgafObject*, void*, void*)) {
        _pFuncScrolling = prm_pFuncScrolling;
    }

    void setScrollSpeed(velo prm_scroll_speed) {
        _scroll_speed = prm_scroll_speed;
    }

    velo getScrollSpeed() {
        return _scroll_speed;
    }

    void addScrollSpeed(acce prm_acce) {
        _scroll_speed += prm_acce;
    }
    /**
     * ł߂̃XN[ĂV[TĎ擾B .
     * ͈͂ V[{eV[B
     * ֐|C^ _pFuncScrolling  nullptr łȂ΁AXN[ĂƔfB
     * @return ߂̃XN[ĂV[A nullptr
     */
    DefaultScene* getNearestScrollingScene();

    /**
     * ł߂ WalledScene TĎ擾B .
     * ͈͂ V[{eV[B
     * WalledScene X̕̕XN[Ă邱Ƃۏ؂ĂB
     * _pFuncScrolling  nullptr ł낤ƂȂ낤ƁA֌W͂ȂAWalledScene Ȃ΂ԂB
     * @return ߂WalledScene
     */
    WalledScene* getNearestWalledScene();

    virtual ~DefaultScene();
};

}
#endif /*GGAFLIB_DEFAULTSCENE_H_*/
