#ifndef GGAFDXCORE_GGAFDXPOINTSPRITEACTOR_H_
#define GGAFDXCORE_GGAFDXPOINTSPRITEACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"

namespace GgafDxCore {

/**
 * |CgXvCgAN^[.
 * GgafDxDrawableActor pA|CgXvCg\@\AN^[<BR>
 * ̗悤ȃ|CgXvCg\@\B
 * ipxʏpxƂقڈvj
 * <pre>
 * ၄
 *
 * yeNX`z
 * Pattern.png
 *
 * <---256px--->
 *
 * +--+--+--+--+    ^
 * | 0| 1| 3| 4|    |
 * +--+--+--+--+    |
 * | 5| 6| 7| 8|    |
 * +--+--+--+--+    256px (`ł邱ƁI
 * | 9|10|11|12|    |      sNZ͎RBł256*256px)
 * +--+--+--+--+    |
 * |13|14|15|16|    |
 * +--+--+--+--+    v
 *
 *
 * yǂݍXt@Cz
 * |CgXvCgp̒`Xt@C(gqpsprx)ǂݍށB
 *
 * -----------------------------------------
 * xof 0303txt 0032
 * PointSpriteDef Test {
 *   32.0;                                  // |Cgɕ\XvCĝPӂpxBeNX`̂Pp^[̂Pӂ̃eNZł͂ȂB
 *                                          //   (32pxʕ\ɂƂӖ)
 *   "Pattern.png";                         // eNX`
 *   4;                                     // eNX`c̕B1́uvA2́ucQ 4p^[Aj[Vv
 *                                          //   ł́AL̂悤ȃeNX`Ȃ̂ŁA4w肵ďcS4*416p^[ƂȂB
 *                                          //   āÂƂeNX`̂Pp^[̂Pӂpx256/464pxƌ܂B
 *   3;                                     // _iXvCgj͂R̒_wBȉɃf[^ő
 *                                          //   _WAIuWFNgJ[Ap^[ԍA{̃f[^
 *                                          //   SĈvKvB
 *   -20.000000;-21.000000;-22.000000;,     // |CgXvCg_XYZWBDirectX̍WŎwB
 *   3.000000;2.000000;1.000000;,           //   f[^͒_(̏ꍇ3) Ɉv邱
 *   11.000000;12.000000;13.000000;;
 *
 *   1.000000;0.100000;0.100000;1.000000;,  // e|CgXvCgRGBAJ[ieNX`ƍj
 *   0.100000;1.000000;0.100000;1.000000;,  //   f[^͒_(̏ꍇ3) Ɉv邱
 *   0.100000;0.100000;1.000000;1.000000;;
 *
 *   0,                                     // e|CgXvCg̏Aj[Vp^[ԍItZbg
 *   5,                                     //   f[^͒_(̏ꍇ3) Ɉv邱
 *   15;
 *
 *   1.0,                                   // e|CgXvCg̏XP[{
 *   2.0,                                   //   f[^͒_(̏ꍇ3) Ɉv邱
 *   1.0;
 * }
 * -----------------------------------
 *
 *
 * yLXt@C̏\ʃC[Wz
 * WnAʒS (0,0,0) B
 * オX̐AEY̐AZ̐
 *
 * +-----------------------------------------------------------------+
 * |                                                                 |
 * |                                                                 |
 * |                                                                 |
 * |                                     B                          |
 * |                                      ++                         |
 * |                                      ++                         |
 * |                           A +----+                             |
 * |                              | 5  |                             |
 * |                              |    |                             |
 * |                              +----+                             |
 * |                                                                 |
 * |                   @                                            |
 * |                      +----+                                     |
 * |                      | 0  |                                     |
 * |                      |    |                                     |
 * |                      +----+                                     |
 * |                                                                 |
 * +-----------------------------------------------------------------+
 *
 * @ DirectX̍W(-20.000000,-21.000000,-22.000000)
 *    \Aj[Vp^[ԍO
 *    Ԃۂ\
 *    -220px̋OɂȂ̂ŁAg傳ĕ\B
 *    OAɂgk̓[hϊɃJƂ̋Ȃǂ玩vZB
 *    ̃bVIuWFNgƂ̗͉ʒSt߂ňvB
 *    AAPɊgkĂ邽߉ʂ̒[ɍsقǍoB
 *
 * A DirectX̍W(3.000000,2.000000,1.000000);
 *    \Aj[Vp^[ԍT
 *    ʏ (30px,20px)ŗ΂ۂ\B
 *    iuvƂ\̓[hϊ̂ŃY邽߁j
 *    ͂ɉ̂߁Aق̏̏ksB
 *    ZW 1.000000 (10px) 0 ɋ߂߁AقڃeNX`px̕ŌB
 *    10px̕ق̏kB
 *    XP[{2.0ƂĂ邽 (256/4)*2.0 = 128 
 *    128*128px10px̕ق̏kŉʏŌB
 *    s\Z=0̏ꍇAeNX`̃sNZ̑傫ɂقڈv悤ɃJĂB
 *    ̋JZƌĂԁB
 *    pxƂ́AJZꂽʒuɃJuĕ\ꍇ
 *    ʂɌIuWFNĝ̕ƂłB
 *    DirectXẂu1v͖10sNZɑ悤ɂȂĂB
 *
 * B DirectX̍W(11.000000, 12.000000, 13.000000)
 *    \Aj[Vp^[ԍPT
 *    ۂ\
 *    130px̋̂߁AksB
 *    Aj[Vp^[ԍPTԂł邪A
 *    AN^[̃WbNŁAAj[Vp^[Pi߂
 *    B̃Aj[Vp^[ԍ͂OԂɕςi[vj
 * </pre>
 * @version 1.00
 * @since 2010/02/26
 * @author Masatoshi Tsuge
 */
class GgafDxPointSpriteActor : public GgafDxDrawableActor {

public:
    /** [r]f */
    GgafDxPointSpriteModel* const _pPointSpriteModel;
    /** [r]GtFNg */
    GgafDxPointSpriteEffect* const _pPointSpriteEffect;
    /** [r]UVtbp[(ppAj) */
    GgafDxUvFlipper* const _pUvFlipper;

public:
    /**
     * RXgN^
     * @param prm_name f́ifobOOŕ\AȂłǂj
     * @param prm_model_id f`B ".psprx" Xt@CɂȂ邱ƁB
     * @param prm_effect_id GtFNg`B ".fx" ăGtFNgt@CɂȂ邱ƁB
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     */
    GgafDxPointSpriteActor(const char* prm_name,
                           const char* prm_model_id,
                           const char* prm_effect_id,
                           const char* prm_technique,
                           GgafCore::GgafStatus* prm_pStat,
                           GgafDxChecker* prm_pChecker );

    virtual void processDraw() override;

    /**
     * ݒ.
     * @param prm_alpha
     */
    virtual void setAlpha(float prm_alpha) override;

    /**
     * Z .
     * @param prm_alpha
     */
    virtual void addAlpha(float prm_alpha) override;

    inline GgafDxUvFlipper* getUvFlipper() {
        return _pUvFlipper;
    }

    virtual ~GgafDxPointSpriteActor(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXPOINTSPRITEACTOR_H_*/
