#ifndef GGAFDXCORE_GGAFDXSPRITESETACTOR_H_
#define GGAFDXCORE_GGAFDXSPRITESETACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"

namespace GgafDxCore {

/**
 * XvCgZbgAN^[.
 * GgafDxDrawableActor pA|SɃeNX`\t<BR>
 * [XvCg@\ǉA`ɍœKꂽAN^[łB<BR>
 * @version 1.00
 * @since 2009/07/14
 * @author Masatoshi Tsuge
 */
class GgafDxSpriteSetActor : public GgafDxDrawableActor {
private:
    void setMaterialColor(float r, float g, float b) override {
        throwGgafCriticalException("GgafDxSpriteSetActor::setMaterialColor ͎gpsłB(1)");
    }
    void setMaterialColor(GgafCore::GgafRgb* prm_rgb) override {
        throwGgafCriticalException("GgafDxSpriteSetActor::setMaterialColor ͎gpsłB(2)");
    }
    void resetMaterialColor() override {
        throwGgafCriticalException("GgafDxSpriteSetActor::resetMaterialColor ͎gpsłB");
    }

public:
    /** [r]f */
    GgafDxSpriteSetModel* const _pSpriteSetModel;
    /** [r]GtFNg */
    GgafDxSpriteSetEffect* const _pSpriteSetEffect;
    /** [r]UVtbp[(ppAj) */
    GgafDxUvFlipper* const _pUvFlipper;

    GgafDxAlign _align;
    GgafDxValign _valign;

public:
    /**
     * RXgN^ .
     * @param prm_name AN^[́ifobOOŕ\AȂłǂj
     * @param prm_model_id f`A ".x" Xt@CɂȂ邱ƁB
     * @param prm_effect_id GtFNg`B ".fx" ăGtFNgt@CɂȂ邱ƁB
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     * @return
     */
    GgafDxSpriteSetActor(const char* prm_name,
                         const char* prm_model_id,
                         const char* prm_effect_id,
                         const char* prm_technique,
                         GgafCore::GgafStatus* prm_pStat,
                         GgafDxChecker* prm_pChecker );

    virtual void processDraw() override;

    virtual ~GgafDxSpriteSetActor();

    virtual void setAlign(GgafDxAlign prm_align, GgafDxValign prm_valign);
    virtual void setAlign(GgafDxAlign prm_align);
    virtual void setValign(GgafDxValign prm_valign);

    inline GgafDxUvFlipper* getUvFlipper() {
        return _pUvFlipper;
    }
};

}
#endif /*GGAFDXCORE_GGAFDXSPRITESETACTOR_H_*/
