#include "jp/ggaf/dxcore/util/GgafDxInput.h"

#include "jp/ggaf/dxcore/GgafDxGod.h"

using namespace GgafCore;
using namespace GgafDxCore;

//const int GgafDxInput::BUFFER_SIZE = 256;
LPDIRECTINPUT8 GgafDxInput::_pIDirectInput8 = nullptr;
LPDIRECTINPUTDEVICE8 GgafDxInput::_pKeyboardInputDevice = nullptr;
LPDIRECTINPUTDEVICE8 GgafDxInput::_pJoystickInputDevice = nullptr;
LPDIRECTINPUTDEVICE8 GgafDxInput::_pMouseInputDevice  = nullptr;
DIMOUSESTATE2 GgafDxInput::_mouse_state[2];
int  GgafDxInput::_flip_ms = 0;

char GgafDxInput::_keyboard_state[2][256];
int GgafDxInput::_flip_ks = 0;
DIDEVCAPS GgafDxInput::_devcap;
DIJOYSTATE GgafDxInput::_joy_state[2];
int GgafDxInput::_flip_js = 0;


HRESULT GgafDxInput::init() {
    HRESULT hr;
    // DirectInput ̍쐬
    hr = DirectInput8Create(GgafDxGod::_hInstance, DIRECTINPUT_VERSION, IID_IDirectInput8,
                            (LPVOID*)&_pIDirectInput8, nullptr);
    if (hr != D3D_OK) {
        MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() ȂDirectInput8̍쐬Ɏs܂B",
                   "ERROR", MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
        return hr;
    }

    // }EXfoCX̍쐬
    hr = _pIDirectInput8->CreateDevice(GUID_SysMouse, &_pMouseInputDevice, nullptr);
    if (hr != D3D_OK) {
        MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() }EXfoCX쐬Ɏs܂",
                "ERROR", MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
        return hr;
    }
    // }EX擾f[^tH[}bg̐ݒ
    hr = _pMouseInputDevice->SetDataFormat(&c_dfDIMouse2);
    if (hr != D3D_OK) {
        MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() }EXSetDataFormat Ɏs܂",
                   "ERROR", MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
        return hr;
    }
    // }EXxݒ
    hr = _pMouseInputDevice->SetCooperativeLevel(GgafDxGod::_pHWndPrimary, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
    if (hr != D3D_OK) {
        MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() }EXSetCooperativeLevelɎs܂",
                 "ERROR", MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
        return hr;
    }

//    if (GgafDxGod::_pHWndSecondary) {
//        // }EXxݒ
//        hr = _pMouseInputDevice->SetCooperativeLevel(GgafDxGod::_pHWndSecondary, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
//        if (hr != D3D_OK) {
//            MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() _pHWndSecondary}EXSetCooperativeLevelɎs܂"),
//                       "ERROR"), MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
//            return hr;
//        }
//    }
    // }EX[hݒ
    DIPROPDWORD dipropword_m;
    dipropword_m.diph.dwSize = sizeof(dipropword_m);
    dipropword_m.diph.dwHeaderSize = sizeof(dipropword_m.diph);
    dipropword_m.diph.dwObj = 0;
    dipropword_m.diph.dwHow = DIPH_DEVICE;
    dipropword_m.dwData = DIPROPAXISMODE_ABS; // Βl[h
    //  dipropword.dwData       = DIPROPAXISMODE_REL;   // Βl[h
    hr = _pMouseInputDevice->SetProperty(DIPROP_AXISMODE, &dipropword_m.diph);
    if (hr != D3D_OK) {
        _TRACE_( "[h̐ݒɎs");
        return FALSE;
    }

    // }EXANZX擾
    if (_pMouseInputDevice) {
        _pMouseInputDevice->Acquire();
    }

    // L[{[hfoCX̍쐬
    hr = _pIDirectInput8->CreateDevice(GUID_SysKeyboard, &_pKeyboardInputDevice, nullptr);
    if (hr != D3D_OK) {
        MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() L[{[hfoCX쐬Ɏs܂",
                   "ERROR", MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
        return hr;
    }

    // L[{[h擾f[^tH[}bg̐ݒ
    hr = _pKeyboardInputDevice->SetDataFormat(&c_dfDIKeyboard);
    if (hr != D3D_OK) {
        MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() L[{[hSetDataFormat Ɏs܂",
                   "ERROR", MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
        return hr;
    }

    // L[{[hxݒ
    hr = _pKeyboardInputDevice->SetCooperativeLevel(GgafDxGod::_pHWndPrimary, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
    if (hr != D3D_OK) {
        MessageBox(GgafDxGod::_pHWndPrimary, "GgafDxInput::initDx9Input() L[{[hSetCooperativeLevelɎs܂",
                   "ERROR", MB_OK|MB_ICONSTOP|MB_SETFOREGROUND|MB_TOPMOST);
        return hr;
    }

    /*
     //}EXobt@TCY̎w
     DIPROPDWORD dipropdword;
     dipropdword.diph.dwSize			= sizeof(DIPROPDWORD);
     dipropdword.diph.dwHeaderSize	= sizeof(DIPROPHEADER);
     dipropdword.diph.dwObj			= 0;
     dipropdword.diph.dwHow			= DIPH_DEVICE;
     dipropdword.dwData				= GgafDxInput::BUFFER_SIZE;

     hr = _pKeyboardInputDevice->SetProperty(DIPROP_BUFFERSIZE, &dipropdword.diph);
     if(hr != D3D_OK) {
     MessageBox(GgafDxGod::_pHWndPrimary,"GgafDxInput::initDx9Input() L[{[hSetPropertyɎs܂", "ERROR", MB_OK | MB_ICONSTOP | MB_SETFOREGROUND |MB_TOPMOST);
     return hr;
     }
     */
    // L[{[hANZX擾
    if (_pKeyboardInputDevice) {
        _pKeyboardInputDevice->Acquire();
    }


    // Q[XeBbN񋓂ăfoCX𓾂
    hr = _pIDirectInput8->EnumDevices(DI8DEVCLASS_GAMECTRL, GgafDxInput::enumGameCtrlCallback, nullptr, DIEDFL_ATTACHEDONLY);
    if (hr != D3D_OK || _pJoystickInputDevice == nullptr) {
        _TRACE_("GgafDxInput::initDx9Input() EnumDevices񋓂܂AWCXeBbN܂ł");
        _pJoystickInputDevice = nullptr;
    } else {
        _TRACE_("GgafDxInput::initDx9Input() WCXeBbNfoCX擾");

        // Q[XeBbÑf[^`ݒ肷
        hr = _pJoystickInputDevice->SetDataFormat(&c_dfDIJoystick);
        if (hr != D3D_OK) {
            _TRACE_("GgafDxInput::initDx9Input() WCXeBbNSetDataFormatɎs܂");
            return FALSE;
        }

        // Q[XeBbNxݒ肷
        hr = _pJoystickInputDevice->SetCooperativeLevel(GgafDxGod::_pHWndPrimary, DISCL_FOREGROUND
                | DISCL_NONEXCLUSIVE );
        if (hr != D3D_OK) {
            _TRACE_("GgafDxInput::initDx9Input() WCXeBbNSetCooperativeLevelɎs܂");
            return FALSE;
        }

        // Q[XeBbN̎f[^͈̔͂ݒ肷
        hr = _pJoystickInputDevice->EnumObjects(GgafDxInput::enumPadAxisCallback, nullptr, DIDFT_AXIS);
        if (hr != D3D_OK) {
            _TRACE_("GgafDxInput::initDx9Input() WCXeBbNEnumObjectsɎs܂");
            return FALSE;
        }

        // [hݒ
        DIPROPDWORD dipropword_j;
        dipropword_j.diph.dwSize = sizeof(dipropword_j);
        dipropword_j.diph.dwHeaderSize = sizeof(dipropword_j.diph);
        dipropword_j.diph.dwObj = 0;
        dipropword_j.diph.dwHow = DIPH_DEVICE;
        dipropword_j.dwData = DIPROPAXISMODE_ABS; // Βl[h
        //  dipropword.dwData       = DIPROPAXISMODE_REL;   // Βl[h
        hr = _pJoystickInputDevice->SetProperty(DIPROP_AXISMODE, &dipropword_j.diph);
        if (hr != D3D_OK) {
            _TRACE_( "[h̐ݒɎs");
            return FALSE;
        }

        // Q[XeBbÑANZX擾
        hr = _pJoystickInputDevice->Poll();
        if (hr != D3D_OK) {
            _TRACE_("GgafDxInput::initDx9Input() WCXeBbNPollɎs܂");
            do {
                hr = _pJoystickInputDevice->Acquire();
            } while (hr == DIERR_INPUTLOST);
        }
    }
    return S_OK;
}

BOOL CALLBACK GgafDxInput::enumGameCtrlCallback(const DIDEVICEINSTANCE *pDIDeviceInstance, VOID *pContext) {
    _TRACE_("enumGameCtrlCallback [΂I");

    HRESULT hr;

    // Q[XeBbNfoCXT
    hr = GgafDxInput::_pIDirectInput8->CreateDevice(pDIDeviceInstance->guidInstance, &GgafDxInput::_pJoystickInputDevice, nullptr);
    if(hr != D3D_OK) {
        _TRACE_("enumGameCtrlCallback WCXeBbNCreateDeviceɎs܂");
        // foCX̍쐬Ɏs񋓂𑱂iɒTj
        return DIENUM_CONTINUE;
    }

    // WCXeBbN̔\͂擾
    GgafDxInput::_devcap.dwSize = sizeof(DIDEVCAPS);
    hr = GgafDxInput::_pJoystickInputDevice->GetCapabilities( &GgafDxInput::_devcap );
    if( hr != D3D_OK ) {
        _TRACE_("enumGameCtrlCallback WCXeBbNGetCapabilitiesɎs܂");
        // WCXeBbN̔\͂擾oȂ悤ȂAي肤
        GgafDxInput::_pJoystickInputDevice->Release();
        return DIENUM_CONTINUE;
    }

    //c΃foCX̗p
    return DIENUM_STOP;
}

BOOL CALLBACK GgafDxInput::enumPadAxisCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef) {
    _TRACE_("enumPadAxisCallback [΂I");
    DIPROPRANGE diproprange;
    ZeroMemory( &diproprange, sizeof(diproprange) );
    diproprange.diph.dwSize = sizeof(diproprange);
    diproprange.diph.dwHeaderSize = sizeof(diproprange.diph);
    diproprange.diph.dwHow = DIPH_BYID;
    diproprange.diph.dwObj = lpddoi->dwType;
    diproprange.lMin = -255;
    diproprange.lMax = +255;

    HRESULT hr = GgafDxInput::_pJoystickInputDevice->SetProperty(DIPROP_RANGE, &diproprange.diph);
    if(hr != D3D_OK) {
        _TRACE_("enumPadAxisCallback WCXeBbNSetPropertyɎs܂");
        return DIENUM_STOP;
    }
    return DIENUM_CONTINUE;
}

void GgafDxInput::updateMouseState() {
#ifdef MY_DEBUG
    if (_pMouseInputDevice == nullptr) {
        _TRACE_("GgafDxInput::updateKeyboardState() _pMouseInputDevice == nullptr !!!!");
        return;
    }
#endif
    _flip_ms = !_flip_ms; //Xe[gZbgtbv
    HRESULT hr;
again:
    hr = _pMouseInputDevice->Poll(); //}EX͒ʏPollspƎvĂяoĂQƏĂ̂ŌĂԁB
    hr = _pMouseInputDevice->GetDeviceState(sizeof(DIMOUSESTATE2), (void*)&_mouse_state[_flip_ms]);
    if (FAILED(hr)) {
        hr = _pMouseInputDevice->Acquire();
        if (hr == DI_OK) {
            goto again;
        } else {
            //_Ȃ܂
        }
    }
    return;
}


bool GgafDxInput::isBeingPressedMouseButton(int prm_button_no) {
    if (prm_button_no < 0 || 8 < prm_button_no) {
        _TRACE_("isBeingPressedMouseButton:͈͊O");
        return false;
    } else {
        if (_mouse_state[_flip_ms].rgbButtons[prm_button_no] & 0x80) {
            return true;
        } else {
            return false;
        }
    }
}

bool GgafDxInput::isPushedDownMouseButton(int prm_button_no) {
    if (GgafDxInput::isBeingPressedMouseButton(prm_button_no)) { //͉Ă
        if (_mouse_state[!_flip_ms].rgbButtons[prm_button_no] & 0x80) {
            //OZbg[!_flip_ms]ĂBςȂ
            return false;
        } else {
            //OZbg[!_flip_ms]͉ĂȂ̂OK
            return true;
        }
    } else {
        return false;
    }
}

bool GgafDxInput::isReleasedUpMouseButton(int prm_button_no) {
    if (!GgafDxInput::isBeingPressedMouseButton(prm_button_no)) { //͗Ă
        if (_mouse_state[!_flip_ms].rgbButtons[prm_button_no] & 0x80) {
            //OZbg[!_flip_ms]ĂBB
            return true;
        } else {
            //OZbg[!_flip_ms]͉ĂȂBςȂB
            return false;
        }
    } else {
        return false;
    }
}

void GgafDxInput::getMousePointer(long* x, long* y, long* z) {
    //}EẌړ
    *x = _mouse_state[_flip_ms].lX;
    *y = _mouse_state[_flip_ms].lY;
    //zC[̏
    *z = _mouse_state[_flip_ms].lZ;
}

void GgafDxInput::getMousePointer_REL(long* dx, long* dy, long* dz) {
    //}EẌړ
    *dx = _mouse_state[_flip_ms].lX - _mouse_state[!_flip_ms].lX;
    *dy = _mouse_state[_flip_ms].lY - _mouse_state[!_flip_ms].lY;
    //zC[̏
    *dz = _mouse_state[_flip_ms].lZ - _mouse_state[!_flip_ms].lZ;
}

void GgafDxInput::updateKeyboardState() {
#ifdef MY_DEBUG
    if (_pKeyboardInputDevice == nullptr) {
        _TRACE_("GgafDxInput::updateKeyboardState() _pKeyboardInputDevice == nullptr !!!!");
        return;
    }
#endif
    _flip_ks = !_flip_ks; //Xe[gZbgtbv
    HRESULT hr;
again:
    hr = _pKeyboardInputDevice->Poll(); //L[{[h͒ʏPollspƎvAKvȃL[{[h邩ȂB
    hr = _pKeyboardInputDevice->GetDeviceState(256, (void*)&_keyboard_state[_flip_ks]);
    if (FAILED(hr)) {
        //_TRACE_("GetDeviceState is FAILED");
        //Acquire()݂B
        hr = _pKeyboardInputDevice->Acquire();
        if (hr == DI_OK) {
            //_TRACE_("Acquire is DI_OK");
            goto again;
        } else {
            //_TRACE_("Acquire is not DI_OK");
            //_Ȃ܂
        }
    }
    return;
}

bool GgafDxInput::isPushedDownKey(int prm_DIK) {
    if (GgafDxInput::isBeingPressedKey(prm_DIK)) { //͉Ă
        if (_keyboard_state[!_flip_ks][prm_DIK] & 0x80) {
            //OZbg[!_flip_ks]ĂBςȂ
            return false;
        } else {
            //OZbg[!_flip_ks]͉ĂȂ̂OK
            return true;
        }
    } else {
        return false;
    }
}
int GgafDxInput::getPushedDownKey() {
    int DIK_pressed = GgafDxInput::getBeingPressedKey();
    if (DIK_pressed >= 0 ) { //͉Ă
        if (_keyboard_state[!_flip_ks][DIK_pressed] & 0x80) {
            //OZbg[!_flip_ks]ĂBςȂ
            return -1;
        } else {
            //OZbg[!_flip_ks]͉ĂȂ̂OK
            return DIK_pressed;
        }
    } else {
        return -1;
    }
}


bool GgafDxInput::isReleasedUpDownKey(int prm_DIK) {
    if (!GgafDxInput::isBeingPressedKey(prm_DIK)) { //͗Ă
        if (_keyboard_state[!_flip_ks][prm_DIK] & 0x80) {
            //OZbg[!_flip_ks]͉ĂB
            return true;
        } else {
            //OZbg[!_flip_ks]ĂȂBςȂB
            return false;
        }
    } else {
        return false;
    }
}

void GgafDxInput::updateJoystickState() {
    if (_pJoystickInputDevice == nullptr) {
        return;
    }
    _flip_js = !_flip_js; //Xe[gZbgtbv
    // WCXeBbN̏Ԃ擾
    HRESULT hr;

again1:
    hr = _pJoystickInputDevice->Poll();
    if (hr != DI_OK) {
        hr = _pJoystickInputDevice->Acquire();
        if (hr == DI_OK) {
            goto again1;
        } else {
        }
    }

again2:
    hr = _pJoystickInputDevice->GetDeviceState(sizeof(DIJOYSTATE), &_joy_state[_flip_js]);
    if (hr != DI_OK) {
        hr = _pJoystickInputDevice->Acquire();
        if (hr == DI_OK) {
            goto again2;
        } else {
        }
    }
}

bool GgafDxInput::isPushedDownJoyRgbButton(int prm_rgb_button_no) {
    if (GgafDxInput::isBeingPressedJoyRgbButton(prm_rgb_button_no)) { //͉Ă
        if (_joy_state[!_flip_js].rgbButtons[prm_rgb_button_no] & 0x80) {
            //OZbg[!_flip_js]ĂBςȂ
            return false;
        } else {
            //OZbg[!_flip_js]͉ĂȂ̂OK
            return true;
        }
    } else {
        return false;
    }
}

int GgafDxInput::getPushedDownJoyRgbButton() {
    int JOY_pressed = GgafDxInput::getBeingPressedJoyRgbButton();
    if (JOY_pressed >= 0 ) { //͉Ă
        if (_joy_state[!_flip_js].rgbButtons[JOY_pressed] & 0x80) {
            //OZbg[!_flip_js]ĂBςȂ
            return -1;
        } else {
            //OZbg[!_flip_js]͉ĂȂ̂OK
            return JOY_pressed;
        }
    } else {
        return -1;
    }
}


bool GgafDxInput::isBeingPressedJoyDirection(int prm_direction_no) {
    if (prm_direction_no < 1 || 9 < prm_direction_no) {
        return false;
    } else {
        if (_joy_state[_flip_js].lY < -127) {
            if (_joy_state[_flip_js].lX > 127 && prm_direction_no == 9) {
                return true;
            } else if (_joy_state[_flip_js].lX < -127 && prm_direction_no == 7) {
                return true;
            } else if (prm_direction_no == 8) {
                return true;
            } else {
                return false;
            }
        } else if (_joy_state[_flip_js].lY > 127) {
            if (_joy_state[_flip_js].lX > 127 && prm_direction_no == 3) {
                return true;
            } else if (_joy_state[_flip_js].lX < -127 && prm_direction_no == 1) {
                return true;
            } else if (prm_direction_no == 2) {
                return true;
            } else {
                return false;
            }
        } else if (_joy_state[_flip_js].lX > 127 && prm_direction_no == 6) {
            return true;
        } else if (_joy_state[_flip_js].lX < -127 && prm_direction_no == 4) {
            return true;
        } else if (prm_direction_no == 5) {
            return true;
        } else {
            return false;
        }
    }
}

void GgafDxInput::release() {
    //foCX
    if (_pIDirectInput8) {
        if (_pKeyboardInputDevice) {
            _pKeyboardInputDevice->Unacquire();
            GGAF_RELEASE(_pKeyboardInputDevice);
        }
        if (_pJoystickInputDevice) {
            _pJoystickInputDevice->Unacquire();
            GGAF_RELEASE(_pJoystickInputDevice);
        }
        GGAF_RELEASE(_pIDirectInput8);
    }
}
