#include "jp/ggaf/dxcore/util/GgafDxWorldMatStack.h"
#include "jp/ggaf/dxcore/util/GgafDxAllocHierarchyWorldFrame.h"
using namespace GgafCore;
using namespace GgafDxCore;

GgafDxWorldMatStack::GgafDxWorldMatStack(void) : GgafObject() {
}

GgafDxWorldMatStack::~GgafDxWorldMatStack(void) {
}

// [hϊs̐ݒ
void GgafDxWorldMatStack::SetWorldMatrix(D3DXMATRIX* worldmat) {
    m_WorldTransMatrix = *worldmat;
}

void GgafDxWorldMatStack::UpdateFrame(D3DXFRAME_WORLD* frame_world) {
    // X^bN̏
    while (!m_MatrixStack.empty())
        m_MatrixStack.pop();

    // `t[Xg̏
    m_DrawFrameList.clear();

    // [hϊsX^bNɐς
    m_MatrixStack.push(&m_WorldTransMatrix);

    // [gt[烏[hϊsAvZ
    CalcFrameWorldMatrix(frame_world);
}

void GgafDxWorldMatStack::CalcFrameWorldMatrix(D3DXFRAME_WORLD* frame_world) {
    // ݂̃X^bN̐擪ɂ郏[hϊsQ
    D3DXMATRIX *pStackMat = m_MatrixStack.top();

    D3DXMatrixMultiply(&(frame_world->WorldTransMatrix), &(frame_world->TransformationMatrix), pStackMat);

    if (frame_world->pMeshContainer) {
        //_TRACE_("t[ɃbVRei");
        // ̃t[ɑΉ郏[hϊsvZ
        m_DrawFrameList.push_back(frame_world);
    }


//    // t[ɃbVRei΁Ãt[Xgɒǉ
//    if (frame_world->pMeshContainer) {
//        _TRACE_("t[ɃbVRei");
//        // ̃t[ɑΉ郏[hϊsvZ
//        D3DXMatrixMultiply(&frame_world->WorldTransMatrix, &frame_world->TransformationMatrix, pStackMat);
//        m_DrawFrameList.push_back(frame_world);
//    } else {
//        D3DXMatrixMultiply(&frame_world->WorldTransMatrix, &frame_world->TransformationMatrix, pStackMat);
//        m_DrawFrameList.push_back(frame_world);
//    }

    // qt[΃X^bNςŁAqt[̃[hϊW̌vZ
    if (frame_world->pFrameFirstChild) {
        m_MatrixStack.push(&(frame_world->WorldTransMatrix));
        CalcFrameWorldMatrix((D3DXFRAME_WORLD*)frame_world->pFrameFirstChild);
        m_MatrixStack.pop(); // qt[ÎŃX^bN1O
    }

    // Zt[΁ú݂vX^bN𗘗p
    if (frame_world->pFrameSibling) {
        //_TRACE_("Zt[ւ܂");
        CalcFrameWorldMatrix((D3DXFRAME_WORLD*)frame_world->pFrameSibling);
    }
}

// `惊Xg擾
std::list<D3DXFRAME_WORLD*> *GgafDxWorldMatStack::GetDrawList() {
    return &m_DrawFrameList;
}
