#include "MyOptionStraightLaserChip001.h"

#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/gecchi/VioletVreath/actor/effect/EffectExplosion001.h"
#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"
#include "jp/gecchi/VioletVreath/actor/my/option/MyOption.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/CommonScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

MyOptionStraightLaserChip001::MyOptionStraightLaserChip001(const char* prm_name) :
        StraightLaserChip(prm_name, "MyOptionStraightLaserChip001", STATUS(MyOptionStraightLaserChip001)) {
    _class_name = "MyOptionStraightLaserChip001";
    default_stamina_ = getStatus()->get(STAT_Stamina);
    _velo_mv = 100000;

    pOrg_ = nullptr;
    lockon_st_ = 0;
    is_lockon_ = false;
}

void MyOptionStraightLaserChip001::initialize() {
    getKuroko()->setRzRyMvAng(0,0);
    registerHitAreaCube_AutoGenMidColli(60000);
    setHitAble(true);
    _sx = _sy = _sz = R_SC(5);
    setAlpha(0.99);
    _bounding_sphere_radius = 20.0;
}

void MyOptionStraightLaserChip001::onActive() {
    getStatus()->reset();
    default_stamina_ = getStatus()->get(STAT_Stamina);
    StraightLaserChip::onActive();

    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    GgafDxKuroko* pKuroko = getKuroko();
    pKuroko->setMvVelo(80000);
    pKuroko->setMvAcce(300);
    is_lockon_ = false;
    if (pMainLockOnTarget && pMainLockOnTarget->isActiveInTheTree()) {
        if (getFrontChip() == nullptr) {
            //[`bv
            lockon_st_ = 1;
            is_lockon_ = true;
        } else {
            //[ȊO
            lockon_st_ = ((MyOptionStraightLaserChip001*) getFrontChip())->lockon_st_;//ÕbNIp
            is_lockon_ = ((MyOptionStraightLaserChip001*) getFrontChip())->is_lockon_;//ÕbNIp
        }
    } else {
        if (getFrontChip() == nullptr) {
            //[`bv
            lockon_st_ = 0;
        } else {
            //[ȊO
            lockon_st_ = ((MyOptionStraightLaserChip001*) getFrontChip())->lockon_st_;//ÕbNIp
            is_lockon_ = ((MyOptionStraightLaserChip001*) getFrontChip())->is_lockon_;//ÕbNIp
        }
    }
}

void MyOptionStraightLaserChip001::processBehavior() {
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    if (lockon_st_ == 1) {
        if (getActiveFrame() < 120) {
            if (pMainLockOnTarget) {
            } else {
                lockon_st_ = 2;
            }
        } else {
            lockon_st_ = 2;
        }
    }
    if (lockon_st_ == 2) {
        if (is_lockon_) {
            is_lockon_ = false;
//            if (getFrontChip() == nullptr) {
//            }
        }
//        if (getFrontChip() == nullptr) {
//        } else if (getFrontChip()->getFrontChip() == nullptr) {
//        } else if (getFrontChip()->getFrontChip()->getFrontChip() == nullptr) {
//        } else if (getFrontChip()->getFrontChip()->getFrontChip()->getFrontChip() == nullptr) {
//        } else {
//        }
    }
    if (getFrontChip() == nullptr) {
        getSeTx()->behave();
    }
    StraightLaserChip::processBehavior();//WړĂĂяo
    //烌[U[\̂ߋGɍW␳
    //烌[U[\̂ߋIɍW␳
    if (onChangeToActive()) {
        positionAs(pOrg_);
//        _tmpX = _x;
//        _tmpY = _y;
//        _tmpZ = _z;
    }
}

void MyOptionStraightLaserChip001::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*) prm_pOtherActor;
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    //qbgGtFNg
    //

    if ((pOther->getKind() & KIND_ENEMY_BODY) ) {
        if (pMainLockOnTarget) { //ɃIvV̓bNI
            if (pOther == pMainLockOnTarget) {
                //IvṼbNIɌꍇ

                lockon_st_ = 2; //bNI߂B񃍃bNIibNI񃍃bNIj
                if (getFrontChip() && getFrontChip()->getFrontChip() == nullptr) {
                    //Ԑ擪`bvqbgꍇA[ɂ`
                    ((MyOptionStraightLaserChip001*)getFrontChip())->lockon_st_ = 2;
                }
            } else {
                //IvṼbNIȊÕAN^[ɖꍇ
            }
        } else {
            //IvV񃍃bNIɖꍇ
        }

        int stamina = UTIL::calcMyStamina(this, pOther);
        if (stamina <= 0) {
            //ꌂŃ`bvł̍U

            //j󂳂ꂽGtFNg
            EffectExplosion001* pExplo001 = dispatchFromCommon(EffectExplosion001);
            if (pExplo001) {
                pExplo001->positionAs(this);
            }
            //bNI\AN^[Ȃ烍bNI
            if (pOther->getStatus()->get(STAT_LockonAble) == 1) {
                pOrg_->pLockonCtrler_->lockon(pOther);
            }
            sayonara();
        } else {
            //ςȂ΁AʊтAX^~i񕜁iU100̎GȂΒʊсj
            getStatus()->set(STAT_Stamina, default_stamina_);
            //bNI\AN^[Ȃ烍bNI
            if (pOther->getStatus()->get(STAT_LockonAble) == 1) {
                pOrg_->pLockonCtrler_->lockon(pOther);
            }
        }
    } else if (pOther->getKind() & KIND_CHIKEI) {
        //n`͖悤Ȃ

        //j󂳂ꂽGtFNg
        EffectExplosion001* pExplo001 = dispatchFromCommon(EffectExplosion001);
        if (pExplo001) {
            pExplo001->positionAs(this);
        }
        sayonara();
    }
//    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
//
//
//    if ((pOther->getKind() & KIND_ENEMY_BODY) ) {
//        int stamina = UTIL::calcMyStamina(this, pOther);
//        if (stamina <= 0) {
//            //ꌂŃ`bvł̍U
//
//            //j󂳂ꂽGtFNg
//            EffectExplosion001* pExplo001 = dispatchFromCommon(EffectExplosion001);
//            if (pExplo001) {
//                pExplo001->positionAs(this);
//                pExplo001->activate();
//            }
//            sayonara();
//        } else {
//            //ςȂ΁AʊтAX^~i񕜁iU100̎GȂΒʊсj
//            getStatus()->set(STAT_Stamina, default_stamina_);
//        }
//    } else if (pOther->getKind() & KIND_CHIKEI) {
//        //n`͖悤Ȃ
//        //j󂳂ꂽGtFNg
//        EffectExplosion001* pExplo001 = dispatchFromCommon(EffectExplosion001);
//        if (pExplo001) {
//            pExplo001->positionAs(this);
//        }
//        sayonara();
//    }

}
void MyOptionStraightLaserChip001::onInactive() {
    StraightLaserChip::onInactive();
    lockon_st_ = 0;
}

MyOptionStraightLaserChip001::~MyOptionStraightLaserChip001() {
}

