#ifndef IKD_DIX_PCMDECODER_H
#define IKD_DIX_PCMDECODER_H

#include <windows.h>

namespace IkdLib {

/**
 * PCMDecoder .
 * {vÓA<BR>
 * u~i܂؂j[ǂƃRv http://marupeke296.com/index.html <BR>
 * TCgRec uOgg Vorbisҁv http://marupeke296.com/OGG_main.html <BR>
 * ̃TvvOIWiłB<BR>
 * ύXĎgpĂ܂B<BR>
 *                                            2009/01/13 Masatoshi Tsuge<BR>
 * @author  IKD
 */
class PCMDecoder {
public:
    //! RXgN^
    PCMDecoder();

    //! fXgN^
    virtual ~PCMDecoder();

    //! ZOg擾
    virtual bool getSegment(char* prm_buffer,
                            unsigned int prm_size,
                            unsigned int* pUInt_write_size,
                            bool* pBool_is_end) = 0;

    //! o
    virtual void setHead() = 0;

    //! SȃN[𐶐
    virtual PCMDecoder* createClone() = 0;

public:
    //! NA
    virtual void clear();

    //! [vtO擾
    bool isLooping();

    //! łH
    bool isReady();

    //! [vݒ
    void setLooping(bool prm_is_looping);

    //! WAVEFORMATEX\̂擾
    bool getWaveFormatEx(WAVEFORMATEX& out_waveFormatEx);

protected:
    //! tOݒ
    void setReady(bool prm_is_ready);

    //! `lݒ
    void setChannelNum(unsigned int prm_num_channel);

    //! TvO[gݒ
    void setSamplingRate(unsigned int prm_sampling_rate);

    //! rbg[gݒ
    void setBitRate(unsigned int prm_bit_rate);

protected:
    bool _is_looping; //!< [vH
    bool _is_ready; //!< łH
    unsigned int _num_channel; //!< `l
    unsigned int _sampling_rate; //!< TvO[g
    unsigned int _bit_rate; //!< rbg[g
};
}

#endif
