#include "stdafx.h"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"

#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/manager/GgafDxModelManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxModelConnection.h"
#include "jp/ggaf/dxcore/manager/GgafDxEffectManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxEffectConnection.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAlphaFader.h"
#include "jp/ggaf/dxcore/scene/GgafDxScene.h"
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"
#include "jp/ggaf/dxcore/scene/supporter/GgafDxAlphaCurtain.h"
#include "jp/ggaf/core/util/GgafRgb.h"

using namespace GgafCore;
using namespace GgafDxCore;

hashval GgafDxDrawableActor::_hash_technique_last_draw = 0;

GgafDxDrawableActor::GgafDxDrawableActor(const char* prm_name,
                                         const char* prm_model,
                                         const char* prm_effect,
                                         const char* prm_technique,
                                         GgafStatus* prm_pStat,
                                         GgafDxChecker* prm_pChecker) :
  GgafDxGeometricActor(prm_name, prm_pStat, prm_pChecker),
_pModelCon((GgafDxModelConnection*)GgafDxGod::_pModelManager->connect(
                  std::string(prm_model).c_str(),
                  this)),
_pModel((GgafDxModel*)_pModelCon->peek()),
_pEffectCon((GgafDxEffectConnection*)GgafDxGod::_pEffectManager->connect(
                  std::string(prm_effect).c_str(),
                  this)),
_pEffect((GgafDxEffect*)_pEffectCon->peek()) {

    _obj_class |= Obj_GgafDxDrawableActor;
    _class_name = "GgafDxDrawableActor";

    _technique = NEW char[51];
    strcpy(_technique, prm_technique);
    _hash_technique = 0;

    _temp_technique = NEW char[51];
    _hash_temp_technique = 0;

    _frame_of_behaving_temp_technique_end = 0;
    _is_temp_technique = false;
    _pNext_TheSameDrawDepthLevel = nullptr;
//    //f擾connectModelManager
//    _pModelCon = (GgafDxModelConnection*)GgafDxGod::_pModelManager->connect(prm_model, this);
//    _pModel = (GgafDxModel*)_pModelCon->peek();
//    //GtFNg擾
//    _pEffectCon = (GgafDxEffectConnection*)GgafDxGod::_pEffectManager->connect(prm_effect, this);
//    _pEffect = (GgafDxEffect*)_pEffectCon->peek();
    //}eARs[
    _paMaterial = NEW D3DMATERIAL9[_pModel->_num_materials];
    for (DWORD i = 0; i < _pModel->_num_materials; i++){
        _paMaterial[i] = _pModel->_paMaterial_default[i];
    }
    _alpha = 1.0f;
    //ő勗_
    _bounding_sphere_radius = _pModel->_bounding_sphere_radius;
    _now_drawdepth = 0;
    _specal_drawdepth = -1;
    _zenable = true;
    _zwriteenable = true;
    _hash_technique = UTIL::easy_hash(prm_technique) + UTIL::easy_hash(_pModel->getName());
}

GgafDxDrawableActor::GgafDxDrawableActor(const char* prm_name,
                                         const char* prm_model_id,
                                         const char* prm_model_type,
                                         const char* prm_effect_id,
                                         const char* prm_effect_type,
                                         const char* prm_technique,
                                         GgafStatus* prm_pStat,
                                         GgafDxChecker* prm_pChecker) :
  GgafDxGeometricActor(prm_name, prm_pStat, prm_pChecker),
_pModelCon((GgafDxModelConnection*)GgafDxGod::_pModelManager->connect(
                    (std::string(prm_model_type) + std::string("/") + std::string(prm_model_id)).c_str(),
                    this)),
_pModel((GgafDxModel*)_pModelCon->peek()),
_pEffectCon((GgafDxEffectConnection*)GgafDxGod::_pEffectManager->connect(
                    (std::string(prm_effect_type) + std::string("/") + std::string(prm_effect_id)).c_str(),
                    this)),
_pEffect((GgafDxEffect*)_pEffectCon->peek())
          {

    _class_name = "GgafDxDrawableActor";

    _technique = NEW char[51];
    strcpy(_technique, prm_technique);
    _hash_technique = 0;

    _temp_technique = NEW char[51];
    _hash_temp_technique = 0;

    _frame_of_behaving_temp_technique_end = 0;
    _is_temp_technique = false;

//    char* model_name = NEW char[51];
//    model_name[0] = '\0';
//    strcat(model_name, prm_model_type);
//    strcat(model_name, "/");
//    strcat(model_name, prm_model_id);
//    // prm_model_id   = "Eres"
//    // prm_model_type = "X"
//    // ̏ꍇAmodel_name Ƃ
//    // model_name     = "X/Eres"
//    // Ƃ쐬B
//
//    char* effelct_name = NEW char[51];
//    effelct_name[0] = '\0';
//    strcat(effelct_name, prm_effect_type);
//    strcat(effelct_name, "/");
//    strcat(effelct_name, prm_effect_id);
//    // prm_effect_id   = "DefaultMeshEffect"
//    // prm_effect_type = "X"
//    // ̏ꍇAeffelct_name Ƃ
//    // effelct_name     = "X/DefaultMeshEffect"
//    // Ƃ쐬B

    _pNext_TheSameDrawDepthLevel = nullptr;

    //}eARs[
    _paMaterial = NEW D3DMATERIAL9[_pModel->_num_materials];
    for (DWORD i = 0; i < _pModel->_num_materials; i++){
        _paMaterial[i] = _pModel->_paMaterial_default[i];
    }
    _alpha = 1.0f;
    //ő勗_
    _bounding_sphere_radius = _pModel->_bounding_sphere_radius;

//    GGAF_DELETEARR(model_name);
//    GGAF_DELETEARR(effelct_name);

    _now_drawdepth = 0;
    _specal_drawdepth = -1;
    _zenable = true;
    _zwriteenable = true;
    _hash_technique = UTIL::easy_hash(prm_technique) + UTIL::easy_hash(_pModel->getName());
}

void GgafDxDrawableActor::processPreDraw() {
#ifdef MY_DEBUG
    if (getPlatformScene()->instanceOf(Obj_GgafDxScene)) {
        //OK
    } else {
        throwGgafCriticalException("GgafDxDrawableActor::processPreDraw() name="<<getName()<<"`o^悤Ƃ܂AV[ name="<<getName()<<"->getPlatformScene()["<<(getPlatformScene()->getName())<<"]AGgafDxScene ɕϊsłBthis="<<this<<" \n"<<
                "getPlatformScene()->_obj_class="<<getPlatformScene()->_obj_class<< " Obj_GgafDxScene="<<Obj_GgafDxScene<<" \n"<<
                "(getPlatformScene()->_obj_class & Obj_GgafDxScene)="<<((getPlatformScene()->_obj_class) & Obj_GgafDxScene) <<" ==?? Obj_GgafDxScene("<<Obj_GgafDxScene<<")");
    }
#endif
    if (_pModel->_is_init_model == false) {
        onCreateModel(); //f쐬̏
        _pModel->_is_init_model = true;
    }
    _pNext_TheSameDrawDepthLevel = nullptr;
    //TODO:v
    if (_alpha > 0.0f && isActiveInTheTree()) { //isActiveInTheTree() Ŕ肷ƁA
        if (_is_2D) {
//            _now_drawdepth = GgafDxUniverse::setDrawDepthLevel(
//                                (int)((1.0*_z/LEN_UNIT) * MAX_DRAW_DEPTH_LEVEL),
//                                this
//                             );
            if (((GgafDxScene*)getPlatformScene())->_master_alpha <= 0.0f) {
                //`悵Ȃ̂œo^Ȃ
            } else {
                if (_specal_drawdepth < 0) { //ʂȕ`[xw薳
                    _now_drawdepth = GgafDxUniverse::setDrawDepthLevel(_z, this); //2D_z̓vCIeBɎgpB
                } else {
                    //ʂȕ`[xwL
                    if (GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth] == nullptr) {
                        //prm_draw_depth_levelōŏ̃AN^[̏ꍇ
                        this->_pNext_TheSameDrawDepthLevel = nullptr;
                        GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth] = this;
                        GgafDxUniverse::_apAlphaActorLastList_DrawDepthLevel[_specal_drawdepth] = this;
                    } else {
                        //Oɒǉ
                        GgafDxDrawableActor* pActorTmp = GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth];
                        this->_pNext_TheSameDrawDepthLevel = pActorTmp;
                        GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth] = this;
                    }
                    _now_drawdepth = _specal_drawdepth;
                }

            }
        } else {
            if (((GgafDxScene*)getPlatformScene())->_pAlphaCurtain->_alpha <= 0.0f || isOutOfView()) {
                //`悵Ȃ̂œo^Ȃ
            } else {
                //
                //Jʒu _cameraZ_org = -47.6701A\͈͉s  _zf  _dep=20̂ƂA_zf = -_cameraZ_org*(_dep+1); Ƃꍇ̗BB
                //uQƁFGgafDxCamera::GgafDxCamera()v
                //\͈(s:_zf)̋͏J̈ʒu21{Ŗ 1000(1001.0721) ɂȂiꂪ _zf = -_cameraZ_org*20.0 ̈Ӗj
                // MAX_DRAW_DEPTH_LEVEL (1000)Ƃǂ̂悤ɑΉ邩
                //{CuDIRECTXW1͌_t߂̂ŉʏ10pxƂvZsĂB
                //͖̕10pxԊủ̒iK_O̐ݒƂȂ
                //
                //  GgafDxUniverse::setDrawDepthLevel(-1.0*_dest_from_vppln_front, this);
                //   (_dest_from_vppln_front͎OʂIuWFNg܂ł̋̕)
                //
                //́A1000 iK̐[xƂȂB
                //܂A
                //
                //  GgafDxUniverse::setDrawDepthLevel(-1.0*_dest_from_vppln_front*10.0, this);
                //
                //1pxԊuŖ 10000 iKƂȂB
                //MAX_DRAW_DEPTH_LEVEL𑝂₹ΖȂA600iK炢̖ptH[}XIɂ傤ǂ悳łB
                //ȂƂ600iK炢őΉiK_O悤ƍlB
                //
                //͂邩IuWFNgBׂiK`悵Ă܂ȂƍlB
                //Jɋ߂قǐɁAقǃAoEgɒiK_OƍlB
                //
                //  <o   |-+-+-+-+-+-+-+-+-+-+-+-+-+--+---+----+-----+------+------+-------+-----
                //              ------>          ^            ------>                         ^
                // J                   AoEgԊuJn[x                                 Ő[
                //
                //}̂悤ȃC[WiKIɍrĂI
                //yQlz
                //   7975036 <DEBUG> GgafDxCamera::GgafDxCamera ʃAXyNgF1.33333
                //   7975036 <DEBUG> GgafDxCamera::GgafDxCamera FovX=1.39626 FovY=1.12341
                //   7975036 <DEBUG> GgafDxCamera::GgafDxCamera J̈ʒu(0,0,-47.6701)
                //   7975036 <DEBUG> GgafDxCamera::GgafDxCamera ͈ [0.01 ~ 1001.07]
                //
                // 1001.07 ܂10000px̉s`
                dxcoord dep = -_dest_from_vppln_front; //IuWFNg̎_̋(DIRECTX)

                static const double dep_rate_point1 = 0.3;                                //rȂ|CgP̊(Js 3/10 ̒n_)
                static const double dep_rate_point2 = 0.6;                                //rȂ|CgQ̊(Js 6/10 ̒n_)
                static const dxcoord roughly_dep_point1 = (P_CAM->_zf * dep_rate_point1); //rȂ|CgP
                static const dxcoord roughly_dep_point2 = (P_CAM->_zf * dep_rate_point2); //rȂ|CgQ
                static const double dep_level_rate_cam_to_point1 = 0.5;                   //_`rȂ|CgP܂ł́A[xx߂邽߂ɋɏ悸銄B
                static const double dep_level_rate_point1_to_point2 = 0.2;                //rȂ|CgP`|CgQԂ́A[xx߂邽߂ɋɏ悸銄B
                static const double dep_level_rate_point2_to_far_away = 0.01;             //rȂ|CgQ`ŉ́A[xx߂邽߂ɋɏ悸銄B
                static const int roughly_dep_point1_DRAW_DEPTH_LEVEL = roughly_dep_point1*dep_level_rate_cam_to_point1;    //rȂ|CgP[xx
                static const int roughly_dep_point2_DRAW_DEPTH_LEVEL = roughly_dep_point1_DRAW_DEPTH_LEVEL +
                               ((roughly_dep_point2 - roughly_dep_point1) * dep_level_rate_point1_to_point2);        //rȂ|CgQ[xx

                if (_specal_drawdepth < 0) { //ʂȕ`[xw薳
                    if (dep <= roughly_dep_point1) {         //dep _ ` rrȂ|CgP ܂ł̋̃IuWFNg
                        _now_drawdepth = GgafDxUniverse::setDrawDepthLevel(
                                             dep*dep_level_rate_cam_to_point1,
                                             this); //DirectX̋10.5{ADirectX̋2[1BĖ20pxԊu
                    } else if (dep <= roughly_dep_point2) {  //dep rȂ|CgP`|CgQ
                        _now_drawdepth = GgafDxUniverse::setDrawDepthLevel(
                                             roughly_dep_point1_DRAW_DEPTH_LEVEL +
                                               ((dep - roughly_dep_point1) * dep_level_rate_point1_to_point2),
                                             this);  //DirectX̋10.2{B܂DirectX̋5[1B50pxԊuŒiK_
                    } else {                                 //dep |CgQȍ~
                        _now_drawdepth = GgafDxUniverse::setDrawDepthLevel(
                                             roughly_dep_point2_DRAW_DEPTH_LEVEL +
                                               ((dep - roughly_dep_point2) * dep_level_rate_point2_to_far_away),
                                             this); //0.01{B܂DirectX̋100[1B1000pxԊuŒiK_
                    }
                } else {
                    //ʂȕ`[xwL
                    if (GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth] == nullptr) {
                        //prm_draw_depth_levelōŏ̃AN^[̏ꍇ
                        this->_pNext_TheSameDrawDepthLevel = nullptr;
                        GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth] = this;
                        GgafDxUniverse::_apAlphaActorLastList_DrawDepthLevel[_specal_drawdepth] = this;
                    } else {
                        //Oɒǉ
                        GgafDxDrawableActor* pActorTmp = GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth];
                        this->_pNext_TheSameDrawDepthLevel = pActorTmp;
                        GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[_specal_drawdepth] = this;
                    }
                    _now_drawdepth = _specal_drawdepth;
                }

            }
        }
    }

    //ꎞeNjbNԃ`FbN
    if (_is_temp_technique) {
        if (_frame_of_behaving_temp_technique_end <= _frame_of_behaving) {
            //ꎞeNjbNԖBɖ߂
            _hash_technique = _hash_temp_technique;
            strcpy(_technique, _temp_technique);
            _is_temp_technique = false;
            //̓_Bz̈悪ǂɂ߁B_temp_technique = "";
            _hash_temp_technique = 0;
        }
    }

}


void GgafDxDrawableActor::processAfterDraw() {
#ifdef MY_DEBUG
    //蔻̈\
    if (GgafDxGod::_d3dfillmode == D3DFILL_WIREFRAME) {
        GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_FILLMODE, D3DFILL_SOLID);
        drawHitArea();
        GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_FILLMODE, GgafDxGod::_d3dfillmode);
    }
#endif
}

void GgafDxDrawableActor::setMaterialColor(float r, float g, float b) {
    for (DWORD i = 0; i < _pModel->_num_materials; i++) {
        _paMaterial[i].Ambient.r = r;
        _paMaterial[i].Diffuse.r = r;
        _paMaterial[i].Ambient.g = g;
        _paMaterial[i].Diffuse.g = g;
        _paMaterial[i].Ambient.b = b;
        _paMaterial[i].Diffuse.b = b;
    }
}

void GgafDxDrawableActor::setMaterialColor(GgafCore::GgafRgb* prm_rgb) {
    setMaterialColor(prm_rgb->_r, prm_rgb->_g, prm_rgb->_b);
}

void GgafDxDrawableActor::resetMaterialColor() {
    for (DWORD i = 0; i < _pModel->_num_materials; i++) {
        _paMaterial[i].Ambient.r = _pModel->_paMaterial_default[i].Ambient.r;
        _paMaterial[i].Diffuse.r = _pModel->_paMaterial_default[i].Diffuse.r;
        _paMaterial[i].Ambient.g = _pModel->_paMaterial_default[i].Ambient.g;
        _paMaterial[i].Diffuse.g = _pModel->_paMaterial_default[i].Diffuse.g;
        _paMaterial[i].Ambient.b = _pModel->_paMaterial_default[i].Ambient.b;
        _paMaterial[i].Diffuse.b = _pModel->_paMaterial_default[i].Diffuse.b;
    }
}

void GgafDxDrawableActor::setSpecialDrawDepth(int prm_drawdepth) {
    if (prm_drawdepth > MAX_DRAW_DEPTH_LEVEL) {
        _specal_drawdepth = MAX_DRAW_DEPTH_LEVEL;
    } else {
        _specal_drawdepth = prm_drawdepth;
    }
}

void GgafDxDrawableActor::changeEffectTechnique(const char* prm_technique) {
    _hash_technique = UTIL::easy_hash(prm_technique) + UTIL::easy_hash(_pModel->getName());
    strcpy(_technique, prm_technique);
}
void GgafDxDrawableActor::changeEffectTechniqueInterim(const char* prm_technique, frame prm_frame) {
    if (_is_temp_technique == false) { //łɈꎞeNjbNgp͖
        //X̃eNjbNޔ
        _hash_temp_technique = _hash_technique;
        strcpy(_temp_technique, _technique);
        //eNjbNύX
        if (prm_frame == MAX_FRAME) {
            _frame_of_behaving_temp_technique_end = MAX_FRAME;
        } else {
            _frame_of_behaving_temp_technique_end = _frame_of_behaving + prm_frame; //ύXt[
        }
        _hash_technique = UTIL::easy_hash(prm_technique) + UTIL::easy_hash(_pModel->getName());
        strcpy(_technique, prm_technique);
        _is_temp_technique = true;
    }
}

void GgafDxDrawableActor::effectFlush(frame prm_frame) {
    changeEffectTechniqueInterim("Flush", prm_frame); //tbV
}

void GgafDxDrawableActor::effectBlendOne(frame prm_frame) {
    changeEffectTechniqueInterim("DestBlendOne", prm_frame);
}

void GgafDxDrawableActor::effectDefault() {
    if (_is_temp_technique) {
        _hash_technique = _hash_temp_technique;
        strcpy(_technique, _temp_technique);
        _is_temp_technique = false;
        _hash_temp_technique = 0;
    }
}

GgafDxDrawableActor::~GgafDxDrawableActor() {
    GGAF_DELETEARR(_technique);
    GGAF_DELETEARR(_temp_technique);
    GGAF_DELETEARR(_paMaterial);

    _pEffectCon->close();
    _pModelCon->close();
}
