#include "CostDispBar.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxUvFlipper.h"
#include "jp/ggaf/lib/util/PxQuantity.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

CostDispBar::CostDispBar(const char* prm_name, GraphBarActor* prm_pTargetSourceBar)
      : GraphBarActor(prm_name, "CostDispBar") {
    _class_name = "CostDispBar";
    pSourceBar_ = prm_pTargetSourceBar;
}

void CostDispBar::initialize() {
    setAlpha(0.7); //̒lg
}

void CostDispBar::onReset() {
    positionAs(pSourceBar_);
    _sx = pSourceBar_->_sx;
    setQty(0);
}

void CostDispBar::onActive() {
    positionAs(pSourceBar_);
    _sx = pSourceBar_->_sx;
    setQty(0);
}

void CostDispBar::processBehavior() {
    _x = pSourceBar_->_x + PX_C(pSourceBar_->getBarPx()); //pSourceBar_[̍W
    if (getQty() > 0) {
        //̒l͎僁[^[̑lŎ悤ɂB
        getUvFlipper()->setActivePtn(4);//
    } else if (getQty() < 0) {
        //̒l͎僁[^[̍팸lԂŎ悤ɂB
        getUvFlipper()->setActivePtn(0);//
    }
}


void CostDispBar::processJudgement() {
}

void CostDispBar::onInactive() {
}

CostDispBar::~CostDispBar() {
}
