﻿// ThirdEyeen - Client of Twitter
// Copyright (c) 2007-2011 kiri_feather (@kiri_feather) <kiri.feather@gmail.com>
//           (c) 2008-2011 Moz (@syo68k)
//           (c) 2008-2011 takeshik (@takeshik) <http://www.takeshik.org/>
//           (c) 2010-2011 anis774 (@anis774) <http://d.hatena.ne.jp/anis774/>
//           (c) 2010-2011 fantasticswallow (@f_swallow) <http://twitter.com/f_swallow>
//           (c) 2011      kim_upsilon (@kim_upsilon) <https://upsilo.net/~upsilon/>
//           (c) 2014      hama_kai (@hama_kai) <http://hamakaiji.web.fc2.com/>
// All rights reserved.
// 
// This file is part of ThirdEyeen.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General public License
// for more details.
// 
// You should have received a copy of the GNU General public License along
// with this program. If not, see <http://www.gnu.org/licenses/>, or write to
// the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
// Boston, MA 02110-1301, USA.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.Drawing;

namespace OpenTween
{
    [DataContract]
    public class SettingThirdEyeen : SettingBaseDataContract<SettingThirdEyeen>
    {
        public static SettingThirdEyeen Instance { get; internal set; }

        static SettingThirdEyeen()
        {
            Instance = new SettingThirdEyeen();
        }

        #region Settingクラス基本
        public static SettingThirdEyeen Load()
        {
            SettingThirdEyeen setting = LoadSettings("");
            return setting;
        }

        public void Save()
        {
            SaveSettings(this);
        }

#endregion

        [DataMember]
        public List<UserAccount> UserAccounts;
        [DataMember]
        public string UserName = "";

        public string Password = "";
        [DataMember]
        public string EncryptPassword
        {
            get { return Encrypt(Password); }
            set { Password = Decrypt(value); }
        }

        [DataMember]
        public string Token = "";
        public string TokenSecret = "";
        [DataMember]
        public string EncryptTokenSecret
        {
            get { return Encrypt(TokenSecret); }
            set { TokenSecret = Decrypt(value); }
        }

        private string Encrypt(string password)
        {
            if (String.IsNullOrEmpty(password)) password = "";
            if (password.Length > 0)
            {
                try
                {
                    return MyCommon.EncryptString(password);
                }
                catch (Exception)
                {
                    return "";
                }
            }
            else
            {
                return "";
            }
        }
        private string Decrypt(string password)
        {
            if (String.IsNullOrEmpty(password)) password = "";
            if (password.Length > 0)
            {
                try
                {
                    password = MyCommon.DecryptString(password);
                }
                catch (Exception)
                {
                    password = "";
                }
            }
            return password;
        }

        [DataMember]
        public long UserId = 0;

        [DataMember]
        public bool EnableBothUserStreamPeriodicFetch;
        [DataMember]
        public bool MoreGetsPreviousToLast;
        [DataMember]
        public int RepeatGetLoopCount;
        [DataMember]
        public int RepeatGetCountApi;
        [DataMember]
        public bool RepeatGetInit;

        [DataMember]
        public long LastHomeTimeline;
        [DataMember]
        public long LastMentions;
        [DataMember]
        public long LastDirectmessage;
        [DataMember]
        public long LastDirectmessageSent;

        [DataMember]
        public Dictionary<string, long> TabsLastId;

        [DataMember]
        public bool OsWokenDetectPowerTroubleshooter;
        [DataMember]
        public int WokenWaitPeriod;

        [DataMember]
        public Color ColorRTby;
        [DataMember]
        public Color ColorWhoRT;
        [DataMember]
        public Color ColorRTbyWhoRT;

        [DataMember]
        public bool EnableColorRTby;
        [DataMember]
        public bool EnableColorWhoRT;
        [DataMember]
        public bool EnableColorRTbyWhoRT;

        public SettingThirdEyeen()
        {
            TabsLastId = new Dictionary<string, long>();

            this.SetDefaultValues();
        }

        //SettingThirdEyeen.xml逆シリアル化時に呼び出されるメソッド
        //
        //SettingThirdEyeen.xmlがすでに存在する場合、SettingThirdEyeen.xmlに含まれていないフィールドは、フィールド宣言の初期値やコンストラクタで初期化されないため、ここで初期化する。
        //SettingThirdEyeen.xmlが存在しない場合は呼び出されないので、フィールド宣言かコンストラクタでも初期化は必要。
        // 参考 : DataContractSerializerのデシリアライズで既定値を設定する « 空談録 http://artfulplace.net/blogs/set-default-value-to-datacontract-serialized-object/
        [OnDeserializing]
        public void OnDeserializingMethod(StreamingContext context)
        {
            this.SetDefaultValues();
        }

        public void SetDefaultValues()
        {
            this.EnableBothUserStreamPeriodicFetch = false;
            this.MoreGetsPreviousToLast = false;
            this.RepeatGetLoopCount = 0;
            this.RepeatGetCountApi = 200;
            this.RepeatGetInit = false;

            this.LastHomeTimeline = long.MaxValue;
            this.LastMentions = long.MaxValue;
            this.LastDirectmessage = long.MaxValue;
            this.LastDirectmessageSent = long.MaxValue;

            this.OsWokenDetectPowerTroubleshooter = false;
            this.WokenWaitPeriod = 5;

            this.ColorRTby = Color.FromKnownColor(System.Drawing.KnownColor.LightYellow);
            this.ColorWhoRT = Color.FromKnownColor(System.Drawing.KnownColor.Beige);
            this.ColorRTbyWhoRT = Color.FromKnownColor(System.Drawing.KnownColor.Beige);

            this.EnableColorRTby = false;
            this.EnableColorWhoRT = false;
            this.EnableColorRTbyWhoRT = false;
        }
    }

    public class UserAccount
    {
        [DataMember]
        public string Username = "";
        [DataMember]
        public long UserId = 0;
        [DataMember]
        public string Token = "";
        public string TokenSecret = "";
        [DataMember]
        public string EncryptTokenSecret
        {
            get { return Encrypt(TokenSecret); }
            set { TokenSecret = Decrypt(value); }
        }
        private string Encrypt(string password)
        {
            if (String.IsNullOrEmpty(password)) password = "";
            if (password.Length > 0)
            {
                try
                {
                    return MyCommon.EncryptString(password);
                }
                catch (Exception)
                {
                    return "";
                }
            }
            else
            {
                return "";
            }
        }
        private string Decrypt(string password)
        {
            if (String.IsNullOrEmpty(password)) password = "";
            if (password.Length > 0)
            {
                try
                {
                    password = MyCommon.DecryptString(password);
                }
                catch (Exception)
                {
                    password = "";
                }
            }
            return password;
        }
        public override string ToString()
        {
            return this.Username;
        }
    }
}
