//
//  bios.c
//  chncpu
//
//  Created by 西田　耀 on 2014/06/14.
//  Copyright (c) 2014年 CHNOSProject. All rights reserved.
//

#include "chncpu.h"
#include <stdio.h>

CHNCPU_BIOS *CHNCPU_CreateBIOS(void)
{
	CHNCPU_BIOS *bios;
	
	bios = malloc(sizeof(CHNCPU_BIOS));
	if(!bios){
        puts("CHNCPU_CreateBIOS: malloc error, abort.\n");
        exit(EXIT_FAILURE);
    }
	
	CHNCPU_BIOS_Init(bios);
	
	return bios;
}

int CHNCPU_BIOS_Init(CHNCPU_BIOS *bios)
{
	int i;
	
	// FuncTables
    for(i = 0; i <= CHNCPU_BIOS_OP_MAX; i++){
        bios->bindFuncTable[i] = NULL;
		bios->execFuncTable[i] = NULL;
		bios->printFuncTable[i] = NULL;
    }
	
	// putcReg
    bios->bindFuncTable[0x00] = CHNCPU_BIOS_Op_putcReg_BindOperand;
	bios->execFuncTable[0x00] = CHNCPU_BIOS_Op_putcReg_Execute;
	bios->printFuncTable[0x00] = CHNCPU_BIOS_Op_putcReg_PrintCode;
	
	return 0;

}

//
// putcReg
//

typedef struct _CHNCPU_BIOS_OP_CACHE_LIMM CHNCPU_BIOS_OpCache_putcReg;
struct _CHNCPU_BIOS_OP_CACHE_LIMM {
    ch4_uint r;
};
int CHNCPU_BIOS_Op_putcReg_BindOperand(CHNCPU_RuntimeEnvironment *env, CHNCPU_OpTag *op, unsigned int prefix)
{
    CHNCPU_BIOS_OpCache_putcReg *opCache;
    
    opCache = malloc(sizeof(CHNCPU_BIOS_OpCache_putcReg));
    op->opCache = opCache;
    
    opCache->r = CH4Reader_ReadNextAsUINT(env->appbinReader);
    
    if(opCache->r >= CHNCPU_NUMBER_OF_IREG){
        env->errFlags |= CHNCPU_ERR_INVALID_REGNUM;
        return -1;
    }
	if(prefix != 0){
		env->errFlags |= CHNCPU_ERR_INVALID_PREFIX;
        return -1;
	}
    return 0;
}
int CHNCPU_BIOS_Op_putcReg_Execute(CHNCPU_RuntimeEnvironment *env, CHNCPU_OpTag *op)
{
    CHNCPU_BIOS_OpCache_putcReg *opCache;
    
    opCache = op->opCache;
        
	putchar(env->iReg[opCache->r]);
    
    return 0;
}

int CHNCPU_BIOS_Op_putcReg_PrintCode(CHNCPU_RuntimeEnvironment *env, CHNCPU_OpTag *op, FILE *file)
{
    CHNCPU_BIOS_OpCache_putcReg *opCache;
    
    opCache = op->opCache;
    fprintf(file, "BIOS::putcReg(r:%d);\n", opCache->r);
	
    return 0;
}
