//
//  ch4.c
//  chncpu
//
//  Created by 西田　耀 on 2014/06/04.
//  Copyright (c) 2014年 CHNOSProject. All rights reserved.
//

#include "ch4.h"

int CH4Reader_Initialize(CH4Reader *reader, const unsigned char *rawData, int rawDaraLength)
{
    reader->rawData = rawData;
    reader->rawDataLength = rawDaraLength;
    reader->errorFlags = 0;
    reader->phase = 0;
	reader->rp = 0;
	reader->lastBits = 0;
    
    return 0;
}

int CH4Reader_Internal_Read4bitAtIndex(CH4Reader *reader, int index)
{
	unsigned char tmp;
	
	if(reader->errorFlags != 0){
		return -1;
	}
	if((index >> 1) >= reader->rawDataLength){
		reader->errorFlags |= CH4_READ_ERROR_INVALID_INDEX;
		return -1;
	}
	
	tmp = reader->rawData[index >> 1];
	
	if(!(index & 1)){
		tmp >>= 4;
	}
	return tmp & 0xf;
}

ch4_uint CH4Reader_ReadNextAsUINT(CH4Reader *reader)
{
	int diff = 0;
	ch4_uint retv;
	CH4Reader_SkipNextPadding(reader);
	retv = CH4Reader_ReadBodyAtIndexAsUINT(reader, reader->rp, &diff);
	reader->rp += diff;
	return retv;
}

ch4_sint CH4Reader_ReadNextAsSINT(CH4Reader *reader)
{
	ch4_sint retv;
	retv = CH4Reader_ReadNextAsUINT(reader);
	retv = CH4Reader_SignExtend(retv, reader->lastBits);
	return retv;
}

unsigned int CH4Reader_ReadNextUINTn(CH4Reader *reader, unsigned int n)
{
	//次のUINTnを読み込む
	unsigned int retv;
	int i;
	if((n & 3) != 0 || n > 32){
		reader->errorFlags |= CH4_READ_ERROR_NOT_SUPPORTED;
		return 0;
	}
	
	n >>= 2;
	retv = 0;
	for(i = 0; i < n; i++){
		retv <<= 4;
		retv |= CH4Reader_Internal_Read4bitAtIndex(reader, reader->rp);
		reader->rp++;
	}
	
	return retv;
}

int CH4Reader_SignExtend(int value, unsigned int baseBits)
{
	if (baseBits > 0 && value >= (1 << (baseBits - 1))){
		value -= 1 << baseBits; // MSBが1なら引き算して負数にする.
	}
	return value;
}

int CH4Reader_SkipNextPadding(CH4Reader *reader)
{
	int i;
	for(i = 0; ; i++){
		if(0xF != CH4Reader_Internal_Read4bitAtIndex(reader, reader->rp)){
			break;
		}
		reader->rp++;
	}
	return i;
}

int CH4Reader_IsEndOfBinary(CH4Reader *reader)
{
	return ((reader->rp >> 1) >= reader->rawDataLength);
}

ch4_uint CH4Reader_ReadBodyAtIndexAsUINT(CH4Reader *reader, int index, int *retReadIndex)
{
	// padding非許容
	int tmp;
	ch4_uint value;
	int readIndex;
	
	
	tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index);
	readIndex = 0;
	reader->lastBits = 0;
	if(tmp == -1){
		// error
		value = 0;
	} else if((tmp & 8) == 0){
		// 4bit or prefix_ext
		if(tmp == 7){
			// prefix_ext
			value = CH4Reader_ReadBodyAtIndexAsUINT_prefix_ext(reader, index + 1, &readIndex);
		} else{
			// 4bit
			value = tmp;
			//
			readIndex = 1;
			reader->lastBits = 3;
		}
	} else{
		if((tmp & 4) == 0){
			// 8bit
			value = tmp & 3;
			value <<= 4;
			tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index + 1);
			value |= tmp & 0xf;
			//
			readIndex = 2;
			reader->lastBits = 6;
		} else if((tmp & 2) == 0){
			// 12bit
			value = tmp & 1;
			value <<= 4;
			tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index + 1);
			value |= tmp & 0xf;
			value <<= 4;
			tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index + 2);
			value |= tmp & 0xf;
			//
			readIndex = 3;
			reader->lastBits = 9;
		} else if((tmp & 1) == 0){
			// 16bit
			tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index + 1);
			value = tmp & 0xf;
			value <<= 4;
			tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index + 2);
			value |= tmp & 0xf;
			value <<= 4;
			tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index + 3);
			value |= tmp & 0xf;
			//
			readIndex = 4;
			reader->lastBits = 12;
		} else{
			// padding
			puts("CH4_READ_ERROR_TRAP_PADDING \n");
			reader->errorFlags |= CH4_READ_ERROR_TRAP_PADDING;
			return 0;
		}
	}
	if(retReadIndex){
		*retReadIndex = readIndex;
	}
	return value;
}

ch4_uint CH4Reader_ReadBodyAtIndexAsUINT_prefix_ext(CH4Reader *reader, int index, int *retReadIndex)
{
	// indexはprefix_extの次を指す
	int tmp;
	ch4_uint value;
	int valueIndexLen;
	int i;
	
	valueIndexLen = CH4Reader_ReadBodyAtIndexAsUINT(reader, index, retReadIndex);
	
	if(valueIndexLen > 8){
		puts("CH4_READ_ERROR_NOT_SUPPORTED \n");
		reader->errorFlags |= CH4_READ_ERROR_NOT_SUPPORTED;
		return 0;
	}
	
	value = 0;
	for(i = 0; i < valueIndexLen; i++){
		tmp = CH4Reader_Internal_Read4bitAtIndex(reader, index + *retReadIndex + i);
		if(tmp == -1){
			return 0;
		}
		value = tmp & 0xf;
		value <<= 4;
	}
	(*retReadIndex) += 1 + valueIndexLen;
	reader->lastBits = valueIndexLen * 4;
	
	return value;
}

/*
int CH4Reader_Internal_ReadTypePrefix(CH4Reader *reader)
{
	int rp_base = reader->rp;
	if(CH4Reader_Internal_Read4bitAtIndex(reader, rp_base) != 0x7){
		return CH4_TYPE_UINT;
	}
	if(CH4Reader_Internal_Read4bitAtIndex(reader, rp_base) != 0xF){
		return CH4_TYPE_UINT;
	}
	
}
*/
