#!/usr/bin/env python
# -*- coding: utf-8 -*-

import getpass
import sys
from getopt import getopt

from otp import Otp

usage = "%s -u <username> -p <password> [-l] <sid>" % sys.argv[0]

(opts, sids) = getopt(sys.argv[1:], "u:p:l")
if len(sids) < 1:
    sys.exit(usage)

user = ""
passwd = ""
get_body = True
get_imagelist = True

for (key, value) in opts:
    if key == "-u":
        user = value
    if key == "-p":
        passwd = value
    if key == "-l":
        get_body = False
    
otp = Otp()
if user == "":
    user = raw_input('user: ')
if passwd == "":
    passwd = getpass.getpass('password: ')

otp.login(user, passwd)

for sid in sids:
    if get_body:
        print >> sys.stderr, "retrive %s..." % sid
        title = otp.get_title(sid)
        intro = otp.get_intro(sid)
        bodytext = otp.get_bodytext(sid)

        fname = sid.replace("/", "-") + ".txt"
        f = open(fname, "w")
        f.write(title)
        f.write("\n")
        f.write(intro)
        f.write("\n")
        f.write(bodytext)
        f.close()
    if get_imagelist:
        print >> sys.stderr, "retrive imagelist %s..." % sid
        l = otp.get_imagelist(sid)
        fname = sid.replace("/", "-") + "_images.txt"
        f = open(fname, "w")
        for (blob, fname) in l:
            print >> f, "%s\t%s" % (blob, fname)
        f.close()
