#!/usr/bin/python
# -*- coding: utf-8 -*-

import urllib
import urllib2
import cookielib
import re
import sys

from poster.encode import multipart_encode
from poster.streaminghttp import register_openers
from BeautifulSoup import BeautifulSoup 

class SfjpAuthError(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

class Sfjp(object):
    url = 'https://sourceforge.jp/account/login.php';
    form_data = { 'return_to':'/',
                  'login':'1',
                  'form_loginname':'',
                  'form_pw':'',
              }
    headers = {
        'User-Agent':'Mozilla/5.0 (Windows; U; Windows NT 6.0; ja; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1',
        }
    def __init__(self):
        self.opener = None
        self.cookiejar = None
        self._rcache = None
        self._cached_url = ""

    def login(self, uname, passwd):
        data = dict(self.form_data)
        data['form_loginname'] = uname
        data['form_pw'] = passwd
        encoded_data = urllib.urlencode(data)
        req = urllib2.Request(self.url, encoded_data, self.headers)
        self.cookiejar = cookielib.CookieJar()
        self.opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self.cookiejar))
        resp = self.opener.open(req)
        for c in self.cookiejar:
            if c.name == 'username':
                if c.value:
                    return
        self.opener = None
        self.cookiejar = None
        raise SfjpAuthError('login failed')

    def _read(self, url):
        if self.opener:
            req = urllib2.Request(url)
            for k in self.headers:
                req.add_header(k, self.headers[k])
            resp = self.opener.open(req)
            return resp.read()
        else:
            raise SfjpAuthError('not logined')

    def get(self, url):
        return self._read(url)

class Wiki(Sfjp):
    def __init__(self):
        Sfjp.__init__(self)

    def login(self, uname, passwd):
        data = dict(self.form_data)
        data['form_loginname'] = uname
        data['form_pw'] = passwd
        encoded_data = urllib.urlencode(data)
        req = urllib2.Request(self.url, encoded_data, self.headers)
        self.cookiejar = cookielib.CookieJar()
        #self.opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self.cookiejar))
        self.opener = register_openers()
        self.opener.add_handler(urllib2.HTTPCookieProcessor(self.cookiejar))

        resp = self.opener.open(req)
        for c in self.cookiejar:
            if c.name == 'username':
                if c.value:
                    return
        self.opener = None
        self.cookiejar = None
        raise SfjpAuthError('login failed')

    def _edit_url(self, proj, pagename):
        return "http://sourceforge.jp/projects/%s/wiki/%s" % (proj, pagename)

    def post_attachment(self, proj, pagename, filename):
        url = self._edit_url(proj, pagename) + "/attach/!upload"
        data = {
            "new_attach":open(filename, "r"),
            "replace_file":"1",
            }
        (encoded_data, headers) = multipart_encode(data)
        if self.opener:
            req = urllib2.Request(url, encoded_data, headers)
            for k in self.headers:
                req.add_header(k, self.headers[k])
            resp = self.opener.open(req)
            return resp.read()
        else:
            raise SfjpAuthError('not logined')
        
    def edit_page(self, proj, pagename, title, text, comment=""):
        data = { 'text':text,
                      'comment':comment,
                      'title':title,
                      'commit':'1',
                      }
        url = self._edit_url(proj, pagename) + "?action=update"
        encoded_data = urllib.urlencode(data)
        req = urllib2.Request(url, encoded_data, self.headers)
        if self.opener:
            resp = self.opener.open(req)
            return resp.read()
        else:
            raise SfjpAuthError('not logined')


        
