﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MikuMikuMoving.Plugin;
using MikuMikuPlugin;
using DxMath;
using System.Diagnostics;
using System.IO;
using System.Xml.Serialization;
using System.Reflection;

namespace MMM_GraphEditor
{
    public class GraphEditor : IResidentPlugin, IHaveUserControl, ICanSavePlugin
    {
        public class Config
        {
            public bool[] render_flags = { true, true, true, true, true, true };
            public bool[] edit_flags = { true, true, false };
            public int euler_rot_order = 0;
            public bool track_marker = true;
            public bool track_yzero = false;
        }


        protected GraphEditorControl control { get; set; }
        private const string func_label = "Editor";
        private int refresh_counter = 0;
        public int refresh_div = 10;
        public Config config;

        public void Disabled()
        {
            this.control.Scene = null;
        }

        public void Enabled()
        {
            //throw new NotImplementedException();
        }

        public void Initialize()
        {
            this.config = new Config();
        }

        public void Update(float Frame, float ElapsedTime)
        {
            if (this.control != null && this.Scene != null && this.Scene.State.Equals(SceneState.Editing))
            {
                if (refresh_counter % refresh_div == 0)
                {
                    this.refresh_counter = 0;
                    this.control.Scene = this.Scene;
                    this.control.Refresh();
                }
                this.refresh_counter++;
            }
        }

        public System.Windows.Forms.IWin32Window ApplicationForm { get; set; }

        public string Description
        {
            get { return "Graph "+ func_label +" Plugin"; }
        }

        public Guid GUID
        {
            get { return new Guid("70aa3704-075e-11e3-aa77-a7f2b782a7bd"); }
        }

        public void Dispose()
        {
            this.control.Scene = null;
        }

        public string EnglishText
        {
            get { return "Graph" + Environment.NewLine + func_label; }
        }

        public System.Drawing.Image Image
        {
            get { return MMM_GraphEditor.Properties.Resources.mmm_graph_icon36; }
        }

        public System.Drawing.Image SmallImage
        {
            get { return MMM_GraphEditor.Properties.Resources.mmm_graph_icon24; }
        }

        public string Text
        {
            get { return "Graph" + Environment.NewLine +  func_label; }
        }

        public MikuMikuPlugin.Scene Scene { get; set; }

        public System.Windows.Forms.UserControl CreateControl()
        {
            this.control = new GraphEditorControl();
            this.control.config = this.config;
            this.control.UpdateUIStateByConfig();
            return this.control;
        }

        /// <summary>
        /// プロジェクトへプラグインデータを保存する。
        /// プロジェクトが保存されたときに呼び出されます。
        /// なお、気持ち悪いかもしれませんがStreamは外でDisposeされます。
        /// </summary>
        /// <returns></returns>
        public Stream OnSaveProject()
        {
            MemoryStream stream = new MemoryStream();
            XmlSerializer serializer = new XmlSerializer(typeof(Config));
            serializer.Serialize(stream, config);
            return stream;
        }

        /// <summary>
        /// プロジェクトからプラグインデータを読み込む。
        /// プロジェクトがロードされたときに呼び出されます。
        /// なお、気持ち悪いかもしれませんがStreamは外でDisposeされます。
        /// </summary>
        /// <param name="stream">データStream</param>
        public void OnLoadProject(Stream stream)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(Config));

            try
            {
                Config loadconf = (Config)serializer.Deserialize(stream);
                Type t = typeof(Config);
                foreach (MemberInfo m in t.GetMembers())
                {
                    if (m.MemberType != MemberTypes.Field) continue;
                    FieldInfo f = t.GetField(m.Name, BindingFlags.Public | BindingFlags.Instance);
                    f.SetValue(this.config, f.GetValue(loadconf));
                }
                control.UpdateUIStateByConfig();
            }
            catch (Exception)
            {
                // ignore
                return;
            }
            finally
            {
                //やらなくてもいいですが、まあ一応。
                stream.Seek(0, SeekOrigin.Begin);
            }
        }
    }
}
