require 'bundler/capistrano'

set :stages, %w(production homedev)
set :default_stage, "homedev"
require 'capistrano/ext/multistage'

set :application, "NVC Serv"
set :repository, "git://git.pf.sourceforge.jp/gitroot/h/hm/hmml/nvc_serv.git"
set :scm, :git
set :branch, 'master'
set :rails_env, :production

# set :scm, :git # You can set :scm explicitly or Capistrano will make an intelligent guess based on known version control directory names
# Or: `accurev`, `bzr`, `cvs`, `darcs`, `git`, `mercurial`, `perforce`, `subversion` or `none`

#role :web, "localhost"                          # Your HTTP server, Apache/etc
#role :app, "localhost"                          # This may be the same as your `Web` server
#role :db,  "localhost", :primary => true # This is where Rails migrations will run

# if you want to clean up old releases on each deploy uncomment this:
# after "deploy:restart", "deploy:cleanup"

after 'deploy:update_code', 'deploy:migrate'
before "deploy", "deploy:setup"


# if you're still using the script/reaper helper you will need
# these http://github.com/rails/irs_process_scripts

# If you are using Passenger mod_rails uncomment this:
namespace :deploy do
  task :start do ; end
  task :stop do ; end
  task :restart, :roles => :app, :except => { :no_release => true } do
    run "touch #{File.join(current_path,'tmp','restart.txt')}"
  end
end
