class RatingsController < ApplicationController
  include IpHashUtil
  skip_before_filter :verify_authenticity_token

  # GET /ratings
  # GET /ratings.xml
  def index
    @ratings = Rating.all
    respond_with(@ratings)
  end

  # GET /ratings/1
  # GET /ratings/1.xml
  def show
    @rating = Rating.find(params[:id])
    respond_with(@rating)
  end

  # GET /ratings/new
  # GET /ratings/new.xml
  def new
    @rating = Rating.new
    respond_with(@rating)
  end

  # GET /ratings/1/edit
  def edit
    @rating = Rating.find(params[:id])
  end

  # POST /ratings
  # POST /ratings.xml
  def create
    @rating = Rating.new(rating_params)
    @rating.navi_voice_id = params[:navi_voice_id]
    @rating.ip_hash = gen_ip_hash
    @rating.save
    respond_with @rating, location: navi_voice_path(params[:navi_voice_id])
  end

  # PUT /ratings/1
  # PUT /ratings/1.xml
  def update
    raise_error_403
    @rating = Rating.find(rating_params)
    flash[:notice] = 'Rating was successfully updated.' if @rating.update(params[:rating])
    respond_with(@rating)
  end

  # DELETE /ratings/1
  # DELETE /ratings/1.xml
  def destroy
    raise_error_403
    @rating = Rating.find(params[:id])
    @rating.destroy
    respond_with(@rating)
  end

  private
  def rating_params
    params.require(:rating).permit(:value, :ident)
  end
end
