class DlLogEntriesController < ApplicationController
  include IpHashUtil
  skip_before_filter :verify_authenticity_token

  # GET /dl_log_entries
  # GET /dl_log_entries.xml
  def index
    @dl_log_entries = DlLogEntry.all
    respond_with(@dl_log_entries)
  end

  # GET /dl_log_entries/1
  # GET /dl_log_entries/1.xml
  def show
    raise_error_400
    @dl_log_entry = DlLogEntry.find(params[:id])
    respond_with(@dl_log_entry)
  end

  # GET /dl_log_entries/new
  # GET /dl_log_entries/new.xml
  def new
    raise_error_400
    @dl_log_entry = DlLogEntry.new
    respond_with(@dl_log_entry)
  end

  # GET /dl_log_entries/1/edit
  def edit
    raise_error_400
    @dl_log_entry = DlLogEntry.find(params[:id])
  end

  # POST /dl_log_entries
  # POST /dl_log_entries.xml
  def create
    @dl_log_entry = DlLogEntry.new(dl_log_entry_params)
    @dl_log_entry.navi_voice_id = params[:navi_voice_id]
    @dl_log_entry.ip_hash = gen_ip_hash
    @dl_log_entry.save
    respond_with @dl_log_entry, location: navi_voice_path(params[:navi_voice_id])
  end

  # PUT /dl_log_entries/1
  # PUT /dl_log_entries/1.xml
  def update
    raise_error_400
    @dl_log_entry = DlLogEntry.find(params[:id])
    @dl_log_entry.update(dl_log_entry_params)
    respond_with(@dl_log_entry)
  end

  # DELETE /dl_log_entries/1
  # DELETE /dl_log_entries/1.xml
  def destroy
    raise_error_400
    @dl_log_entry = DlLogEntry.find(params[:id])
    @dl_log_entry.destroy
    respond_with(@dl_log_entry)
  end

  def dl_log_entry_params
    params.require(:dl_log_entry).permit(:ident)
  end
end
