namespace :update_ratings do
  desc 'Update all ratings of NaviVoice'
  task :all => :environment do
    NaviVoice.all.each do |nv|
      nv.update_rating
    end
  end
  task :recent => :environment do
    nvids = Rating.where('created_at > ?', Time.now - 1.day).
      group(:navi_voice_id).map {|n| n.navi_voice_id }
    nvids.blank? and next
    NaviVoice.where(id: nvids).each do |nv|
      nv.update_rating
    end
  end
end

desc 'Update all rating of NaviVoice'
task :update_ratings => 'update_ratings:recent'
