#!/usr/bin/python

import re
import tweepy
from followerdb import FollowerDB
from tweetdb import TweetDB, Tweet
from updaterequest import receive_request

def get_image_url(url):
    if url.find("twitpic.com/") == 0:
        fig_id = url.replace("twitpic.com/", "")
        return "http://twitpic.com/show/large/" + fig_id
    elif url.find("yfrog.com/") == 0:
        fig_id = url.replace("yfrog.com/", "")
        return "http://yfrog.com/" + fig_id + ":iphone"
    else:
        return ""

def get_timeline(tweetdb, uid, last_id):
    api = tweepy.api
    st = api.user_timeline(uid, include_entities=True)
    read_id = last_id
    print "get timeline for " + uid
    for s in st:
        if s.id <= last_id:
            continue
        if read_id < s.id:
            read_id = s.id
        if s.entities.has_key("urls"):
            for url in s.entities["urls"]:
                media_url = get_image_url(url["display_url"])
                if len(media_url) > 0:
                    tw = Tweet(media_url, uid, s.id, s.created_at, s.text, "http://" + url["display_url"])
                    tweetdb.append(tw)
                    print("add tweet: '%s'(%d) by %s" % 
                                (s.text, s.id, uid))
        
        if s.entities.has_key("media"):
            for media in s.entities["media"]:
                url = media.get("media_url", "")
                if len(url) > 0:
                    tw = Tweet(url, uid, s.id, s.created_at, s.text, media.get("expanded_url", ""))
                    tweetdb.append(tw)
                    print("add tweet: '%s'(%d) by %s" % 
                                (s.text, s.id, uid))
    return read_id

def main():
    f_db = FollowerDB()
    f_db.load_from_db()
    t_db = TweetDB()
    t_db.load_from_db()

    uid = receive_request()
    while len(uid) > 0:
        last_id = f_db.get_last_id(uid)
        read_id = get_timeline(t_db, uid, last_id)
        t_db.create_cache()
        f_db.update(uid, read_id)
        uid = receive_request()

if __name__ == "__main__":
    main()
