#!/usr/bin/python

import tweepy
from userdb import UserDB
from tweetdb import FiguredTweetDB, FiguredTweet

test_users = """mesotokyo
tatsuya0324
yokotamamoru
arisa_0325
watch_akiba""".split("\n")

#test_users = ["mesotokyo"]

storage_account = "figureaggr"
storage_key = """nwchdWxFfCuDgHAe2Exk70XpqfEuFkMzphT7rAFl/3/JByJU3kDrh/nCw+J0p+kYEt8p/LXRPBZX6GM8fjviGA=="""

api = tweepy.api

def get_timeline(mstore, user_id, last_id=None):
    st = api.user_timeline(user_id, include_entities=True)
    read_id = None
    print "get timeline for " + user_id
    for s in st:
        if last_id is not None and s.id == last_id:
            break
        read_id = last_id
        if s.entities.has_key("media"):
            for media in s.entities["media"]:
                url = media.get("media_url", "")
                if len(url) > 0:
                    mt = FiguredTweet(url, user_id, s.id, s.created_at, s.text)
                    mstore.append(mt)
    return read_id

def main():
    ustore = UserDB()
    for u in test_users:
        ustore.append_user(u, None)

    mstore = FiguredTweetDB()

    for user_id in ustore:
        last_id = ustore.get_last_id(user_id)
        read_id = get_timeline(mstore, user_id, last_id)
        ustore.update(user_id, read_id)

    for mt in mstore:
        print mt.tweet_id, mt.user_id, mt.created_at, mt.image_url, mt.text
    

if __name__ == "__main__":
    main()
