#!/usr/bin/python
# -*- coding: utf-8 -*-


from winazurestorage import CLOUD_QUEUE_HOST, QueueStorage
import wazs
from config import config

def update_request(user_id):
    st = QueueStorage(CLOUD_QUEUE_HOST,
                      config["storage_account"],
                      config["storage_key"])
    st.put_message(config["get_request_queue"],
                   user_id)

def receive_request():
    st = QueueStorage(CLOUD_QUEUE_HOST,
                      config["storage_account"],
                      config["storage_key"])
    req = st.get_message(config["get_request_queue"])
    if req:
        st.delete_message(config["get_request_queue"], req)
        return req.text
    else:
        return ""
